xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

/*check if anything is selected*/
oSelection = xdoc~XModel~getCurrentSelection()

xIndexAccess = oSelection~XIndexAccess
size = xIndexAccess~getCount()

oSelection_noncollapsed = .array~new

/*check whether the selections are collapsed - we use a text cursor that covers the range*/
do i=1 to size
	oSel = xIndexAccess~getByIndex(i-1)~XTextRange
	oCursor = xdoc~XTextDocument~getText()~createTextCursorByRange(oSel)
	if \ oCursor~isCollapsed() then
	do
		oSelection_noncollapsed~append(oSel)
	end
end

/*if we have no uncollapsed selection, we take the whole document as selection*/
if oSelection_noncollapsed~items == 0 then
do
	if .bsf.dialog~dialogBox("No selection found. Traverse whole document?", ,"Warning","YesNo") then
		EXIT

	xDocTextRange = xdoc~XTextDocument~getText()~XTextRange

	if \ xdoc~XTextDocument~getText()~createTextCursorByRange(xDocTextRange)~isCollapsed then
		oSelection_noncollapsed~append(xDocTextRange)
	else
	do
		.bsf.dialog~messageBox("You seem to have provided an empty text. Exiting.")
		EXIT
	end
end

/*initialization of the search&replace-options*/
xSearchDescriptor = xdoc~XModel~XSearchable

/*create search descriptor and set its values*/
oSearch = xSearchDescriptor~createSearchDescriptor()
oSearch~setSearchString(.bsf.dialog~inputBox("Enter text to be searched.",,"question"))

sReplace = .bsf.dialog~inputBox("Enter replacement text.",,"question")


/*set option for the search descriptor*/
oSearch~XPropertySet~setPropertyValue("SearchCaseSensitive",box("boolean",.false))


/*we now check all XTextRanges in the oSelection_noncollapsed array for white spaces*/
/*note that for clarity we don't perform a direction check here for the XTextRanges introduced in example 03, although it would be useful*/
size = oSelection_noncollapsed~items
do i=1 to size
	oSel = oSelection_noncollapsed~at(i)

	/*obtain a text cursor over the range*/
	oLeftRange = oSel~getStart()
	oRightRange = oSel~getEnd()
	oLeftCursor = xdoc~XTextDocument~getText~createTextCursorByRange(oLeftRange)
	oRightCursor = xdoc~XTextDocument~getText~createTextCursorByRange(oRightRange)
	/*go to start of cursor and "initialize" it*/
	oLeftCursor~collapseToStart()
	oLeftCursor~goRight(0,.false)

	/*we now search for the next occurance after the text cursor*/
	vFound = xSearchDescriptor~findNext(oLeftCursor,oSearch)

	do while vFound<>.nil
		if xdoc~XTextDocument~getText()~XTextRangeCompare~compareRegionEnds(vFound~XTextRange, oRightCursor~XTextRange)<>-1 then
		do
			vFound~XTextRange~setString(sReplace)
			vFound = xSearchDescriptor~findNext(oLeftCursor,oSearch)
		end
		else
		leave
	end
	
end


::REQUIRES UNO.cls

	
