xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

xMSF = xdoc~XMultiServiceFactory

oText = xdoc~XTextDocument~getText()

oMasters = xdoc~XTextFieldsSupplier~getTextFieldMasters()

sName = "ChristophField"
sLead = "com.sun.star.text.FieldMaster.User"

/*if master already exists, special handling
 *otherwise error when setting name - can only be set BEFORE inserting!*/

if oMasters~hasByName(sLead||"."||sName) then
do
	if .bsf.dialog~dialogBox("Master already existent. Delete?", ,"Warning","YesNo") then
	do
		.bsf.dialog~messageBox("Nothing to do. Exiting.")
		EXIT
	end
	else
	do
		oMasterField = oMasters~getByName(sLead||.||sName)
		oMasterField~XComponent~dispose()
	end
end

/*create a user text field that requires a master field*/
oUField = xMSF~createInstance("com.sun.star.text.TextField.User")

/*get for the master field*/
oMasterField = xMSF~createInstance(sLead)

/*set name, it can't bet set or changed after insertion into document*/
oMasterField~XPropertySet~setPropertyValue("Name",sName)

/*set content, the master field tells the field what to display*/
oMasterField~XPropertySet~setPropertyValue("Content","Hello, this is a test field")

/*attach the master field to the field, it is now dependent*/
oUField~XDependentTextField~attachTextFieldMaster(oMasterField~XPropertySet)

/*insert field field*/
oText~insertTextContent(oText~XTextRange~getEnd(),oUField~XTextContent,.false)
::requires UNO.cls


