xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

xMCF = xcc~getServiceManager()

xMSF = xdoc~XMultiServiceFactory

/*an example of how to modify formula properties*/
fontsize=.array~of(12,18)

do i=1 to 2

a=RANDOM(2,10)
b=RANDOM(1,4)

c=a**2+b**2

sFormula = a||"^2 +" b||"^2 =" c

xController = xdoc~XModel~getCurrentController()
oViewCursor = xController~XTextViewCursorSupplier~getViewCursor()

oObj = xMSF~createInstance("com.sun.star.text.TextEmbeddedObject")
oObj~XPropertySet~setPropertyValue("CLSID","078B7ABA-54FC-457F-8551-6147e776a997")
oObj~XPropertySet~setPropertyValue("AnchorType",bsf.getStaticValue("com.sun.star.text.TextContentAnchorType","AS_CHARACTER"))

xText = oViewCursor~XTextRange~getText()
xText~insertTextContent(oViewCursor~XTextRange, oObj~XTextContent, .false)

xFormula = oObj~XEmbeddedObjectSupplier~getEmbeddedObject()
xFormula~XPropertySet~setPropertyValue("Formula",sFormula)

/*set the property*/
xFormula~XPropertySet~setPropertyValue("BaseFontHeight",box("SH",fontsize[i]))

end

/*all adaptable properties can be listed using the following code lines*/
--props = uno.getProperties(xFormula)~makeArray(" ")~toString
--xText~XSimpleText~insertString(oViewCursor~XTextRange,props,.false)

/*let's count the formulas in the document*/
s=""
oEmbed = xdoc~XTextEmbeddedObjectsSupplier~getEmbeddedObjects()

do i=1 to oEmbed~XIndexAccess~getCount()
	oCurObj = oEmbed~XIndexAccess~getByIndex(i-1)
	if oCurObj~XServiceInfo~supportsService("com.sun.star.text.TextEmbeddedObject") then
	do
		if oCurObj~XPropertySet~getPropertyValue("CLSID")=="078B7ABA-54FC-457F-8551-6147e776a997" then
		do
			xCurFormula = oCurObj~XEmbeddedObjectSupplier~getEmbeddedObject()
			s = s xCurFormula~XPropertySet~getPropertyValue("Formula") .ENDOFLINE
		end
	end
end

.bsf.dialog~messageBox(s)
::requires UNO.cls

