xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

/*we need the style "Ergebnis" and "berschrift" for conditional formatting - check whether they are present*/
/*procedure as in Frysak2008*/
aStyles=.array~of("red","green")
xStyleFamilies = xdoc~XStyleFamiliesSupplier~getStyleFamilies()
/*in OOo.org Calc there are 2 style families: CellStyles and PageStyles*/
xStyleFamily = xStyleFamilies~getByName("CellStyles")

do i=1 to aStyles~items
if xStyleFamily~XNameAccess~hasByName(aStyles[i])==0 then
do
	.bsf.dialog~messageBox("Style" aStyles[i] "not present. Exiting")
	EXIT
end
end



/*select procedure as in Frysak2008*/
/*currently selected sheet*/
oSheet = xdoc~XModel~getCurrentController()~XSpreadsheetView~getActiveSheet()

oRange = oSheet~XSheetCellRange~getCellRangeByName("B1:D10")

/**VALIDATION**/
/*get the validation object
 *alternatively we can create a PropertySet*/
oValidation = oRange~XPropertySet~getPropertyValue("Validation")

/*configure the validation range*/
oValidationProps = oValidation~XPropertySet
oValidationProps~setPropertyValue("Type",bsf.getStaticValue("com.sun.star.sheet.ValidationType","DECIMAL"))
oValidationProps~setPropertyValue("ErrorMessage","Please enter a number between one and ten.")
oValidationProps~setPropertyValue("ErrorTitle","Wrong Input Range.")
oValidationProps~setPropertyValue("ShowErrorMessage",box("boolean",.true))
oValidationProps~setPropertyValue("ErrorAlertStyle",bsf.getStaticValue("com.sun.star.sheet.ValidationAlertStyle","STOP"))
oValidationProps~setPropertyValue("ShowInputMessage",box("boolean",.true))
oValidationProps~setPropertyValue("InputMessage","Number 1 to 10.")
oValidationProps~setPropertyValue("InputTitle","Hint")
oValidation~XSheetCondition~setOperator(bsf.getStaticValue("com.sun.star.sheet.ConditionOperator","BETWEEN"))

/*decimal numbers have to be entered using a point, they are converted to the correct format in OOo.org*/
oValidation~XSheetCondition~setFormula1(1.4)
oValidation~XSheetCondition~setFormula2(10)

oRange~XPropertySet~setPropertyValue("Validation",oValidation)

/**CONDITIONAL FORMATTING**/
/*set a conditional formatting to the cells seelcted abovs
 *get the conditional formatting object*/

oCondFormat = oRange~XPropertySet~getPropertyValue("ConditionalFormat")

/*build up the conditions that have to apply*/
oFirstCondition = uno.createArray(.UNO~PROPERTYVALUE,3)
oFirstCondition[1] = uno.createProperty("Operator",bsf.getStaticValue("com.sun.star.sheet.ConditionOperator","LESS"))
oFirstCondition[2] = uno.createProperty("Formula1",5)
oFirstCondition[3] = uno.createProperty("StyleName",aStyles[1])

oCondFormat~XSheetConditionalEntries~addNew(oFirstCondition)

oSecondCondition = uno.createArray(.UNO~PROPERTYVALUE,3)
oSecondCondition[1] = uno.createProperty("Operator",bsf.getStaticValue("com.sun.star.sheet.ConditionOperator","EQUAL"))
oSecondCondition[2] = uno.createProperty("Formula1",10)
oSecondCondition[3] = uno.createProperty("StyleName",aStyles[2])

oCondFormat~XSheetConditionalEntries~addNew(oSecondCondition)

oRange~XPropertySet~setPropertyValue("ConditionalFormat",oCondFormat)




::requires UNO.cls

