xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

sRange = "A1:F5"

/*select procedure as in Frysak2008*/
/*currently selected sheet*/
oSheet = xdoc~XModel~getCurrentController()~XSpreadsheetView~getActiveSheet()
oRange = oSheet~XSheetCellRange~getCellRangeByName(sRange)

/*use of the CellAddressConversion service to get human readable cell addresses*/
oConversion = xMSF~createInstance("com.sun.star.table.CellAddressConversion")
oFlags = .array~of( -
	bsf.getStaticValue("com.sun.star.sheet.CellFlags","VALUE"), -
	bsf.getStaticValue("com.sun.star.sheet.CellFlags","FORMULA"), -
	bsf.getStaticValue("com.sun.star.sheet.CellFlags","STRING"), -
	bsf.getStaticValue("com.sun.star.sheet.CellFlags","DATETIME") -
)

/*sum up*/
sSum=0
do i=1 to oFlags~items
	sSum = sSum + oFlags~at(i)
end

oRanges = oRange~XCellRangesQuery~queryContentCells(sSum)

oAddrs = oRanges~getCells()~XEnumerationAccess~createEnumeration()
s="Nonempty cells of" sRange .ENDOFLINE
do while oAddrs~hasMoreElements
	oCell = oAddrs~nextElement
	/*convert to human readable format*/
	oCellAddress = oCell~XCellAddressable~getCellAddress()
	oConversion~XPropertySet~setPropertyValue("Address",oCellAddress)
	s = s oConversion~XPropertySet~getPropertyValue("UserInterfaceRepresentation") .ENDOFLINE
end

.bsf.dialog~messageBox(s)

::requires UNO.cls
