xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

/*select procedure as in Frysak2008*/
/*currently selected sheet*/
oSheet = xdoc~XModel~getCurrentController()~XSpreadsheetView~getActiveSheet()
/*obtain current sheet name and number*/
iSheetNumber = oSheet~XCellRangeAddressable~getRangeAddress()~bsf.getFieldValue("Sheet")
sSheetName = oSheet~XNamed~getName()

/*for cell address conversion*/
oConversion = xMSF~createInstance("com.sun.star.table.CellAddressConversion")

/*getCellFormatRanges()*/
s = "*** getCellFormatRanges() ***" .ENDOFLINE
oRanges = oSheet~XCellFormatRangesSupplier~getCellFormatRanges()

do i = 1 to oRanges~XIndexAccess~getCount()
	oRange = oRanges~XIndexAccess~getByIndex(i-1)
	oAddr = oRange~XCellRangeAddressable~getRangeAddress()
	oStartAddr = .bsf~new("com.sun.star.table.CellAddress")
	oStartAddr~bsf.setFieldValue("Sheet",iSheetNumber)
	oStartAddr~bsf.setFieldValue("Column",oAddr~bsf.getFieldValue("StartColumn"))
	oStartAddr~bsf.setFieldValue("Row",oAddr~bsf.getFieldValue("StartRow"))
	oEndAddr = .bsf~new("com.sun.star.table.CellAddress")
	oEndAddr~bsf.setFieldValue("Sheet",iSheetNumber)
	oEndAddr~bsf.setFieldValue("Column",oAddr~bsf.getFieldValue("EndColumn"))
	oEndAddr~bsf.setFieldValue("Row",oAddr~bsf.getFieldValue("EndRow"))

	s = s i||":" sSheetName||"."
	/*convert start address*/
	oConversion~XPropertySet~setPropertyValue("Address",oStartAddr)
	s= s||oConversion~XPropertySet~getPropertyValue("UserInterfaceRepresentation")
	/*convert end address*/
	oConversion~XPropertySet~setPropertyValue("Address",oEndAddr)
	s= s ||":"|| oConversion~XPropertySet~getPropertyValue("UserInterfaceRepresentation") .ENDOFLINE
end
s= s .ENDOFLINE

/*getUniqueCellFormatRanges()*/
s = s "*** getUniqueCellFormatRanges() ***" .ENDOFLINE
oRanges = oSheet~XUniqueCellFormatRangesSupplier~getUniqueCellFormatRanges()

do i=1 to oRanges~XIndexAccess~getCount()
	oRangeContainer = oRanges~XIndexAccess~getByIndex(i-1)
	s = s i||":" oRangeContainer~XSheetCellRanges~getRangeAddressesAsString() .ENDOFLINE
end

.bsf.dialog~messageBox(s)

::requires UNO.cls


