xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

/*select procedure as in Frysak2008*/
/*currently selected sheet*/
oSheet = xdoc~XModel~getCurrentController()~XSpreadsheetView~getActiveSheet()

/**SIMPLE FILL**/
call uno.setCell oSheet,"A1","simple increment every 2nd cell"
sRange = "B1:L1"
oRange = oSheet~XSheetCellRange~getCellRangeByName(sRange)

/*set start value*/
call uno.setCell oSheet,"B1",8

/*simple increment fill in every 2nd cell*/
oRange~XCellSeries~fillAuto(bsf.getStaticValue("com.sun.star.sheet.FillDirection","TO_RIGHT"),2)

/**CONSTANT FILL**/
call uno.setCell oSheet,"A2","simple constant each cell from left"
sRange = "B2:L2"
oRange = oSheet~XSheetCellRange~getCellRangeByName(sRange)

/*set start value*/
call uno.setCell oSheet,"L2",13

/*simple constant fill in each cell from left*/
oRange~XCellSeries~fillSeries(-
	bsf.getStaticValue("com.sun.star.sheet.FillDirection","TO_LEFT"),-
	bsf.getStaticValue("com.sun.star.sheet.FillMode","SIMPLE"),-
	bsf.getStaticValue("com.sun.star.sheet.FillDateMode","FILL_DATE_YEAR"),-
	1,10000)


/**INCREMENT OF MONTH**/
call uno.setCell oSheet,"A3","increment of months"
sRange = "B3:L3"
oRange = oSheet~XSheetCellRange~getCellRangeByName(sRange)

/*set start value*/
date = DATE()
call uno.setCell oSheet,"B3", date

/*simple constant fill in each cell from left*/
oRange~XCellSeries~fillSeries(-
	bsf.getStaticValue("com.sun.star.sheet.FillDirection","TO_RIGHT"),-
	bsf.getStaticValue("com.sun.star.sheet.FillMode","DATE"),-
	bsf.getStaticValue("com.sun.star.sheet.FillDateMode","FILL_DATE_MONTH"),-
	3,50000)

/*we also have to define the cell format as DATE*/
/*retrieve the standard DATE format*/
/*we have to define the locale*/
oLocale = .bsf~new("com.sun.star.lang.Locale")
oLocale~bsf.setFieldValue("Country","USA")
oLocale~bsf.setFieldValue("Language","en")
oNumberFormats = xdoc~XNumberFormatsSupplier~getNumberFormats()
iFormatIndex = oNumberFormats~XNumberFormatTypes~getStandardFormat(bsf.getStaticValue("com.sun.star.util.NumberFormat","DATE"),oLocale)
oRange~XPropertySet~setPropertyValue("NumberFormat",box("i",iFormatIndex))

/**GEOMETRIC SERIES FROM TOP**/
call uno.setCell oSheet,"A4","geometric series from top to bottom"
sRange = "A5:A40"
oRange = oSheet~XSheetCellRange~getCellRangeByName(sRange)

/*set start value*/
call uno.setCell oSheet,"A5", 1

/*simple constant fill in each cell from left*/
oRange~XCellSeries~fillSeries(-
	bsf.getStaticValue("com.sun.star.sheet.FillDirection","TO_BOTTOM"),-
	bsf.getStaticValue("com.sun.star.sheet.FillMode","GROWTH"),-
	bsf.getStaticValue("com.sun.star.sheet.FillDateMode","FILL_DATE_MONTH"),-
	5,100000)

::requires UNO.cls

