xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

/*select procedure as in Frysak2008*/
/*currently selected sheet*/
oSheet = xdoc~XModel~getCurrentController()~XSpreadsheetView~getActiveSheet()

/**SIMPLE ARRAY FORMULA EXAMPLE**/
/*first create some input data*/
/*see listing 22 "AutomaticFills.rex" for details*/
sRange = "A2:B11"
oRange = oSheet~XSheetCellRange~getCellRangeByName(sRange)
call uno.setCell oSheet,"A1","a"
call uno.setCell oSheet,"B1","b"
call uno.setCell oSheet,"A2",1
call uno.setCell oSheet,"B2",10
oRange~XCellSeries~fillAuto(bsf.getStaticValue("com.sun.star.sheet.FillDirection","TO_BOTTOM"),1)

/*now set the array formula*/
call uno.setCell oSheet,"C1","a*b"
oResultRange = oSheet~XSheetCellRange~getCellRangeByName("C2:C11")
oResultRange~XArrayFormulaRange~setArrayFormula("=A2:A11*B2:B11")

/**EXAMPLE: FREQUENCY ARRAY FUNCTION**/
sRange = "A2:C11"
oRange = oSheet~XSheetCellRange~getCellRangeByName(sRange)

call uno.setCell oSheet,"A15","Frequencies"
call uno.setCell oSheet,"A16",5
call uno.setCell oSheet,"A17",15
call uno.setCell oSheet,"A18",25
call uno.setCell oSheet,"A19","larger"

/*now set the array formula*/
call uno.setCell oSheet,"C1","a*b"
oResultRange = oSheet~XSheetCellRange~getCellRangeByName("B16:B19")
oResultRange~XArrayFormulaRange~setArrayFormula("=FREQUENCY(A2:C11;A16:A18)")

::requires UNO.cls

