xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

xMCF = xcc~getServiceManager()

xMSF = xdoc~XMultiServiceFactory

/*select procedure as in Frysak2008*/
/*currently selected sheet*/
oSheet = xdoc~XModel~getCurrentController()~XSpreadsheetView~getActiveSheet()

/**ONE VARIABLE**/
/*first create some input data*/
/*see listing 22 "AutomaticFills.rex" for details*/
oRange = oSheet~XSheetCellRange~getCellRangeByName("A2:A100")
call uno.setCell oSheet,"A1","Value"
call uno.setCell oSheet,"A2",0
oRange~XCellSeries~fillSeries(-
	bsf.getStaticValue("com.sun.star.sheet.FillDirection","TO_BOTTOM"),-
	bsf.getStaticValue("com.sun.star.sheet.FillMode","LINEAR"),-
	bsf.getStaticValue("com.sun.star.sheet.FillDateMode","FILL_DATE_DAY"),-
	0.1,6.4)

/*set header for formula*/
call uno.setCell oSheet,"B1","sin()"
call uno.setCell oSheet,"C1","cos()"

/*set formulas*/
call uno.setCell oSheet,"B2","=sin(A2)"
call uno.setCell oSheet,"C2","=cos(A2)"

/*get entire block to operate on*/
oRange = oSheet~XSheetCellRange~getCellRangeByName("A3:C66")

/*get the formula addresses*/
oBlockAddress = oSheet~XSheetCellRange~getCellRangeByName("B2:C2")~XCellRangeAddressable~getRangeAddress()

oCellAddress = oSheet~getCellByPosition(0,1)~XCellAddressable~getCellAddress()

oRange~XMultipleOperation~setTableOperation(-
	oBlockAddress,-
	bsf.getStaticValue("com.sun.star.sheet.TableOperationMode","COLUMN"),-
	oCellAddress,oCellAddress)

/**TWO VARIABLES**/
/*first create some input data*/
/*see listing 22 "AutomaticFills.rex" for details*/
call uno.setCell oSheet,"E1","=F1*E2"
call uno.setCell oSheet,"E2","1"
call uno.setCell oSheet,"F1","1"
oRange = oSheet~XSheetCellRange~getCellRangeByName("E2:E11")
oRange~XCellSeries~fillAuto(bsf.getStaticValue("com.sun.star.sheet.FillDirection","TO_BOTTOM"),1)
oRange = oSheet~XSheetCellRange~getCellRangeByName("F1:O1")
oRange~XCellSeries~fillAuto(bsf.getStaticValue("com.sun.star.sheet.FillDirection","TO_RIGHT"),1)

/*get the referenced cells*/
oRowCellAddress = oSheet~getCellByPosition(5,0)~XCellAddressable~getCellAddress()
oColCellAddress = oSheet~getCellByPosition(4,1)~XCellAddressable~getCellAddress()

/*get entire block to operate on*/
oRange = oSheet~XSheetCellRange~getCellRangeByName("E1:O11")

oRange~XMultipleOperation~setTableOperation(-
	oRange~XCellRangeAddressable~getRangeAddress(),-
	bsf.getStaticValue("com.sun.star.sheet.TableOperationMode","BOTH"),-
	oColCellAddress,-
	oRowCellAddress)
::requires UNO.cls

