xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

/*get active sheet*/
oController = xdoc~XModel~getCurrentController()
oSheet=oController~XSpreadsheetView~getActiveSheet()

enumFormula = bsf.getConstant("com.sun.star.table.CellContentType","FORMULA")

/*show precedents of a formula cell - get currently selected cell*/

oSelection = oController~XSelectionSupplier~getSelection()

if \ uno.supportsService(oSelection,SheetCellRange) then
do
	.bsf.dialog~messageBox("Selection must be a cell.")
	exit
end

oCell = oSelection~XCellRange~getCellByPosition(0,0)
stCellAddress = oCell~XCellAddressable~getCellAddress()

/*clear existing arrows*/
oSheet~XSheetAuditing~clearArrows()

/*is it a formula cell?*/
if UNO.areSame(oCell~getType(),enumFormula) then
do	
	/*show precedents of a formula cell*/
	loop until ret==0
	ret = oSheet~XSheetAuditing~showPrecedents(stCellAddress)
	end
end
else
do
	.bsf.dialog~messageBox("You must specify a formula cell to show precedents")
end

.bsf.dialog~messageBox("Precedents shown. Now going to show dependents.")
oSheet~XSheetAuditing~clearArrows()

/*show dependents of a formula cell*/
loop until ret==0
ret = oSheet~XSheetAuditing~showDependents(stCellAddress)
end

::requires UNO.cls
