xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

/*counter variables to document changes*/
iEmbedded =0
iLinked=0
iConverted=0

/*two forms of graphic objects are supported*/
s1="com.sun.star.drawing.GraphicObjectShape"
s2="com.sun.star.text.TextGraphicObject"

/*get the document's draw page*/
oDrawPage = xdoc~XDrawPageSupplier~getDrawPage()

/*create the linked array*/
aLinked = .array~new

do i=1 to oDrawPage~XIndexAccess~getCount()
	oGraph = oDrawPage~XIndexAccess~getByIndex(i-1)

	/*look whether object supports GraphicObjectShape service*/
	if (oGraph~XServiceInfo~supportsService(s1) | oGraph~XServiceInfo~supportsService(s2)) then
	do
		if oGraph~XPropertySet~getPropertyValue("GraphicURL")~pos("vnd.sun") <> 0 then
		do
			iEmbedded = iEmbedded+1
		end
		else
		do
			iLinked = iLinked+1
			aLinked~append(oGraph)
		end
	end
end

do i=1 to aLinked~items
	oGraph = aLinked~at(i)
	/*convert a TextGraphicObject*/
	sName=.DateTime~new~~fullDate~string
	oBitmaps = xMSF~createInstance("com.sun.star.drawing.BitmapTable")
	do while oBitmaps~XNameContainer~XElementAccess~hasByName(sName)
		sName = .bsf.dialog~inputBox("Name" sName "already exists.Please enter alternative link display name.",sName)
	end
	oBitmaps~XNameContainer~insertByName(sName,oGraph~XPropertySet~getPropertyValue("GraphicURL"))
	sNewURL = oBitmaps~XNameContainer~XElementAccess~getByName(sName)
	oGraph~XPropertySet~setPropertyValue("GraphicURL",sNewURL)
	iConverted = iConverted+1
end

.bsf.dialog~messageBox("Converted" iConverted "graphics")

::requires UNO.cls


