sGraphicURL="c:\temp\gif.gif"

xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

s = "com.sun.star.drawing.GraphicObjectShape"
sGraphicURL = uno.convertToURL(sGraphicURL)

--oDrawPage = xdoc~XDrawPageSupplier~getDrawPage()
oDrawPage = xdoc~XDrawPagesSupplier~getDrawPages()~XDrawPages~getByIndex(0)

oGraphic = xMSF~createInstance(s)
oGraphic~XPropertySet~setPropertyValue("GraphicURL",sGraphicURL)
oShape = oGraphic~XShape

oGraphicProvider = xMCF~createInstanceWithContext("com.sun.star.graphic.GraphicProvider",xcc)~XGraphicProvider
aMediaProperties = uno.CreateArray(.UNO~PROPERTYVALUE,1)
aMediaProperties[1] = uno.createProperty("URL",sGraphicURL)

/*obtain the graphic's property set*/
oGraphicPropertySet = oGraphicProvider~queryGraphicDescriptor(aMediaProperties)~XPropertySet

/*returns the "print size" set for a graphic in 100th mm*/
oGraphicSize = oGraphicPropertySet~getPropertyValue("Size100thMM")
iGraphicHeight = oGraphicSize~bsf.getFieldValue("Height")
iGraphicWidth = oGraphicSize~bsf.getFieldValue("Width")

/*are the sizes set?*/
/*if not, we set them at least in the right aspect ratio*/
if (iGraphicHeight==0 | iGraphicWidth==0) then
do
	oGraphicSize = oGraphicPropertySet~getPropertyValue("SizePixel")
	iGraphicHeight = oGraphicSize~bsf.getFieldValue("Height") *25
	iGraphicWidth = oGraphicSize~bsf.getFieldValue("Width") *25

	/*ok, the preload mechanism failed - lets retrieve the graphic and then determine its size*/
	if (iGraphicHeight==0 | iGraphicWidth==0) then
	do
		oGraphic = oGraphicProvider~queryGraphic(aMediaProperties)
		if oGraphic <> .nil then
		do
		oGraphicPropertySet = oGraphic~XPropertySet
		oGraphicSize = oGraphicPropertySet~getPropertyValue("SizePixel")
		iGraphicHeight = oGraphicSize~bsf.getFieldValue("Height") *25
		iGraphicWidth = oGraphicSize~bsf.getFieldValue("Width") *25
		end
		/*still nothing? -- well, giving up.*/
		else
		do
			.bsf.dialog~messageBox("Couldn't determine size. Exiting...")
			exit
		end
	end
end

/*set the new size and add the graphic to the draw page*/
size=.bsf~new("com.sun.star.awt.Size")
size~bsf.setFieldValue("height",iGraphicHeight)
size~bsf.setFieldValue("width",iGraphicWidth)

/*setSize sets the graphic size in 100th mm*/
oShape~setSize(size)
oDrawPage~XShapes~add(oShape~XShape)

::requires UNO.cls
