/*******************/
/**USER MODIFIABLE**/
/*******************/

/**A GUI IS ALSO PROVIDED, SEE TEXT**/

/*specify output filename including .jpg extension*/
filename = "c:\temp\export.jpg"

/*specify an array of input image files*/
imports = .array~new()
imports~append("c:\temp\png.png")
imports~append("c:\temp\test.png")

/*specify raster columns*/
raster_x=2

/*specify raster rows*/
raster_y=1

/***********************/
/**END USER MODIFIABLE**/
/***********************/

xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()

/*conversions and necessary checks*/
filename = uno.convertToUrl(filename)
do i=1 to imports~items 
imports~put(uno.convertToUrl(imports~at(i)),i)
end

if \ (imports~items == raster_x*raster_y) then
.bsf.dialog~messageBox("Error. Image number and raster sizes don't match")

ret = executeCombine(imports,filename,raster_y,raster_x,xdoc,xMCF,xcc)

::requires UNO.cls

::routine executeCombine
use arg imports exportfile raster_y raster_x xdoc xMCF xcc

xMSF = xdoc~XMultiServiceFactory

dpi = 300

dp100thmm = dpi/(2.54*10*100)

/*create a new drawpage*/
oDrawPages = xdoc~XDrawPagesSupplier~getDrawPages()
iDrawPageCount = oDrawPages~XIndexAccess~getCount()
oDrawPages~insertNewByIndex(iDrawPageCount)
oDrawPage = oDrawPages~XIndexAccess~getByIndex(iDrawPageCount) --XDrawPage

/*set pictures at the appropriate positions*/
oGraphicProvider = xMCF~createInstanceWithContext("com.sun.star.graphic.GraphicProvider",xcc)~XGraphicProvider
pixelwidths = .array~new
pixelheights = .array~new
heightmax = 0
widthmax = 0

do i=1 to imports~items
	sGraphicURL = imports~at(i)
	aMediaProperties = uno.CreateArray(.UNO~PROPERTYVALUE,1)
	aMediaProperties[1] = uno.createProperty("URL",sGraphicURL)
	oGraphicPropertySet = oGraphicProvider~queryGraphicDescriptor(aMediaProperties)~XPropertySet

	/*obtain the pixel sizes*/
	oGraphicSize = oGraphicPropertySet~getPropertyValue("SizePixel")
	pixelwidths[i] = oGraphicSize~bsf.getFieldValue("Width")
	pixelheights[i] = oGraphicSize~bsf.getFieldValue("Height")

	/*no size contained in SizePixel property?*/
	if pixelwidths[i]==0 | pixelheights[i]==0 then
	do
	oGraphic = oGraphicProvider~queryGraphic(aMediaProperties)
		if oGraphic <> .nil then
		do
		oGraphicPropertySet = oGraphic~XPropertySet
		oGraphicSize = oGraphicPropertySet~getPropertyValue("SizePixel")
		pixelheights[i] = oGraphicSize~bsf.getFieldValue("Height")
		pixelwidths[i] = oGraphicSize~bsf.getFieldValue("Width")
		end
		/*still nothing? -- well, giving up.*/
		else
		do
			.bsf.dialog~messageBox("Couldn't determine graphic object size.")
			return 0
		end
	end

	if pixelwidths[i]>widthmax then
		widthmax = pixelwidths[i]

	if pixelheights[i]>heightmax then
		heightmax = pixelheights[i]

end

/*calculate the raster size*/
rasterwidth = widthmax/dp100thmm
rasterheight = heightmax/dp100thmm

/*we need a background shape*/
oBackground = xMSF~createInstance("com.sun.star.drawing.RectangleShape")
oBackground~XPropertySet~setPropertyValue("LineStyle",bsf.getStaticValue("com.sun.star.drawing.LineStyle","NONE"))
oBackground~XPropertySet~setPropertyValue("FillStyle",bsf.getStaticValue("com.sun.star.drawing.FillStyle","NONE"))

/*set background size*/
width = rasterwidth*raster_x
height = rasterheight*raster_y
oBackgroundSize = .bsf~new("com.sun.star.awt.Size")
oBackgroundSize~bsf.setFieldValue("Height",trunc(height))
oBackgroundSize~bsf.setFieldValue("Width",trunc(width))
oBackground~XShape~setSize(oBackgroundSize)

/*set background position*/
oBackgroundPos=.bsf~new("com.sun.star.awt.Point")
oBackgroundPos~bsf.setFieldValue("X",0)
oBackgroundPos~bsf.setFieldValue("Y",0)
oBackground~XShape~setPosition(oBackgroundPos)
oDrawPage~XShapes~add(oBackground~XShape)

/*iterate and set positions*/
pageoffsetheight = 0
do j=1 to raster_y
	pageoffsetwidth = 0
	do k=1 to raster_x
		i=(j-1)*raster_x+k
		sGraphicURL=imports[i]
		oGraphic = xMSF~createInstance("com.sun.star.drawing.GraphicObjectShape")
		oGraphic~XPropertySet~setPropertyValue("GraphicURL",sGraphicURL)
		oShape = oGraphic~XShape

		height = pixelheights[i]/dp100thmm
		width = pixelwidths[i]/dp100thmm

		/*set the new size*/
		size=.bsf~new("com.sun.star.awt.Size")
		size~bsf.setFieldValue("height",trunc(height))
		size~bsf.setFieldValue("width",trunc(width))
		oShape~setSize(size)

		/*calculate offset*/

		customoffsetwidth = pageoffsetwidth + ((rasterwidth - width)/2)
		customoffsetheight = pageoffsetheight + ((rasterheight - height)/2)

		/*set the new position*/
		pos=.bsf~new("com.sun.star.awt.Point")
		pos~bsf.setFieldValue("X",trunc(customoffsetwidth))
		pos~bsf.setFieldValue("Y",trunc(customoffsetheight))
		oShape~setPosition(pos)

		oDrawPage~XShapes~add(oShape)

		pageoffsetwidth = pageoffsetwidth + rasterwidth
	end
	pageoffsetheight = pageoffsetheight + rasterheight
end

/*export to one image file*/
xSelectionSupplier = xdoc~XModel~getCurrentController~XSelectionSupplier
/*select all XShapes of the current page - we want to export all of them*/
xSelectionSupplier~select(oDrawPage~XShapes)

/*get the selection*/
xSelection = xSelectionSupplier~getSelection()

/*calculate the size*/
size_x = trunc(pageoffsetwidth*dp100thmm)
size_y = trunc(pageoffsetheight*dp100thmm)

/*setup the filter*/
aFilterData = uno.createArray(.UNO~PROPERTYVALUE,5)
aFilterData[1]=uno.createProperty("PixelWidth",box("I",size_x))
aFilterData[2]=uno.createProperty("PixelHeight",box("I",size_y))
aFilterData[3]=uno.createProperty("LogicalWidth",box("I",trunc(pageoffsetwidth)))
aFilterData[4]=uno.createProperty("LogicalHeight",box("I",trunc(pageoffsetheight)))
aFilterData[5]=uno.createProperty("Quality",box("I",90))

/*get the GraphicExportFilter*/
xExporter = xMCF~createInstanceWithContext("com.sun.star.drawing.GraphicExportFilter",xcc)
xExporter~XExporter~setSourceDocument(xSelection~XComponent)

aArgs=uno.createArray(.UNO~PROPERTYVALUE,3)
aArgs[1]=uno.createProperty("MediaType","image/jpeg")
aArgs[2]=uno.createProperty("URL",exportfile)
aArgs[3]=uno.createProperty("FilterData",aFilterData)

ret = xExporter~XFilter~filter(aArgs)
return ret

