xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

oController = xdoc~XModel~getCurrentController
xSheet = oController~XSpreadsheetView~getActiveSheet()

/*get a range and its address*/
xCellRange = xSheet~getCellRangeByName("B4:C10")
stAddress = xCellRange~XCellRangeAddressable~getRangeAddress()

/*within the address, fill values in the first and the last cell*/
xFirstCellRow = stAddress~bsf.getFieldValue("StartRow")
xFirstCellColumn = stAddress~bsf.getFieldValue("StartColumn")
call uno.setCell xSheet, xFirstCellColumn, xFirstCellRow, "First cell of normal range."

xLastCellRow = stAddress~bsf.getFieldValue("EndRow")
xLastCellColumn = stAddress~bsf.getFieldValue("EndColumn")
call uno.setCell xSheet, xLastCellColumn, xLastCellRow, "Last cell of normal range."

/*we also set an additional cell value*/
call uno.setCell xSheet, 0, 2, "Extra cell."

/**retrieve the complete cell range in use and select it**/
/**from Gmeiner2008**/
xCursor  = xSheet~createCursor
xCursor~XUsedAreaCursor~gotoStartOfUsedArea(.false)
xCursor~XUsedAreaCursor~gotoEndOfUsedArea(.true)

oSelection=xdoc~XModel~getCurrentController()~XSelectionSupplier~select(xCursor)

/**assign an area a name**/
/**from Gmeiner2008**/
/*we need a relative reference cell*/
xCell = uno.getCell(xSheet, "A1")
stAddress = xCell~XCellAddressable~getCellAddress

/*as a name has to be unique, we create a timestamp*/
sDate = .DateTime~new~~fullDate~string

oNamedRanges = xdoc~XPropertySet~getPropertyValue("NamedRanges")
xNamedRanges = oNamedRanges~XNamedRanges
xNamedRanges~addNewByName("Named Area" sDate,"A1:C10",stAddress,0)
xdoc~XPropertySet~setPropertyValue("NamedRanges",oNamedRanges)

/*retrieve cell range by name*/
stAddress = xSheet~getCellRangeByName("Named Area" sDate)~XCellRangeAddressable~getRangeAddress()
xFirstCellRow = stAddress~bsf.getFieldValue("StartRow")
xFirstCellColumn = stAddress~bsf.getFieldValue("StartColumn")
xLastCellRow = stAddress~bsf.getFieldValue("EndRow")
xLastCellColumn = stAddress~bsf.getFieldValue("EndColumn")

.bsf.dialog~messageBox("NamedRange start: Column:" xFirstCellColumn "Row:" xFirstCellRow .ENDOFLINE -
		"NamedRange end: Column:" xLastCellColumn "Row:" xLastCellRow)

::requires UNO.cls
