xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

xMCF = xcc~getServiceManager()

oText = xdoc~XTextDocument~getText()

xMSF = xdoc~XMultiServiceFactory

/*the database "addresses" with table "address" must be registered within OOo.org
 *fields: First Name, Last Name, Street, ZIP, City, Sex*/

/*create the masterfields and the textfields*/
dbfields = .array~of("First Name", "Last Name", "Street", "ZIP", "City")
masterfields = .array~new(dbfields~items)
fields = .array~new(dbfields~items)

do i=1 to dbfields~items
	/*master fields*/
	masterfields[i] = xMSF~createInstance("com.sun.star.text.FieldMaster.Database")
	/*only one out of DataBaseName, DataBaseURL, DataBaseResource can be set*/
	masterfields[i]~XPropertySet~setPropertyValue("DataBaseName","addresses")
	masterfields[i]~XPropertySet~setPropertyValue("DataTableName","address")
	masterfields[i]~XPropertySet~setPropertyValue("DataColumnName",dbfields[i])

	/*text fields*/
	fields[i] = xMSF~createInstance("com.sun.star.text.textfield.Database")
	fields[i]~XDependentTextField~attachTextFieldMaster(masterfields[i]~XPropertySet)
	fields[i]~XPropertySet~setPropertyValue("Content","<"||dbfields[i]||">")
end

/*set up the form letter address box*/
oText~insertTextContent(oText~XTextRange~getEnd(),fields[getField("First Name",dbfields)]~XTextContent,.false)
oText~XSimpleText~insertString(oText~XTextRange~getEnd()," ",.false)
oText~insertTextContent(oText~XTextRange~getEnd(),fields[getField("Last Name",dbfields)]~XTextContent,.false)
oText~insertControlCharacter(oText~XTextRange~getEnd(),bsf.getConstant("com.sun.star.text.ControlCharacter","LINE_BREAK"),.false)
oText~insertTextContent(oText~XTextRange~getEnd(),fields[getField("Street",dbfields)]~XTextContent,.false)
oText~insertControlCharacter(oText~XTextRange~getEnd(),bsf.getConstant("com.sun.star.text.ControlCharacter","LINE_BREAK"),.false)
oText~insertTextContent(oText~XTextRange~getEnd(),fields[getField("ZIP",dbfields)]~XTextContent,.false)
oText~XSimpleText~insertString(oText~XTextRange~getEnd()," ",.false)
oText~insertTextContent(oText~XTextRange~getEnd(),fields[getField("City",dbfields)]~XTextContent,.false)
oText~insertControlCharacter(oText~XTextRange~getEnd(),bsf.getConstant("com.sun.star.text.ControlCharacter","PARAGRAPH_BREAK"),.false)
oText~insertControlCharacter(oText~XTextRange~getEnd(),bsf.getConstant("com.sun.star.text.ControlCharacter","PARAGRAPH_BREAK"),.false)

/*insert a conditional field*/
oCondField = xMSF~createInstance("com.sun.star.text.textfield.ConditionalText")
oCondField~XPropertySet~setPropertyValue("TrueContent","Miss")
oCondField~XPropertySet~setPropertyValue("FalseContent","Mister")
oCondField~XPropertySet~setPropertyValue("Condition","addresses.address.Sex==1")
oCondField~XPropertySet~setPropertyValue("CurrentPresentation","<SexConditional>")

/*last name field*/
oLNameField = xMSF~createInstance("com.sun.star.text.textfield.Database")
oLNameField~XDependentTextField~attachTextFieldMaster(masterfields[getField("Last Name",dbfields)]~XPropertySet)
oLNameField~XPropertySet~setPropertyValue("Content","<"||dbfields[getField("Last Name",dbfields)]||">")

oText~XSimpleText~insertString(oText~XTextRange~getEnd(),"Dear ",.false)
oText~insertTextContent(oText~XTextRange~getEnd(),oCondField~XTextContent,.false)
oText~XSimpleText~insertString(oText~XTextRange~getEnd()," ",.false)
oText~insertTextContent(oText~XTextRange~getEnd(),oLNameField~XTextContent,.false)
oText~XSimpleText~insertString(oText~XTextRange~getEnd(),"!",.false)

/*do the merger*/
/*document already saved?*/
path = xdoc~XModel~getURL()
if path=="" then
do
	oFilePicker = xMCF~XMultiServiceFactory~createInstance("com.sun.star.ui.dialogs.FilePicker")

	aListAny = bsf.createArray("Short.class",1)
	aListAny[1]=box("short",bsf.getStaticValue("com.sun.star.ui.dialogs.TemplateDescription","FILESAVE_AUTOEXTENSION"))
	oFilePicker~XInitialization~initialize(aListAny)
	xFileManager = oFilePicker~XFilterManager~appendFilter("Open Document Text","*.odt")

	file=.nil
	oFilePicker~XExecutableDialog~execute()
	file = oFilePicker~XFilePicker~getFiles()~makeArray(" ")~at(1)

	if file==.nil then
	do
	 .bsf.dialog~messageBox("No file selected - exiting".)
	 exit
	end

	path=file
end

signal on ANY
/*save the document*/
path=ConvertFromURL(path)
path=ConvertToURL(path)
xdoc~XStorable~storeAsURL(path, .UNO~noprops)
signal off ANY

oMailMerge = xMCF~createInstanceWithContext("com.sun.star.text.MailMerge",xcc)
oMailMerge~XPropertySet~setPropertyValue("DataSourceName","addresses")
oMailMerge~XPropertySet~setPropertyValue("DocumentURL",xdoc~XModel~getURL())

oMailMerge~XPropertySet~setPropertyValue("OutputType",box("SH",bsf.getStaticValue("com.sun.star.text.MailMergeType","FILE")))
oMailMerge~XPropertySet~setPropertyValue("FileNamePrefix", "test_")
oMailMerge~XPropertySet~setPropertyValue("SaveAsSingleFile",box("boolean",.true))
oMailMerge~XPropertySet~setPropertyValue("CommandType",box("I",bsf.getStaticValue("com.sun.star.sdb.CommandType","TABLE")))
oMailMerge~XPropertySet~setPropertyValue("Command","address")


call bsf.import "com.sun.star.beans.NamedValue","NamedValue.class" 
oMailMerge~XJob~execute(bsf.createArray(.NamedValue.class,0))
exit 0

ANY:
	.bsf.dialog~messageBox("Could not delete file. Maybe opened? Exiting.")
	exit

::REQUIRES UNO.cls

::ROUTINE getField
	USE ARG name, dbfields
	if dbfields~hasItem(name) then
	do
		RETURN dbfields~index(name)
	end
	else
	do
		RETURN -1
	end

