xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

oFilePicker = xMCF~XMultiServiceFactory~createInstance("com.sun.star.ui.dialogs.FilePicker")

aListAny = bsf.createArray("Short.class",1)
aListAny[1]=box("short",bsf.getStaticValue("com.sun.star.ui.dialogs.TemplateDescription","FILESAVE_AUTOEXTENSION"))
oFilePicker~XInitialization~initialize(aListAny)
xFileManager = oFilePicker~XFilterManager~appendFilter("Portable Network Graphics","*.png")

file=.nil
oFilePicker~XExecutableDialog~execute()
file = oFilePicker~XFilePicker~getFiles()~makeArray(" ")~at(1)

if file==.nil then
do
 .bsf.dialog~messageBox("No file selected - exiting".)
 exit
end

oSimpleFileAccess = xMCF~XMultiServiceFactory~createInstance("com.sun.star.ucb.SimpleFileAccess")
if oSimpleFileAccess~XSimpleFileAccess2~exists(file) then
do
	signal on ANY
	oSimpleFileAccess~XSimpleFileAccess2~kill(file)
end


sFileURL=file

aFilterData = uno.createArray(.UNO~PROPERTYVALUE,5)
aFilterData[1]=uno.createProperty("PixelWidth",box("I",1000))
aFilterData[2]=uno.createProperty("PixelHeight",box("I",1000))
aFilterData[3]=uno.createProperty("LogicalWidth",box("I",1000))
aFilterData[4]=uno.createProperty("LogicalHeight",box("I",1000))
aFilterData[5]=uno.createProperty("Quality",box("I",90))

xView = xdoc~XModel~getCurrentController()
xSelection = xView~XSelectionSupplier~getSelection()

/*if we have a text document, we need to reduce the contained elements to XShapes*/
if xdoc~uno.supportsService("TextDocument") | xdoc~uno.supportsService("SpreadsheetDocument") then
do
	/*only shapes selected?*/
	if \ uno.getInterfaceNamesViaReflection(xSelection)~makeArray(" ")~hasItem("com.sun.star.drawing.XShapes") then
	do
		.bsf.dialog~messageBox("No shapes selected. Exiting.")
		exit
	end
end
else
do
	/*xSelection contains the selected objects - if nothing is selected, the interface name is void*/
	if uno.getInterfaceName(xSelection)=="void" then
	do	
		xSelection = xView~XPropertySet~getPropertyValue("CurrentPage")
	end
end

xExporter = xMCF~createInstanceWithContext("com.sun.star.drawing.GraphicExportFilter",xcc)
xExporter~XExporter~setSourceDocument(xSelection~XComponent)

aArgs=uno.createArray(.UNO~PROPERTYVALUE,3)
aArgs[1]=uno.createProperty("MediaType","image/jpeg")
aArgs[2]=uno.createProperty("URL",sFileURL)
aArgs[3]=uno.createProperty("FilterData",aFilterData)

a =xExporter~XFilter~filter(aArgs)
.bsf.dialog~messageBox(a)

exit 0

ANY:
	.bsf.dialog~messageBox("Could not delete file. Maybe opened? Exiting.")
	exit

::requires UNO.cls

