xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()

graphicholder = .array~new()

o_Dialog = xMCF~XMultiServiceFactory~createInstance("com.sun.star.awt.UnoControlDialogModel")
o_Dialog.Properties = o_Dialog~XPropertyset
o_Dialog.Properties~setPropertyValue("Width",     box("int", 256))
o_Dialog.Properties~setPropertyValue("Height",    box("int", 234))
o_Dialog.Properties~setPropertyValue("Title",     "Graphics Selection")
o_Dialog.Factory = o_Dialog~XMultiServiceFactory
o_Dialog.Container = o_Dialog~XNameContainer
o_Dialog.Control = xMCF~XMultiServiceFactory~createInstance("com.sun.star.awt.UnoControlDialog")~XControl
o_Dialog.Control~setModel(o_Dialog~XControlModel)
o_Dialog.ControlContainer = o_Dialog.Control~XControlContainer
x_Toolkit = xMCF~XMultiServiceFactory~createInstance("com.sun.star.awt.Toolkit")~XToolkit
o_Dialog.Control~createPeer(x_Toolkit, .nil)
x_Frame = xMCF~XMultiServiceFactory~createInstance("com.sun.star.frame.Frame")~XFrame
x_Frame~initialize(o_Dialog.Control~XWindow)

oListBox =  o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlListBoxModel")
oListBox~XPropertySet~setPropertyValue("PositionX", box("int", 8))
oListBox~XPropertySet~setPropertyValue("PositionY", box("int", 8))
oListBox~XPropertySet~setPropertyValue("Width",     box("int", (240)))
oListBox~XPropertySet~setPropertyValue("Height",    box("int", 152))
oListBox~XPropertySet~setPropertyValue("ReadOnly",  box("boolean",.true))
oListBox~XPropertySet~setPropertyValue("Name",	"listGraphic")
listitems = uno.createArray("String.class",0)
oListBox~XPropertySet~setPropertyValue("StringItemList", listitems)
o_Dialog.Container~insertByName("list_listgraphic",oListBox)

oEditRowLabel = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlFixedTextModel")
oEditRowLabel~XPropertySet~setPropertyValue("PositionX", box("int", 13))
oEditRowLabel~XPropertySet~setPropertyValue("PositionY", box("int", 171))
oEditRowLabel~XPropertySet~setPropertyValue("Width",     box("int", 90))
oEditRowLabel~XPropertySet~setPropertyValue("Height",    box("int", 14))
oEditRowLabel~XPropertySet~setPropertyValue("Label",    "Specify number of rows:")
o_Dialog.Container~insertByName("label_row", oEditRowLabel)

oEditRow = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlNumericFieldModel")
oEditRow~XPropertySet~setPropertyValue("PositionX", box("int", 95))
oEditRow~XPropertySet~setPropertyValue("PositionY", box("int", 168))
oEditRow~XPropertySet~setPropertyValue("Width",     box("int", 24))
oEditRow~XPropertySet~setPropertyValue("Height",    box("int", 14))
oEditRow~XPropertySet~setPropertyValue("DecimalAccuracy", box("short",0))
oEditRow~XPropertySet~setPropertyValue("StrictFormat", box("boolean",.true))
oEditRow~XPropertySet~setPropertyValue("Spin", box("boolean",.true))
oEditRow~XPropertySet~setPropertyValue("Value", box("double",1))
oEditRow~XPropertySet~setPropertyValue("Name", 	    "rowNumber")
o_Dialog.Container~insertByName("field_row", oEditRow)

oEditColumnLabel = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlFixedTextModel")
oEditColumnLabel~XPropertySet~setPropertyValue("PositionX", box("int", 137))
oEditColumnLabel~XPropertySet~setPropertyValue("PositionY", box("int", 171))
oEditColumnLabel~XPropertySet~setPropertyValue("Width",     box("int", 90))
oEditColumnLabel~XPropertySet~setPropertyValue("Height",    box("int", 14))
oEditColumnLabel~XPropertySet~setPropertyValue("Label",    "Specify number of columns:")
o_Dialog.Container~insertByName("label_column", oEditColumnLabel)

oEditColumn = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlNumericFieldModel")
oEditColumn~XPropertySet~setPropertyValue("PositionX", box("int", 219))
oEditColumn~XPropertySet~setPropertyValue("PositionY", box("int", 168))
oEditColumn~XPropertySet~setPropertyValue("Width",     box("int", 24))
oEditColumn~XPropertySet~setPropertyValue("Height",    box("int", 14))
oEditColumn~XPropertySet~setPropertyValue("DecimalAccuracy", box("short",0))
oEditColumn~XPropertySet~setPropertyValue("StrictFormat", box("boolean",.true))
oEditColumn~XPropertySet~setPropertyValue("Spin", box("boolean",.true))
oEditColumn~XPropertySet~setPropertyValue("Value", box("double",1))
oEditColumn~XPropertySet~setPropertyValue("Name", 	    "columnNumber")
o_Dialog.Container~insertByName("field_column", oEditColumn)

oEditPathLabel = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlFixedTextModel")
oEditPathLabel~XPropertySet~setPropertyValue("PositionX", box("int", 13))
oEditPathLabel~XPropertySet~setPropertyValue("PositionY", box("int", 193))
oEditPathLabel~XPropertySet~setPropertyValue("Width",     box("int", 60))
oEditPathLabel~XPropertySet~setPropertyValue("Height",    box("int", 14))
oEditPathLabel~XPropertySet~setPropertyValue("Label",    "Specify output path:")
o_Dialog.Container~insertByName("label_path", oEditPathLabel)

oPathEdit = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlEditModel")
oPathEdit~XPropertySet~setPropertyValue("PositionX", box("int", 81))
oPathEdit~XPropertySet~setPropertyValue("PositionY", box("int", 190))
oPathEdit~XPropertySet~setPropertyValue("Width",     box("int", 96))
oPathEdit~XPropertySet~setPropertyValue("Height",    box("int", 14))
oPathEdit~XPropertySet~setPropertyValue("ReadOnly",    box("boolean", .true))
o_Dialog.Container~insertByName("edit_path", oPathEdit)

oPathButton = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlButtonModel")
oPathButton~XPropertySet~setPropertyValue("PositionX", box("int", 185))
oPathButton~XPropertySet~setPropertyValue("PositionY", box("int", 190))
oPathButton~XPropertySet~setPropertyValue("Width",     box("int", 58))
oPathButton~XPropertySet~setPropertyValue("Height",    box("int", 14))
oPathButton~XPropertySet~setPropertyValue("Name",      "select")
oPathButton~XPropertySet~setPropertyValue("Label",     "Select...")
o_Dialog.Container~insertByName("button_path", oPathButton)
oPathButton_Control = o_Dialog.ControlContainer~getControl("button_path")
oPathButton_Control~XButton~bsf.addEventListener("action", "actionPerformed","select")


o_Button1 = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlButtonModel")
o_Button1.Properties = o_Button1~XPropertySet
o_Button1.Properties~setPropertyValue("PositionX", box("int", 8))
o_Button1.Properties~setPropertyValue("PositionY", box("int", 212))
o_Button1.Properties~setPropertyValue("Width",     box("int", 116))
o_Button1.Properties~setPropertyValue("Height",    box("int", 14))
o_Button1.Properties~setPropertyValue("Name",      "addGraphic")
o_Button1.Properties~setPropertyValue("Label",     "Add a graphic...")
o_Dialog.Container~insertByName("button_addgraphic", o_Button1)
o_Button1.Control = o_Dialog.ControlContainer~getControl("button_addgraphic")
o_Button1.Control~XButton~bsf.addEventListener("action", "actionPerformed","addGraphic")
o_Dialog.Control~XWindow~setVisible(.true)


oButton2 = o_Dialog.Factory~createInstance("com.sun.star.awt.UnoControlButtonModel")
oButton2~XPropertySet~setPropertyValue("PositionX", box("int", 132))
oButton2~XPropertySet~setPropertyValue("PositionY", box("int", 212))
oButton2~XPropertySet~setPropertyValue("Width",     box("int", 116))
oButton2~XPropertySet~setPropertyValue("Height",    box("int", 14))
oButton2~XPropertySet~setPropertyValue("Name",      "execute")
oButton2~XPropertySet~setPropertyValue("Label",     "Execute!")
o_Dialog.Container~insertByName("button_execute", oButton2)
oButton2_Control = o_Dialog.ControlContainer~getControl("button_execute")
oButton2_Control~XButton~bsf.addEventListener("action", "actionPerformed","execute")
oButton2_Control~XButton~bsf.addEventListener("action", "disposing",      "close")
o_Dialog.Control~XWindow~setVisible(.true)

do forever
   eventText=bsf.pollEventText(1000) -- timeout of 100/1000 sec
   if eventText="execute" then
	do
	oRectangle = .bsf~new("com.sun.star.awt.Rectangle")
	if checkMatrix(o_Dialog.ControlContainer,graphicholder) then
	do
		path = o_Dialog.ControlContainer~getControl("edit_path")~getModel()~XPropertySet~getPropertyValue("Text")
		row = o_Dialog.ControlContainer~getControl("field_row")~getModel()~XPropertySet~getPropertyValue("Value")
		column = o_Dialog.ControlContainer~getControl("field_column")~getModel()~XPropertySet~getPropertyValue("Value")
		
		oButton2~XPropertySet~setPropertyValue("Enabled",box("boolean",.false))

		ret = executeCombine(graphicholder,path,row,column,xdoc,xMCF,xcc)
		if ret then
		do
			oMsgBox = x_Toolkit~XMessageBoxFactory~createMessageBox(o_Dialog.Control~getPeer(),oRectangle,"infobox",1,"Saving","Saving successful.")
			oMsgBox~execute()
			--leave
		end
		else
		do
			oMsgBox = x_Toolkit~XMessageBoxFactory~createMessageBox(o_Dialog.Control~getPeer(),oRectangle,"errorbox",1,"Saving","Errors occurred. Not saved.")
			oMsgBox~execute()
		end
		oButton2~XPropertySet~setPropertyValue("Enabled",box("boolean",.true))
	end
	else
	do
		oMsgBox = x_Toolkit~XMessageBoxFactory~createMessageBox(o_Dialog.Control~getPeer(),oRectangle,"errorbox",1,"Matrix","Matrix dimensions don't match picture numbers. Please correct.")
		oMsgBox~execute()
	end
   end
   else if eventText="addGraphic" then
	graphicholder = addGraphic(o_Dialog.ControlContainer,graphicholder,xMCF)
   else if eventText="close" then
	leave
   else if eventText="select" then
   	call selectPath o_Dialog.ControlContainer,xMCF
end

o_Dialog.Control~XComponent~dispose()

::requires UNO.cls

::routine selectPath
use arg o_Dialog.ControlContainer xMCF
oFilePicker = xMCF~XMultiServiceFactory~createInstance("com.sun.star.ui.dialogs.FilePicker")

aListAny = bsf.createArray("Short.class",1)
aListAny[1]=box("short",bsf.getStaticValue("com.sun.star.ui.dialogs.TemplateDescription","FILESAVE_AUTOEXTENSION"))
oFilePicker~XInitialization~initialize(aListAny)
xFileManager = oFilePicker~XFilterManager~appendFilter("JPEG File Interchange Format","*.jpg")

file=.nil
oFilePicker~XExecutableDialog~execute()
file = oFilePicker~XFilePicker~getFiles()~makeArray(" ")~at(1)


sDir = file
if \ (sDir~length==0) then
do
	oPathEdit=o_Dialog.ControlContainer~getControl("edit_path")~getModel
	oPathEdit~XPropertySet~setPropertyValue("Text",sDir)
	oSimpleFileAccess = xMCF~XMultiServiceFactory~createInstance("com.sun.star.ucb.SimpleFileAccess")
	if oSimpleFileAccess~XSimpleFileAccess2~exists(file) then
	do
		signal on ANY
		oSimpleFileAccess~XSimpleFileAccess2~kill(file)
		signal off ANY
	end
end
return .true

ANY:
	.bsf.dialog~messageBox("Could not delete file. Maybe opened? Exiting.")
	return .false


::routine checkMatrix
use arg o_Dialog.ControlContainer graphicholder

oEditRow = o_Dialog.ControlContainer~getControl("field_row")~getModel()
iRows = oEditRow~XPropertySet~getPropertyValue("Value")
oEditColumn = o_Dialog.ControlContainer~getControl("field_column")~getModel()
iCols = oEditColumn~XPropertySet~getPropertyValue("Value")

iAmount = graphicholder~items

if iAmount = iCols*iRows then
	ret= .true
else
	ret= .false

return ret

::routine addGraphic
use arg o_Dialog.ControlContainer graphicholder xMCF

call bsf.import "com.sun.star.beans.StringPair","StringPair.class"
filters=bsf.createArray(.StringPair.class,3)
sp = .StringPair.class~new()
sp~bsf.setFieldValue("First","GIF")
sp~bsf.setFieldValue("Second","*.gif")
filters~put(sp,1)
sp = .StringPair.class~new()
sp~bsf.setFieldValue("First","JPG")
sp~bsf.setFieldValue("Second","*.jpg;*.jpeg")
filters~put(sp,2)
sp = .StringPair.class~new()
sp~bsf.setFieldValue("First","PNG")
sp~bsf.setFieldValue("Second","*.png")
filters~put(sp,3)

oFilePicker = xMCF~XMultiServiceFactory~createInstance("com.sun.star.ui.dialogs.FilePicker")
oFilePicker~XFilePicker~setMultiSelectionMode(.true)
oFilePicker~XFilterGroupManager~appendFilterGroup("Graphics",filters)
oFilePicker~XFilePicker~XExecutableDialog~execute()
aFiles = oFilePicker~XFilePicker~getFiles()~makeArray(" ")

if aFiles~items < 2 then
do
	if aFiles~items==1 then
		graphicholder~append(aFiles~at(1))
	else
		return graphicholder
end
else
do
	do i=2 to aFiles~items
		graphicholder~append(aFiles~at(1)||"/"||aFiles~at(i))
	end
end

oListBox=o_Dialog.ControlContainer~getControl("list_listgraphic")~getModel()
listitems = uno.createArray("String.class",graphicholder~items)
do i=1 to graphicholder~items
	listitems~put(graphicholder~at(i),i)
end
oListBox~XPropertySet~setPropertyValue("StringItemList",listitems)
return graphicholder

::routine executeCombine
use arg imports path raster_y raster_x xdoc xMCF xcc

xMSF = xdoc~XMultiServiceFactory

dpi = 300
exportfile = path

dp100thmm = dpi/(2.54*10*100)

/*create a new drawpage*/
oDrawPages = xdoc~XDrawPagesSupplier~getDrawPages()
iDrawPageCount = oDrawPages~XIndexAccess~getCount()
oDrawPages~insertNewByIndex(iDrawPageCount)
oDrawPage = oDrawPages~XIndexAccess~getByIndex(iDrawPageCount) --XDrawPage

/*set pictures at the appropriate positions*/
oGraphicProvider = xMCF~createInstanceWithContext("com.sun.star.graphic.GraphicProvider",xcc)~XGraphicProvider
pixelwidths = .array~new
pixelheights = .array~new
heightmax = 0
widthmax = 0

do i=1 to imports~items
	sGraphicURL = imports~at(i)
	aMediaProperties = uno.CreateArray(.UNO~PROPERTYVALUE,1)
	aMediaProperties[1] = uno.createProperty("URL",sGraphicURL)
	oGraphicPropertySet = oGraphicProvider~queryGraphicDescriptor(aMediaProperties)~XPropertySet

	/*obtain the pixel sizes*/
	oGraphicSize = oGraphicPropertySet~getPropertyValue("SizePixel")
	pixelwidths[i] = oGraphicSize~bsf.getFieldValue("Width")
	pixelheights[i] = oGraphicSize~bsf.getFieldValue("Height")

	/*no size contained in SizePixel property?*/
	if pixelwidths[i]==0 | pixelheights[i]==0 then
	do
	oGraphic = oGraphicProvider~queryGraphic(aMediaProperties)
		if oGraphic <> .nil then
		do
		oGraphicPropertySet = oGraphic~XPropertySet
		oGraphicSize = oGraphicPropertySet~getPropertyValue("SizePixel")
		pixelheights[i] = oGraphicSize~bsf.getFieldValue("Height")
		pixelwidths[i] = oGraphicSize~bsf.getFieldValue("Width")
		end
		/*still nothing? -- well, giving up.*/
		else
		do
			.bsf.dialog~messageBox("Couldn't determine graphic object size.")
			return 0
		end
	end

	if pixelwidths[i]>widthmax then
		widthmax = pixelwidths[i]

	if pixelheights[i]>heightmax then
		heightmax = pixelheights[i]

end

/*calculate the raster size*/
rasterwidth = widthmax/dp100thmm
rasterheight = heightmax/dp100thmm

/*we need a background shape*/
oBackground = xMSF~createInstance("com.sun.star.drawing.RectangleShape")
oBackground~XPropertySet~setPropertyValue("LineStyle",bsf.getStaticValue("com.sun.star.drawing.LineStyle","NONE"))
oBackground~XPropertySet~setPropertyValue("FillStyle",bsf.getStaticValue("com.sun.star.drawing.FillStyle","NONE"))

/*set background size*/
width = rasterwidth*raster_x
height = rasterheight*raster_y
oBackgroundSize = .bsf~new("com.sun.star.awt.Size")
oBackgroundSize~bsf.setFieldValue("Height",trunc(height))
oBackgroundSize~bsf.setFieldValue("Width",trunc(width))
oBackground~XShape~setSize(oBackgroundSize)

/*set background position*/
oBackgroundPos=.bsf~new("com.sun.star.awt.Point")
oBackgroundPos~bsf.setFieldValue("X",0)
oBackgroundPos~bsf.setFieldValue("Y",0)
oBackground~XShape~setPosition(oBackgroundPos)
oDrawPage~XShapes~add(oBackground~XShape)

/*iterate and set positions*/
pageoffsetheight = 0
do j=1 to raster_y
	pageoffsetwidth = 0
	do k=1 to raster_x
		i=(j-1)*raster_x+k
		sGraphicURL=imports[i]
		oGraphic = xMSF~createInstance("com.sun.star.drawing.GraphicObjectShape")
		oGraphic~XPropertySet~setPropertyValue("GraphicURL",sGraphicURL)
		oShape = oGraphic~XShape

		height = pixelheights[i]/dp100thmm
		width = pixelwidths[i]/dp100thmm

		/*set the new size*/
		size=.bsf~new("com.sun.star.awt.Size")
		size~bsf.setFieldValue("height",trunc(height))
		size~bsf.setFieldValue("width",trunc(width))
		oShape~setSize(size)

		/*calculate offset*/

		customoffsetwidth = pageoffsetwidth + ((rasterwidth - width)/2)
		customoffsetheight = pageoffsetheight + ((rasterheight - height)/2)

		/*set the new position*/
		pos=.bsf~new("com.sun.star.awt.Point")
		pos~bsf.setFieldValue("X",trunc(customoffsetwidth))
		pos~bsf.setFieldValue("Y",trunc(customoffsetheight))
		oShape~setPosition(pos)

		oDrawPage~XShapes~add(oShape)

		pageoffsetwidth = pageoffsetwidth + rasterwidth
	end
	pageoffsetheight = pageoffsetheight + rasterheight
end

/*export to one image file*/
xSelectionSupplier = xdoc~XModel~getCurrentController~XSelectionSupplier
/*select all XShapes of the current page - we want to export all of them*/
xSelectionSupplier~select(oDrawPage~XShapes)

/*get the selection*/
xSelection = xSelectionSupplier~getSelection()

/*calculate the size*/
size_x = trunc(pageoffsetwidth*dp100thmm)
size_y = trunc(pageoffsetheight*dp100thmm)

/*setup the filter*/
aFilterData = uno.createArray(.UNO~PROPERTYVALUE,5)
aFilterData[1]=uno.createProperty("PixelWidth",box("I",size_x))
aFilterData[2]=uno.createProperty("PixelHeight",box("I",size_y))
aFilterData[3]=uno.createProperty("LogicalWidth",box("I",trunc(pageoffsetwidth)))
aFilterData[4]=uno.createProperty("LogicalHeight",box("I",trunc(pageoffsetheight)))
aFilterData[5]=uno.createProperty("Quality",box("I",90))

/*get the GraphicExportFilter*/
xExporter = xMCF~createInstanceWithContext("com.sun.star.drawing.GraphicExportFilter",xcc)
xExporter~XExporter~setSourceDocument(xSelection~XComponent)

aArgs=uno.createArray(.UNO~PROPERTYVALUE,3)
aArgs[1]=uno.createProperty("MediaType","image/jpeg")
aArgs[2]=uno.createProperty("URL",exportfile)
aArgs[3]=uno.createProperty("FilterData",aFilterData)

ret = xExporter~XFilter~filter(aArgs)
return ret

