xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

oFilePicker = xMCF~XMultiServiceFactory~createInstance("com.sun.star.ui.dialogs.FilePicker")

aListAny = bsf.createArray("Short.class",1)
aListAny[1]=box("short",bsf.getStaticValue("com.sun.star.ui.dialogs.TemplateDescription","FILESAVE_AUTOEXTENSION"))
oFilePicker~XInitialization~initialize(aListAny)
xFileManager = oFilePicker~XFilterManager~appendFilter("OpenOffice.org Base","*.odb")

file=.nil
oFilePicker~XExecutableDialog~execute()
file = oFilePicker~XFilePicker~getFiles()~makeArray(" ")~at(1)

if file==.nil then
do
 .bsf.dialog~messageBox("No file selected - exiting".)
 exit
end

oSimpleFileAccess = xMCF~XMultiServiceFactory~createInstance("com.sun.star.ucb.SimpleFileAccess")
if oSimpleFileAccess~XSimpleFileAccess2~exists(file) then
do
	signal on ANY
	oSimpleFileAccess~XSimpleFileAccess2~kill(file)
end


table="address"
name="addresses"

oDatabaseContext = xMCF~createInstanceWithContext("com.sun.star.sdb.DatabaseContext",xcc)
xSingleServiceFactory = oDatabaseContext~XSingleServiceFactory
oDataSource=xSingleServiceFactory~createInstance()

oDataSource~XPropertySet~setPropertyValue("URL","sdbc:embedded:hsqldb")

/*get the document*/
oDatabaseDocument = oDataSource~XDocumentDataSource~getDatabaseDocument
oDatabaseDocument~XStorable~storeAsURL(file,uno.createArray(.UNO~PROPERTYVALUE,0))

xSingleServiceFactory~XNamingService~registerObject(name,oDataSource)

oDatabase = oDatabaseContext~XNameAccess~getByName(file)

/*now connect to the DB*/
oConnection = oDatabase~XDataSource~getConnection("","")
oTables = oConnection~XTablesSupplier~getTables()

if oTables~XNameAccess~hasByName(table) then
do
	oTables~XDrop~dropByName(table)
end

oTableDescriptor = oTables~XDataDescriptorFactory~createDataDescriptor()
oTableDescriptor~XPropertySet~setPropertyValue("Name",table)

oColumns = oTableDescriptor~XColumnsSupplier~getColumns()
oColumnDescriptor = oColumns~XDataDescriptorFactory~createDataDescriptor()

oColumnDescriptor~XPropertySet~setPropertyValue("Name","ID")
oColumnDescriptor~XPropertySet~setPropertyValue("Description","Primary Key")
oColumnDescriptor~XPropertySet~setPropertyValue("Precision",box("integer",10))
oColumnDescriptor~XPropertySet~setPropertyValue("IsNullable",box("integer",bsf.getStaticValue("com.sun.star.sdbc.ColumnValue","NO_NULLS")))
oColumnDescriptor~XPropertySet~setPropertyValue("IsAutoIncrement",box("boolean",.true))
oColumnDescriptor~XPropertySet~setPropertyValue("Type",box("integer",bsf.getStaticValue("com.sun.star.sdbc.DataType","INTEGER")))
oColumns~XAppend~appendByDescriptor(oColumnDescriptor)

oColumnDescriptor~XPropertySet~setPropertyValue("Name","First Name")
oColumnDescriptor~XPropertySet~setPropertyValue("Precision",box("integer",100))
oColumnDescriptor~XPropertySet~setPropertyValue("IsNullable",box("integer",bsf.getStaticValue("com.sun.star.sdbc.ColumnValue","NO_NULLS")))
oColumnDescriptor~XPropertySet~setPropertyValue("IsAutoIncrement",box("boolean",.false))
oColumnDescriptor~XPropertySet~setPropertyValue("Type",box("integer",bsf.getStaticValue("com.sun.star.sdbc.DataType","VARCHAR")))
oColumns~XAppend~appendByDescriptor(oColumnDescriptor)


oColumnDescriptor~XPropertySet~setPropertyValue("Name","Last Name")
oColumnDescriptor~XPropertySet~setPropertyValue("Precision",box("integer",100))
oColumnDescriptor~XPropertySet~setPropertyValue("IsNullable",box("integer",bsf.getStaticValue("com.sun.star.sdbc.ColumnValue","NO_NULLS")))
oColumnDescriptor~XPropertySet~setPropertyValue("IsAutoIncrement",box("boolean",.false))
oColumnDescriptor~XPropertySet~setPropertyValue("Type",box("integer",bsf.getStaticValue("com.sun.star.sdbc.DataType","VARCHAR")))
oColumns~XAppend~appendByDescriptor(oColumnDescriptor)


oColumnDescriptor~XPropertySet~setPropertyValue("Name","Street")
oColumnDescriptor~XPropertySet~setPropertyValue("Precision",box("integer",100))
oColumnDescriptor~XPropertySet~setPropertyValue("IsNullable",box("integer",bsf.getStaticValue("com.sun.star.sdbc.ColumnValue","NO_NULLS")))
oColumnDescriptor~XPropertySet~setPropertyValue("IsAutoIncrement",box("boolean",.false))
oColumnDescriptor~XPropertySet~setPropertyValue("Type",box("integer",bsf.getStaticValue("com.sun.star.sdbc.DataType","VARCHAR")))
oColumns~XAppend~appendByDescriptor(oColumnDescriptor)


oColumnDescriptor~XPropertySet~setPropertyValue("Name","ZIP")
oColumnDescriptor~XPropertySet~setPropertyValue("Precision",box("integer",100))
oColumnDescriptor~XPropertySet~setPropertyValue("IsNullable",box("integer",bsf.getStaticValue("com.sun.star.sdbc.ColumnValue","NO_NULLS")))
oColumnDescriptor~XPropertySet~setPropertyValue("IsAutoIncrement",box("boolean",.false))
oColumnDescriptor~XPropertySet~setPropertyValue("Type",box("integer",bsf.getStaticValue("com.sun.star.sdbc.DataType","VARCHAR")))
oColumns~XAppend~appendByDescriptor(oColumnDescriptor)


oColumnDescriptor~XPropertySet~setPropertyValue("Name","City")
oColumnDescriptor~XPropertySet~setPropertyValue("Precision",box("integer",100))
oColumnDescriptor~XPropertySet~setPropertyValue("IsNullable",box("integer",bsf.getStaticValue("com.sun.star.sdbc.ColumnValue","NO_NULLS")))
oColumnDescriptor~XPropertySet~setPropertyValue("IsAutoIncrement",box("boolean",.false))
oColumnDescriptor~XPropertySet~setPropertyValue("Type",box("integer",bsf.getStaticValue("com.sun.star.sdbc.DataType","VARCHAR")))
oColumns~XAppend~appendByDescriptor(oColumnDescriptor)


oColumnDescriptor~XPropertySet~setPropertyValue("Name","Sex")
oColumnDescriptor~XPropertySet~setPropertyValue("Precision",box("integer",100))
oColumnDescriptor~XPropertySet~setPropertyValue("IsNullable",box("integer",bsf.getStaticValue("com.sun.star.sdbc.ColumnValue","NO_NULLS")))
oColumnDescriptor~XPropertySet~setPropertyValue("IsAutoIncrement",box("boolean",.false))
oColumnDescriptor~XPropertySet~setPropertyValue("Type",box("integer",bsf.getStaticValue("com.sun.star.sdbc.DataType","TINYINT")))
oColumns~XAppend~appendByDescriptor(oColumnDescriptor)

oTables~XAppend~appendByDescriptor(oTableDescriptor)

oDatabaseDocument = oDatabase~XDocumentDataSource~getDatabaseDocument
oDatabaseDocument~XStorable~store()

sSQL = 'INSERT INTO "address"("First Name","Last Name","Street","ZIP","City","Sex") VALUES(?,?,?,?,?,?)'
oStatement = oConnection~XConnection~prepareStatement(sSQL)

oStatement~XParameters~setString(1,"Christoph")
oStatement~XParameters~setString(2,"Waglechner")
oStatement~XParameters~setString(3,"Augasse 2-6")
oStatement~XParameters~setString(4,"1090")
oStatement~XParameters~setString(5,"Wien")
oStatement~XParameters~setString(6,0)
oStatement~XPreparedStatement~executeUpdate()

oStatement~XParameters~setString(1,"Max")
oStatement~XParameters~setString(2,"Mustermann")
oStatement~XParameters~setString(3,"Billrothstrae 1")
oStatement~XParameters~setString(4,"1051")
oStatement~XParameters~setString(5,"Wien")
oStatement~XParameters~setString(6,0)
oStatement~XPreparedStatement~executeUpdate()

oStatement~XParameters~setString(1,"Elisabeth")
oStatement~XParameters~setString(2,"Testerin")
oStatement~XParameters~setString(3,"Genzgasse 3/1/2")
oStatement~XParameters~setString(4,"7000")
oStatement~XParameters~setString(5,"Eisenstadt")
oStatement~XParameters~setString(6,1)
oStatement~XPreparedStatement~executeUpdate()

oConnection~XCloseable~close()
oDatabaseDocument~XCloseable~close(.true)

.bsf.dialog~messageBox("File" file "and basic datasets created, registered as" name ".")

exit 0

ANY:
	.bsf.dialog~messageBox("Could not delete file. Maybe opened? Exiting.")
	exit

::requires UNO.cls

