/*Helper script creating the styles necessary for example 21*/
/*Styles creation procedure taken from Frysak, Josef: Automating Open Office - ooRexx Nutshells, 2008*/
/*Properties taken from Hinz, Michael: OpenOffice.org Calc Automation Using ooRexx, 2006*/

xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF = xcc~getServiceManager()
xMSF = xdoc~XMultiServiceFactory

/*search for style name*/
x_StyleFamiliesSupplier = xdoc~XStyleFamiliesSupplier
x_StyleFamilies = x_StyleFamiliesSupplier~getStyleFamilies()
s_StyleFamily = x_StyleFamilies~getByName("CellStyles")
x_NameAccess = s_StyleFamily~XNameAccess

if \ x_NameAccess~hasByName("red") then
do

   oCellStyle = xMSF~createInstance("com.sun.star.style.CellStyle")
   x_NameAccess~insertByName("red", oCellStyle)
   oCellStyle~XPropertySet~setPropertyValue("CellBackColor",box("int","990000"x~c2d))
   oCellStyle~XPropertySet~setPropertyValue("IsCellBackgroundTransparent",box("boolean",.false))
   oCellStyle~XPropertySet~setPropertyValue("CharColor",box("int","FFFFFF"x~c2d))
end

if \ x_NameAccess~hasByName("green") then
do

   oCellStyle = xMSF~createInstance("com.sun.star.style.CellStyle")
   x_NameAccess~insertByName("green", oCellStyle)
   oCellStyle~XPropertySet~setPropertyValue("CellBackColor",box("int","009900"x~c2d))
   oCellStyle~XPropertySet~setPropertyValue("IsCellBackgroundTransparent",box("boolean",.false))
   oCellStyle~XPropertySet~setPropertyValue("CharColor",box("int","FFFFFF"x~c2d))
end

::requires UNO.cls

