xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end
xMCF=xcc~getServiceManager()

call bsf.import "com.sun.star.beans.StringPair","StringPair.class"
filters=bsf.createArray(.StringPair.class,3)
sp = .StringPair.class~new()
sp~bsf.setFieldValue("First","GIF")
sp~bsf.setFieldValue("Second","*.gif")
filters~put(sp,1)
sp = .StringPair.class~new()
sp~bsf.setFieldValue("First","JPG")
sp~bsf.setFieldValue("Second","*.jpg;*.jpeg")
filters~put(sp,2)
sp = .StringPair.class~new()
sp~bsf.setFieldValue("First","PNG")
sp~bsf.setFieldValue("Second","*.png")
filters~put(sp,3)

sGraphicURL = .nil
do while sGraphicURL==.nil
oFilePicker=xMCF~XMultiServiceFactory~createInstance("com.sun.star.ui.dialogs.FilePicker")
oFilePicker~XFilePicker~setMultiSelectionMode(.false)
oFilePicker~XFilterGroupManager~appendFilterGroup("Graphics",filters)
oFilePicker~XFilePicker~XExecutableDialog~execute()
sGraphicURL = oFilePicker~XFilePicker~getFiles()~makeArray(" ")~at(1)
end

/* create the TextObject and the TextCursor */
xTextDocument = xdoc~XTextDocument
xText = XTextDocument~getText()
xTextCursor = xText~createTextCursor()
xDMsf = xTextDocument~XMultiServiceFactory

size = .bsf~new("com.sun.star.awt.Size")
size~Height = 1160
size~Width = 4000

/****GraphicObjectShape****/
/*Burger 2006*/
oGraph = xDMsf~createInstance("com.sun.star.drawing.GraphicObjectShape")
xGraph = oGraph~xShape
xGraph~setSize(size)
xPropertySet=xGraph~xPropertySet
xPropertySet~setPropertyValue("GraphicURL", sGraphicURL)
xText~insertTextContent(xText~getEnd,oGraph~XTextContent, .false)

/****TextGraphicObject****/
/*Gmeiner 2008*/
oTextGraphic = xDMsf~createInstance("com.sun.star.text.TextGraphicObject")
xGraphicProperties = oTextGraphic~XPropertySet
xGraphicProperties~setPropertyValue("GraphicURL", sGraphicURL) 
xGraphicProperties~setPropertyValue("AnchorType",bsf.getConstant("com.sun.star.text.TextContentAnchorType", "AS_CHARACTER"))
xGraphicProperties~setPropertyValue("Size",size)
xText~insertTextContent(xText~getEnd, oTextGraphic~XTextContent, .false)

::requires UNO.cls

