/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.javaFirefoxExtensionUtils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ClassWrapper {
    private Class m_class;
    private static final Class[] s_primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    private static final Class[] s_primitiveClasses = new Class[]{Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class};

    ClassWrapper(Class klass) {
        this.m_class = klass;
    }

    public Class getWrappedClass() {
        return this.m_class;
    }

    public String getWrappedClassName() {
        return this.m_class.getName();
    }

    public Set getUniqueMethodNames() {
        Method[] methods = this.m_class.getMethods();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            names.add(m.getName());
            ++i;
        }
        return names;
    }

    public Set getFieldNames() {
        Field[] fields = this.m_class.getFields();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < fields.length) {
            Field f = fields[i];
            names.add(f.getName());
            ++i;
        }
        return names;
    }

    public Object getField(String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        return this.m_class.getField(name).get(null);
    }

    public Object callMethod(String name, Object[] arguments) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] methods = this.m_class.getMethods();
        Method applicableMethod = null;
        Object[] coercedArguments = new Object[arguments.length];
        int i = 0;
        while (i < methods.length) {
            Class[] paramTypes;
            Method m = methods[i];
            if (m.getName().equals(name) && (paramTypes = m.getParameterTypes()).length == arguments.length) {
                int j = 0;
                while (j < paramTypes.length) {
                    if (!this.argumentMatchType(arguments, paramTypes, coercedArguments, j)) break;
                    ++j;
                }
                if (j == paramTypes.length) {
                    if (applicableMethod == null) {
                        applicableMethod = m;
                    } else {
                        throw new NoSuchMethodError("More than one method named " + name + " is applicable on provided arguments");
                    }
                }
            }
            ++i;
        }
        if (applicableMethod != null) {
            return applicableMethod.invoke(null, coercedArguments);
        }
        throw new NoSuchMethodError("No method named " + name + " is applicable on provided arguments");
    }

    public Object callConstructor(Object[] arguments) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors = this.m_class.getConstructors();
        Constructor<?> applicableConstructor = null;
        Object[] coercedArguments = new Object[arguments.length];
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> c = constructors[i];
            Class[] paramTypes = c.getParameterTypes();
            if (paramTypes.length == arguments.length) {
                int j = 0;
                while (j < paramTypes.length) {
                    if (!this.argumentMatchType(arguments, paramTypes, coercedArguments, j)) break;
                    ++j;
                }
                if (j == paramTypes.length) {
                    if (applicableConstructor == null) {
                        applicableConstructor = c;
                    } else {
                        throw new NoSuchMethodError("More than one constructor is applicable on provided arguments");
                    }
                }
            }
            ++i;
        }
        if (applicableConstructor != null) {
            return applicableConstructor.newInstance(coercedArguments);
        }
        throw new NoSuchMethodError("No constructor is applicable on provided arguments");
    }

    private boolean argumentMatchType(Object[] arguments, Class[] types, Object[] coercedArguments, int index) {
        float f;
        Object argument = arguments[index];
        Class type = types[index];
        coercedArguments[index] = argument;
        if (argument == null) {
            coercedArguments[index] = null;
            return true;
        }
        if (type.isAssignableFrom(argument.getClass())) {
            coercedArguments[index] = argument;
            return true;
        }
        if (type.equals(String.class)) {
            coercedArguments[index] = argument.toString();
            return true;
        }
        if (argument instanceof Double) {
            double d = (Double)argument;
            if (d - (double)((int)d) == 0.0) {
                coercedArguments[index] = new Integer((int)d);
            }
        } else if (argument instanceof Float && (f = ((Float)argument).floatValue()) - (float)((int)f) == 0.0f) {
            coercedArguments[index] = new Integer((int)f);
        }
        if (type.isPrimitive()) {
            int i = 0;
            while (i < s_primitiveClasses.length) {
                if (type.equals(s_primitiveTypes[i])) {
                    type = s_primitiveClasses[i];
                    break;
                }
                ++i;
            }
        }
        return type.isAssignableFrom(coercedArguments[index].getClass());
    }
}

