/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.javaFirefoxExtensionUtils;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;

public class TracingClassLoader
extends URLClassLoader {
    boolean m_trace = false;

    public static URLClassLoader newInstance(boolean trace) {
        return new TracingClassLoader(trace);
    }

    private TracingClassLoader(boolean trace) {
        super(new URL[0]);
        this.m_trace = trace;
    }

    public void add(URL url) {
        super.addURL(url);
    }

    public void setTracing(boolean enable) {
        this.m_trace = enable;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = super.loadClass(name, resolve);
        this.trace(name);
        return clazz;
    }

    public URL getResource(String name) {
        URL url = super.getResource(name);
        this.trace(String.valueOf(name) + " -> " + url);
        return url;
    }

    private void trace(String msg) {
        if (this.m_trace) {
            Date d = new Date();
            long millis = System.currentTimeMillis() % 1000L;
            System.out.println(String.valueOf(TracingClassLoader.pad(d.getHours(), 2)) + ":" + TracingClassLoader.pad(d.getMinutes(), 2) + ":" + TracingClassLoader.pad(d.getSeconds(), 2) + "." + TracingClassLoader.pad(millis, 3) + " [classloader] " + msg);
        }
    }

    private static String pad(long number, int digits) {
        StringBuffer str = new StringBuffer(Long.toString(number));
        int i = digits - 1;
        while (i > 0) {
            if ((double)number < Math.pow(10.0, i)) {
                str.insert(0, '0');
            }
            --i;
        }
        return str.toString();
    }
}

