/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.javaFirefoxExtensionUtils;

import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class URLSetPolicy
extends Policy {
    private MyPermissions m_permissions = new MyPermissions();
    private Policy m_outerPolicy;
    private Set m_urls = new HashSet();

    public void refresh() {
        if (this.m_outerPolicy != null) {
            this.m_outerPolicy.refresh();
        }
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        String s;
        PermissionCollection pc = this.m_outerPolicy != null ? this.m_outerPolicy.getPermissions(codesource) : new Permissions();
        URL url = codesource.getLocation();
        if (url != null && (this.m_urls.contains(s = url.toExternalForm()) || "file:".equals(s))) {
            Enumeration e = this.m_permissions.elements();
            while (e.hasMoreElements()) {
                pc.add((Permission)e.nextElement());
            }
        }
        return pc;
    }

    public void setOuterPolicy(Policy policy) {
        this.m_outerPolicy = policy;
    }

    public void addPermission(Permission permission) {
        this.m_permissions.add(permission);
    }

    public void addURL(URL url) {
        this.m_urls.add(url.toExternalForm());
    }

    private static class MyPermissions
    extends PermissionCollection {
        private static final long serialVersionUID = 602331721988458546L;
        Permissions m_permissions = new Permissions();

        private MyPermissions() {
        }

        public void add(Permission permission) {
            this.m_permissions.add(permission);
        }

        public boolean implies(Permission permission) {
            return this.m_permissions.implies(permission);
        }

        public Enumeration elements() {
            return this.m_permissions.elements();
        }
    }
}

