/**
* 	Java program embeds XPCOM environment and explains the necessary steps.
*	 Different XPCOM services open a URL and a startup application displays the
*          content in a separate DOM window.
* 	Just start the main method, no arguments required at the moment.
 */

import java.io.*;
import java.util.*;
import org.mozilla.xpcom.*;

import org.mozilla.interfaces.nsIAppStartup;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIFile;
import org.mozilla.interfaces.nsILocalFile;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISimpleEnumerator;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWindowCreator;
import org.mozilla.interfaces.nsIWindowWatcher;


public class WindowCreator {

	/* main() embeds XPCOM environment and opens an URL in a DOMWindow
	/**************************************************************/
	public static void main(String []args) throws Exception {
    
	String targetURL = "http://www.kurier.at";
	
	GREVersionRange[] range = new GREVersionRange[1];
    range[0] = new GREVersionRange("1.8", true, "1.9+", true);
	
	File grePath = null;
	/** get a Mozilla class instance and the path to the Gecko Runtime Environment (GRE)    */
    try {
      grePath = Mozilla.getGREPathWithProperties(range, null);
    } 
		catch (FileNotFoundException e) { }
      
    if (grePath == null) {
      System.out.println("found no GRE PATH");
      return;
    }
    System.out.println("GRE PATH = " + grePath.getPath());
    
	Mozilla mozilla = Mozilla.getInstance();
	
	/** try embedding the XPCOM environment using the GRE path  */
    try {
		mozilla.initialize(grePath);
		mozilla.initXPCOM(grePath, null);
    } 
		catch (IllegalArgumentException e) {
			System.out.println("no javaxpcom.jar found in given path");
			return;
		} 
		catch (Throwable t) {
			System.out.println("initXPCOM failed");
			t.printStackTrace();
			return;
		}
	
	/**  XPCOM is successfully embedded  */
	System.out.println("\n--> initialized\n");

	try {	

     // To get access to interfaces we get an instance of the XPCOM service manager
     nsIServiceManager serviceManager = mozilla.getServiceManager();
     // Use contract ID (@mozilla.org/toolkit/app-startup;1) and IID to get startup application nsIAppStartup
     nsIAppStartup appStartup = (nsIAppStartup)serviceManager.getServiceByContractID
								("@mozilla.org/toolkit/app-startup;1", nsIAppStartup.NS_IAPPSTARTUP_IID);	 
     // Get the nsIWindowCreator interface through appStartup
     nsIWindowCreator windowCreator = (nsIWindowCreator)appStartup.queryInterface(nsIWindowCreator.NS_IWINDOWCREATOR_IID); 
     // Get the nsIWindowWatcher interface 
     nsIWindowWatcher windowWatcher = (nsIWindowWatcher)serviceManager.getServiceByContractID
									  ("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.NS_IWINDOWWATCHER_IID);

     // Set the window creator
     windowWatcher.setWindowCreator(windowCreator); 
     // Create the DOMWindow with the supplied URL
     nsIDOMWindow win = windowWatcher.openWindow(null, targetURL, "mywindow", "chrome,resizable,centerscreen", null);
     // DOMWindow win is active window
     windowWatcher.setActiveWindow(win);
     // Start the XPCOM startup application
     appStartup.run();
		
	}
	catch (XPCOMException e) { e.printStackTrace(); }	
	   
	// shut down XPCOM embedding   
	mozilla.shutdownXPCOM(null);
	
	}
}
