 /******************************************************************** 
 ** This script is part of a XULRunner application: 
 ** (see Readme.text in top level directory for more information)
 ** 
 ** This JS script receives a call by the XUL template, creates a Java class loader using the 
 ** following jar Files: javaFirefoxExtensionUtils.jar 
 ** 			 javaxpcom.jar	
 **			 MozillaGlue.jar
 **			 MozillaInterfaces.jar
 **			 bsf-rexx-engine.jar
 **			 bsf-v400-20090910.jar
 ** The Jars are collected in a Java Class Loader, which gives the proper permissions.
 ** Now we can instantiate and call our custom Java class "JavaBSF.class".
 **
 ** Customize: change vars myJar, bsf1, bsf2, xpcom1, xpcom2 and xpcom3 to your installation dirs !
 **
 ** Output: calls JavaBSF.launchUrl(String targetUrl), which launches ooRexx script							
 **********************************************************************/ 

function useClassLoader () {

// Get path to the following JAR files
try {
	// get the desktop directory
	var file = Components.classes["@mozilla.org/file/directory_service;1"].  
                      getService(Components.interfaces.nsIProperties).  
                      get("Desk", Components.interfaces.nsIFile);  
	var desktop = file.path;

// You must add this utilities JAR (javaFirefoxExtensionUtils.jar) to give your application full privileges
var myJar  = "file:///"+desktop+"/xulrunner/chrome/xulrunner/javaFirefoxExtensionUtils.jar";
var xpcom1  = "file:///C:/xulrunner-1.9.2/bin/javaxpcom.jar";
var xpcom2  = "file:///C:/xulrunner-1.9.2/sdk/lib/MozillaGlue.jar";
var xpcom3  = "file:///C:/xulrunner-1.9.2/sdk/lib/MozillaInterfaces.jar";
var bsf1  = "file:///C:/Program Files/bsf4oorexx/bsf-rexx-engine.jar";
var bsf2  = "file:///C:/Program Files/bsf4oorexx/bsf-v400-20090910.jar";

	// Builds a regular JavaScript array (LiveConnect will auto-convert to a Java array)
	var urlArray = []; 
	urlArray[0] = new java.net.URL(myJar);
	urlArray[1] = new java.net.URL(xpcom1);
	urlArray[2] = new java.net.URL(xpcom2);
	urlArray[3] = new java.net.URL(xpcom3);
	urlArray[4] = new java.net.URL(bsf1);
	urlArray[5] = new java.net.URL(bsf2);
	var cl = java.net.URLClassLoader.newInstance(urlArray);
     
	// Set security policies using the above policyAdd() method
	policyAdd(cl, urlArray);

	var url = document.getElementById("urlField").value; 
	alert("Opening this URL: " + url);
	// launch URL
	launchUrl(cl, url, desktop);
}
catch(e) {alert(e+' ::useClassLoader:: '+e.lineNumber);}
}

// launches the target URL, using the Java class loader and JavaBSF.class
function launchUrl (loader, url, desktop) {

try {
	var myClass = loader.loadClass('edu.mit.simile.javaFirefoxExtensionUtils.JavaBSF');
	var myObj = myClass.newInstance(); // instantiates JavaBSF class
	// alert("launching JavaBSF class");
	var response = myObj.launchUrl(url); // calls JavaBSF, pass whatever arguments you need
	alert(response); 	
}
catch(e) {alert(e+' ::launchUrl:: '+response);}

}


// This function will give the necessary privileges to the JAR files in your ClassLoader
function policyAdd (loader, urls) {
try {     
        var str = 'edu.mit.simile.javaFirefoxExtensionUtils.URLSetPolicy';
        var policyClass = java.lang.Class.forName(str, true, loader);

        var policy = policyClass.newInstance();
        policy.setOuterPolicy(java.security.Policy.getPolicy());
        java.security.Policy.setPolicy(policy);
        policy.addPermission(new java.security.AllPermission());

        for (var j=0; j < urls.length; j++) {
            policy.addURL(urls[j]);
        }
}
catch(e) {alert(e+' ::policyAdd:: '+e.lineNumber);}
}
    

