 /******************************************************************** 
 ** This script is part of a XULRunner application: 
 ** (see Readme.text in top level directory for more information)
 ** 
 ** This ooRexx script receives an URL, implements XPCOM embedding and calls   			
 ** several XPCOM services to open a new window.  				
 **
 ** Customize: change String "grePathName" in the first line to your XULRunner/bin directory!
 ** 
 ** Paramaters: receives String "targetUrl" as a BSF bean
 **
 ** Output: opens a new window using "targetUrl"										
 **********************************************************************/ 

/** Insert Path to your XULRunner installation directory, which contains the JavaXPCOM library "javaxpcom.jar" */

grePathName = "C:/xulrunner-1.9.2/bin"  
/*************************************/

.bsf~bsf.import('java.io.File','File')
.bsf~bsf.import('java.lang.System','System')
.bsf~bsf.import('org.mozilla.xpcom.Mozilla','Mozilla')
.bsf~bsf.import('org.mozilla.xpcom.GREVersionRange','GREVersionRange')
.bsf~bsf.import('org.mozilla.interfaces.nsIAppStartup','nsIAppStartup')
.bsf~bsf.import('org.mozilla.interfaces.nsIDOMWindow','nsIDOMWindow')
.bsf~bsf.import('org.mozilla.interfaces.nsIServiceManager','nsIServiceManager')
.bsf~bsf.import('org.mozilla.interfaces.nsIWindowCreator','nsIWindowCreator')
.bsf~bsf.import('org.mozilla.interfaces.nsIWindowWatcher','nsIWindowWatcher')

/** Target URL to open (explicit or by BSF bean) */
targetUrl = .bsf~bsf.lookupBean('targetUrl')
if targetUrl = .nil then targetUrl = 'http://derstandard.at'

/** Initiate XPCOM embedding */
path = .System~getProperty('GRE_PATH')
 -- set grePathName manually (see first line)
if path = .nil then grePath = .File~new(grePathName) 
else grePath = .File~new(path)
say 'Gecko Runtime Engine path:  ' grePath~getPath											

mozilla = .Mozilla~getInstance
	mozilla~initialize(grePath)
	mozilla~initXPCOM(grePath, .nil)
say 'Mozilla XPCOM initialized!'

/** Get the Service Manager (responsible for acquiring XPCOM objects) */
serviceManager = mozilla~getServiceManager

/** Retrieve necessary property values and XPCOM interface IIDs */
appStartupID    = .bsf~bsf.getStaticValue(.nsIAppStartup, 'NS_IAPPSTARTUP_IID')
windowCreatorID = .bsf~bsf.getStaticValue(.nsIWindowCreator, 'NS_IWINDOWCREATOR_IID')
windowWatcherID = .bsf~bsf.getStaticValue(.nsIWindowWatcher, 'NS_IWINDOWWATCHER_IID')
winProps = "width=1000, height=650, resizable, centerscreen, scrollbars='yes', status='yes'"

/** Set up the application and load the new window with interface nsIWindowWatcher */
appStartup = serviceManager~getServiceByContractID('@mozilla.org/toolkit/app-startup;1', appStartupID)
windowCreator = appStartup~queryInterface(windowCreatorID)
windowWatcher = serviceManager~getServiceByContractID('@mozilla.org/embedcomp/window-watcher;1', windowWatcherID)
windowWatcher~setWindowCreator(windowCreator)

window = windowWatcher~openWindow(.nil, targetUrl, 'URL Opener', winProps, .nil)
windowWatcher~setActiveWindow(window)
appStartup~run

/** Terminate XPCOM embedding */
mozilla~shutdownXPCOM(.nil)
say 'Mozilla XPCOM embedding finished!'


::requires BSF.cls  -- adds BSF support to Java and ooRexx scripts

