 /******************************************************************** 
 ** This Java class is part of a XULRunner application: 
 ** (see Readme.text in top level directory for more information)
 ** 
 ** The class JavaBSF is called by the JavaScript "ClassLoader.js" receives an URL, 
 ** implements BSF (BSFManager and BSFEngine) and launches the ooRexx script "Window.rex"   				
 **
 ** Customize: Usually no configuration required.
 ** 	       If either the ooRexx script "Window.rex" or the Error Logger file "java/ErrorLog.txt" 
 **	       can not be found, change the paths for the variables "scriptName" and "log"
 ** 
 ** Paramaters: receives String "targetUrl" from ClassLoader.js
 **
 ** Output: launches ooRexx script "Window.rex"
 **
 ** Warning: If you change this Java class, you have to load the new 
 **          .class file into the JAR archive "javaFirefoxExtensionUtils.jar"  
 **********************************************************************/ 

package edu.mit.simile.javaFirefoxExtensionUtils;

import java.lang.*;
import java.util.logging.*;
import java.io.*;
import org.apache.bsf.*;
import org.apache.bsf.util.*;

public class JavaBSF {
	
	private Logger logger = Logger.getLogger("");
	String targetUrl;
	String currentDir;

/** launchUrl() receives the targetUrl from JavaScript and launches the ooRexx script  */	
public String launchUrl (String url) {	
	
    try {
	// Get instance of BSFManager (beans and launching the script)    
        BSFManager bsf = new BSFManager();  

	// package targetUrl as a BSF bean
	if (url != null) targetUrl = url;
	else 	 	 targetUrl = "http://www.orf.at/";
     	bsf.registerBean("targetUrl", targetUrl);

 	// current directory 
	// when called by xulrunner app, it is the directory of application.ini (top level)
	currentDir = new File(".").getAbsolutePath();
	System.out.println(currentDir);	

	// retrieve information from script
	String scriptName = currentDir + "/chrome/xulrunner/Window.rex"; 
	String language = bsf.getLangFromFilename(scriptName);
        FileReader in = new FileReader(scriptName);
     	String rexxCode = IOUtils.getStringFromReader(in);
	            
	// launch script and terminate BSF environment 
 	bsf.exec (language, scriptName, 0, 0, rexxCode);	
    } 
	catch (BSFException e) { e.getMessage(); e.printStackTrace(); logError(e); return e.getMessage(); } 
	catch (IOException e)  { e.getMessage(); e.printStackTrace(); logError(e); return e.getMessage(); }

return "Java/ooRexx ist fertig!";
 }

/** Simple Error Logger, receives possible errors from method launchUrl(url) */
public void logError (Exception ex) {
    	
	try {
	// current directory 
	// when called by xulrunner app, it is the directory of application.ini (top level)
	currentDir = new File(".").getAbsolutePath();
	System.out.println(currentDir);	

	String log = currentDir + "/chrome/xulrunner/java/ErrorLog.txt";     
        FileHandler handler = new FileHandler(log);
        
	logger.addHandler(handler);
        logger.setLevel(Level.ALL);
        logger.info("Error logs:");
        logger.log(Level.INFO, "", ex);
        logger.fine("");
    }
    catch (Exception e) { e.printStackTrace(); }	    
}

/** main method for command line test purposes */
/**
public static void main (String[] args) {
JavaBSF a = new JavaBSF();
a.launchUrl("http://www.zdf.de");
}
*/

}
