package at.ac.wu.wise2011s.android.LectureInfo;

import java.nio.charset.Charset;
import java.util.Locale;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;

import android.app.Activity;
import android.content.Intent;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;

public class Simulate_NFC_Terminal extends Activity implements OnClickListener {

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		View projektseminar = findViewById(R.id.projektseminar);
		View macroeconomics = findViewById(R.id.macroeconomics);
		projektseminar.setOnClickListener(this);
		macroeconomics.setOnClickListener(this);
	}

	public void onClick(View view) {

		switch (view.getId()) {
		case R.id.projektseminar:
			byte[] tag_google =
			/*___SP*/		new byte[] {(byte) 0xd1, (byte) 0x02, (byte) 0x1c, (byte) 0x53, (byte) 0x70, (byte) 0x91,
			/*__T_EN*/      (byte) 0x01, (byte) 0x09, (byte) 0x54, (byte) 0x02, (byte) 0x65, (byte) 0x6e,
			/*Google*/      (byte) 0x47, (byte) 0x6f, (byte) 0x6f, (byte) 0x67, (byte) 0x6c, (byte) 0x65,
			/*Q__U_ */      (byte) 0x51, (byte) 0x01, (byte) 0x0b, (byte) 0x55, (byte) 0x01,
			/*google.com*/  (byte) 0x67, (byte) 0x6f, (byte) 0x6f, (byte) 0x67, (byte) 0x6c, (byte) 0x65, (byte) 0x2e, (byte) 0x63, (byte) 0x6f, (byte) 0x6d};


			byte[] tag = new byte[] { (byte) 0xd1, (byte) 0x02, (byte) 0x1c,
					(byte) 0x53, (byte) 0x70, (byte) 0x91, (byte) 0x01,
					(byte) 0x09, (byte) 0x54, (byte) 0x02, (byte) 0x65,
					(byte) 0x6e, (byte) 0x4c, (byte) 0x56, (byte) 0x30,
					(byte) 0x35, (byte) 0x38, (byte) 0x31, (byte) 0x51,
					(byte) 0x01, (byte) 0x0b, (byte) 0x55, (byte) 0x01,
					(byte) 0x77, (byte) 0x75, (byte) 0x2e, (byte) 0x61,
					(byte) 0x63, (byte) 0x2e, (byte) 0x61, (byte) 0x74,
					(byte) 0x00, (byte) 0x00 };

			NdefMessage[] message;
			try {
				message = new NdefMessage[] { new NdefMessage(tag) };
			} catch (FormatException e) {
				throw new RuntimeException("NdefMessage could not be created", e);
			}
			
			final Intent intent1 = new Intent(NfcAdapter.ACTION_TAG_DISCOVERED);
			intent1.putExtra(NfcAdapter.EXTRA_NDEF_MESSAGES, message);
			startActivity(intent1);
			
			return;

		case R.id.macroeconomics:
			int score = 14;
			String lectureInfo = "Makrokonomie, LV-Leiter: Dr. Maier\n"
					+ "Mitarbeitspunkte:" + score;

			NdefRecord[] rec = { newTextRecord(lectureInfo, new Locale("de"),
					true) };
			NdefMessage[] msg = new NdefMessage[] { new NdefMessage(rec) };

			final Intent intent2 = new Intent(NfcAdapter.ACTION_TAG_DISCOVERED);
			intent2.putExtra(NfcAdapter.EXTRA_NDEF_MESSAGES, msg);
			startActivity(intent2);
		}
	}

	public static NdefRecord newTextRecord(String text, Locale locale,
			boolean encodeInUtf8) {
		Preconditions.checkNotNull(text);
		Preconditions.checkNotNull(locale);
		final byte[] langBytes = locale.getLanguage().getBytes(
				Charsets.US_ASCII);
		final Charset utfEncoding = encodeInUtf8 ? Charsets.UTF_8 : Charset
				.forName("UTF-16");
		final byte[] textBytes = text.getBytes(utfEncoding);
		final int utfBit = encodeInUtf8 ? 0 : (1 << 7);
		final char status = (char) (utfBit + langBytes.length);
		final byte[] data = Bytes.concat(new byte[] { (byte) status },
				langBytes, textBytes);
		return new NdefRecord(NdefRecord.TNF_WELL_KNOWN, NdefRecord.RTD_TEXT,
				new byte[0], data);
	}

}