package at.ac.wu.wise2011s.android;

import android.app.Activity;
import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.Toast;

import static at.ac.wu.wise2011s.android.DbConst.TABLE;
import static at.ac.wu.wise2011s.android.DbConst.HALL;
import static at.ac.wu.wise2011s.android.DbConst.QUESTION;
import static at.ac.wu.wise2011s.android.DbConst.NICKNAME;
import static at.ac.wu.wise2011s.android.DbConst.TIME;
import static at.ac.wu.wise2011s.android.DbConst.RANK;

public class Asking extends Activity implements OnClickListener {

	private DbHelper dbh;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.asking);

		dbh = new DbHelper(this);

		View askButton = findViewById(R.id.askButton);
		askButton.setOnClickListener(this);
	}

	public void onResume() {
		super.onResume();
		dbh = new DbHelper(this);
	}

	public void onPause() {
		super.onPause();
		dbh.close();
	}

	public void onClick(View view) {
		String question = ((EditText) findViewById(R.id.askInput)).getText()
				.toString();
		if (view.getId() == R.id.askButton && !question.isEmpty())
			postQuestion(question);
	}

	private void postQuestion(String question) {
		SQLiteDatabase db = dbh.getWritableDatabase();

		if (db.query(TABLE, null, QUESTION + "=" + "'" + question + "'", null,
				null, null, null).getCount() != 0) {
			Toast.makeText(getBaseContext(),
					"Exact same question has already been posted!",
					Toast.LENGTH_LONG).show();
			return;
		}

		ContentValues values = new ContentValues();
		values.put(HALL, Queries.getHall(this));
		values.put(QUESTION, question);
		values.put(TIME, System.currentTimeMillis());
		values.put(RANK, 0);

		if (Queries.getNickname(this) != "")
			values.put(NICKNAME, Queries.getNickname(this));

		db.insertOrThrow(TABLE, null, values);
		db.close();

		Toast.makeText(getBaseContext(), "Your question was posted!",
				Toast.LENGTH_LONG).show();
	}

}