package at.ac.wu.wise2011s.android;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import static android.provider.BaseColumns._ID;
import static at.ac.wu.wise2011s.android.DbConst.TABLE;
import static at.ac.wu.wise2011s.android.DbConst.HALL;
import static at.ac.wu.wise2011s.android.DbConst.QUESTION;
import static at.ac.wu.wise2011s.android.DbConst.NICKNAME;
import static at.ac.wu.wise2011s.android.DbConst.TIME;
import static at.ac.wu.wise2011s.android.DbConst.RANK;

public class DbHelper extends SQLiteOpenHelper {
	private static final String DATABASE_NAME = "queries.db";
	private static final int DATABASE_VERSION = 1;

	public DbHelper(Context context) {
		super(context, DATABASE_NAME, null, DATABASE_VERSION);
	}

	public void onCreate(SQLiteDatabase database) {
		database.execSQL("CREATE TABLE " + TABLE + " (" + _ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT, " + HALL
				+ " TEXT NOT NULL, " + QUESTION + " TEXT NOT NULL, " + NICKNAME
				+ " TEXT, " + TIME + " INTEGER NOT NULL, " + RANK
				+ " INTEGER NOT NULL);");
	}

	public void onUpgrade(SQLiteDatabase database, int oldVersion,
			int newVersion) {
		database.execSQL("DROP TABLE IF EXISTS " + TABLE);
		onCreate(database);
	}

}