package at.ac.wu.wise2011s.android;

import android.app.ListActivity;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.Toast;

import static android.provider.BaseColumns._ID;
import static at.ac.wu.wise2011s.android.DbConst.TABLE;
import static at.ac.wu.wise2011s.android.DbConst.HALL;
import static at.ac.wu.wise2011s.android.DbConst.QUESTION;
import static at.ac.wu.wise2011s.android.DbConst.NICKNAME;
import static at.ac.wu.wise2011s.android.DbConst.RANK;

public class Listing extends ListActivity {
	private static String[] COLUMNS = { _ID, QUESTION, NICKNAME, RANK };
	private static String ORDER_BY = RANK + "  DESC";
	private static int[] TARGET = { R.id.identifier, R.id.question,
			R.id.nickname, R.id.rank };

	private DbHelper dbh;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.listing);

		setTitle(getTitle() + " from within " + Queries.getHall(this));

		dbh = new DbHelper(this);

		showQuestions(getQuestions());

	}

	public void onResume() {
		super.onResume();
		dbh = new DbHelper(this);
	}

	public void onPause() {
		super.onPause();
		dbh.close();
	}

	public void onListItemClick(ListView listView, View view, int position,
			long id) {

		if (Queries.getAlreadyVotedIds().contains(id))
			return;

		SQLiteDatabase db = dbh.getWritableDatabase();
		Cursor cursor = db.query(TABLE, new String[] { RANK }, _ID + "=" + "'"
				+ id + "'", null, null, null, null);

		cursor.moveToNext();
		int currentRank = cursor.getInt(cursor.getColumnIndex(RANK));

		ContentValues values = new ContentValues();

		values.put(RANK, currentRank + 1);

		if (db.update(TABLE, values, _ID + "=" + "'" + id + "'", null) == 1) {
			Queries.getAlreadyVotedIds().add(id);
			Toast.makeText(getBaseContext(),
					"Question with ID " + id + " has been voted up!",
					Toast.LENGTH_SHORT).show();
		}

		showQuestions(getQuestions());
	}

	private Cursor getQuestions() {
		SQLiteDatabase db = dbh.getReadableDatabase();
		Cursor cursor = db.query(TABLE, COLUMNS,
				HALL + "=" + "'" + Queries.getHall(this) + "'", null, null,
				null, ORDER_BY);
		startManagingCursor(cursor);
		return cursor;
	}

	private void showQuestions(Cursor cursor) {
		SimpleCursorAdapter adapter = new SimpleCursorAdapter(this,
				R.layout.item, cursor, COLUMNS, TARGET);
		setListAdapter(adapter);
	}

}