package at.ac.wu.wise2011s.android;

import java.util.ArrayList;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Toast;

public class Queries extends Activity implements OnClickListener {
	private static ArrayList<Long> alreadyVotedIds = null;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		alreadyVotedIds = new ArrayList<Long>();

		View askButton = findViewById(R.id.button_ask);
		askButton.setOnClickListener(this);
		View listButton = findViewById(R.id.button_list);
		listButton.setOnClickListener(this);
		View aboutButton = findViewById(R.id.button_about);
		aboutButton.setOnClickListener(this);
		View exitButton = findViewById(R.id.button_exit);
		exitButton.setOnClickListener(this);
	}

	public void onClick(View view) {
		switch (view.getId()) {
		case R.id.button_ask:
			if (getHall(this) == "")
				Toast.makeText(getBaseContext(),
						"Please configure the application first!",
						Toast.LENGTH_LONG).show();
			else {
				Intent iAsking = new Intent(this, Asking.class);
				startActivity(iAsking);
			}
			break;
		case R.id.button_list:
			Intent iListing = new Intent(this, Listing.class);
			startActivity(iListing);
			break;
		case R.id.button_about:
			Intent iAbout = new Intent(this, About.class);
			startActivity(iAbout);
			break;
		case R.id.button_exit:
			finish();
		}
	}

	public static ArrayList<Long> getAlreadyVotedIds() {
		return alreadyVotedIds;
	}

	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.menu, menu);
		return true;
	}

	public boolean onOptionsItemSelected(MenuItem menuItem) {
		switch (menuItem.getItemId()) {
		case R.id.config:
			startActivity(new Intent(this, Config.class));
			return true;
		}
		return false;
	}

	public static String getHall(Context context) {
		return PreferenceManager.getDefaultSharedPreferences(context)
				.getString("hall", "");
	}

	public static boolean vibrationIsEnabled(Context context) {
		return PreferenceManager.getDefaultSharedPreferences(context)
				.getBoolean("vibration", false);
	}

	public static String getNickname(Context context) {
		return PreferenceManager.getDefaultSharedPreferences(context)
				.getString("nickname", "");
	}

}