/*    
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.   
 * All rights reserved.   
 *   
 * Redistribution and use in source and binary forms, with or without   
 * modification, are permitted provided that the following conditions are   
 * met:   
 *   
 *     * Redistributions of source code must retain the above copyright   
 *        notice, this list of conditions and the following disclaimer.  
 *     * Redistributions in binary form must reproduce the above  
 *       copyright notice, this list of conditions and the following disclaimer  
 *       in the documentation and/or other materials provided with the  
 *       distribution.  
 *     * Neither the name of Samsung Electronics Co., Ltd. nor the names of its  
 *       contributors may be used to endorse or promote products derived from  
 *       this software without specific prior written permission.  
 *  
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS  
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT  
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR  
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,  
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT  
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,  
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY  
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT  
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE  
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 
package com.samsung.android.example.helloaccessoryconsumer.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.view.View;
import android.widget.TextView;

import com.samsung.android.example.helloaccessoryconsumer.service.HelloAccessoryConsumerService;
import com.samsung.android.example.helloaccessoryconsumer.R;

public class HelloAccessoryActivity extends Activity {

	static final String SAP_ACTION_ATTACHED = "android.accessory.device.action.ATTACHED";

	static final String SAP_ACTION_DETACHED = "android.accessory.device.action.DETACHED";

	private HelloAccessoryConsumerService mConsumerService = null;

	private boolean mIsBound = false;

	public static TextView mTextView;

	@Override
	protected void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);

		setContentView(R.layout.activity_main);

		mTextView = (TextView) findViewById(R.id.text1);

		doBindService();

		IntentFilter filter = new IntentFilter();

		filter.addAction(SAP_ACTION_ATTACHED);

		filter.addAction(SAP_ACTION_DETACHED);

		registerReceiver(mBroadcastReceiver, filter);
	}

	@Override
	protected void onDestroy() {

		unregisterReceiver(mBroadcastReceiver);

		closeConnection();

		doUnbindService();

		super.onDestroy();
	}

	void doBindService() {
		mIsBound = bindService(new Intent(HelloAccessoryActivity.this,
				HelloAccessoryConsumerService.class), mConnection,

		Context.BIND_AUTO_CREATE);
	}

	void doUnbindService() {
		if (mIsBound) {
			unbindService(mConnection);

			mIsBound = false;
		}
	}

	public void mOnClick(View v) {
		switch (v.getId()) {
		case R.id.button1: {
			startConnection();
			break;
		}
		case R.id.button2: {
			closeConnection();
			break;
		}
		case R.id.button3: {
			sendHelloAccessory();
			break;
		}
		default:
		}
	}

	private void startConnection() {
		if (mIsBound == true && mConsumerService != null) {
			mTextView.setText("startConnection");

			mConsumerService.findPeers();
		}
	}

	private void closeConnection() {

		if (mIsBound == true && mConsumerService != null) {
			mTextView.setText("closeConnection");

			mConsumerService.closeConnection();
		}
	}

	private void sendHelloAccessory() {
		if (mIsBound == true && mConsumerService != null) {
			mTextView.setText("sending HelloGear!");

			mConsumerService.sendHelloAccessory();
		}
	}

	BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver() {
		@Override
		public void onReceive(Context context, Intent intent) {
			String action = intent.getAction();

			if (SAP_ACTION_ATTACHED.equals(action)) {

				doBindService();
			} else if (SAP_ACTION_DETACHED.equals(action)) {

				closeConnection();

				doUnbindService();
			}
		}
	};

	private final ServiceConnection mConnection = new ServiceConnection() {
		@Override
		public void onServiceConnected(ComponentName className, IBinder service) {

			mConsumerService = ((HelloAccessoryConsumerService.LocalBinder) service)
					.getService();

			mConsumerService.findPeers();

			mTextView.setText("onServiceConnected");
		}

		@Override
		public void onServiceDisconnected(ComponentName className) {

			mConsumerService = null;

			mIsBound = false;

			mTextView.setText("onServiceDisconnected");
		}
	};
}