/*    
 * Copyright (c) 2014 Samsung Electronics Co., Ltd.   
 * All rights reserved.   
 *   
 * Redistribution and use in source and binary forms, with or without   
 * modification, are permitted provided that the following conditions are   
 * met:   
 *   
 *     * Redistributions of source code must retain the above copyright   
 *        notice, this list of conditions and the following disclaimer.  
 *     * Redistributions in binary form must reproduce the above  
 *       copyright notice, this list of conditions and the following disclaimer  
 *       in the documentation and/or other materials provided with the  
 *       distribution.  
 *     * Neither the name of Samsung Electronics Co., Ltd. nor the names of its  
 *       contributors may be used to endorse or promote products derived from  
 *       this software without specific prior written permission.  
 *  
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS  
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT  
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR  
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,  
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT  
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,  
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY  
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT  
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE  
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 
package com.samsung.android.example.helloaccessoryconsumer.service;

import java.io.IOException;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.widget.Toast;

import com.samsung.android.example.helloaccessoryconsumer.R;
import com.samsung.android.example.helloaccessoryconsumer.ui.HelloAccessoryActivity;
import com.samsung.android.sdk.SsdkUnsupportedException;
import com.samsung.android.sdk.accessory.SA;
import com.samsung.android.sdk.accessory.SAAgent;
import com.samsung.android.sdk.accessory.SAPeerAgent;
import com.samsung.android.sdk.accessory.SASocket;

public class HelloAccessoryConsumerService extends SAAgent {

	public static final int HELLOACCESSORY_CHANNEL_ID = 104;

	@Override
	protected void onError(SAPeerAgent peerAgent, String errorMessage, int errorCode) {
		super.onError(peerAgent, errorMessage, errorCode);
	}

	private final IBinder mBinder = new LocalBinder();

	Handler mHandler = new Handler();

	public HelloAccessoryConsumerService() {
		super("HelloAccessoryConsumerService", HelloAccessoryConsumerConnection.class);
	}

	public class LocalBinder extends Binder {
		public HelloAccessoryConsumerService getService() {
			return HelloAccessoryConsumerService.this;
		}
	}

	private SASocket mConnectionHandler;

	public class HelloAccessoryConsumerConnection extends SASocket {
		public HelloAccessoryConsumerConnection() {
			super(HelloAccessoryConsumerConnection.class.getName());
		}

		@Override
		public void onError(int channelId, String errorMessage, int errorCode) {
		}

		@Override
		public void onReceive(int channelId, byte[] data) {

			final String strToUpdateUI = new String(data);

			mHandler.post(new Runnable() {
				@Override
				public void run() {
					HelloAccessoryActivity.mTextView.setText(strToUpdateUI);
				}
			});
		}

		@Override
		protected void onServiceConnectionLost(int reason) {
			
			closeConnection();
		}
	}

	public void findPeers() {
		findPeerAgents();
	}

    @Override
    public void onCreate() {
        super.onCreate();
        
        SA mAccessory = new SA();
        try {
        	mAccessory.initialize(this);            
        } catch (SsdkUnsupportedException e) {
        	// Error Handling
        } catch (Exception e1) {
            e1.printStackTrace();
			/*
			 * Your application can not use Accessory package of Samsung Mobile
			 * SDK. You application should work smoothly without using this SDK,
			 * or you may want to notify user and close your app gracefully
			 * (release resources, stop Service threads, close UI thread, etc.)
			 */
            stopSelf();
        }

    }		
    
    @Override 
    protected void onServiceConnectionRequested(SAPeerAgent peerAgent) { 
        acceptServiceConnectionRequest(peerAgent); 
    }     
	
	@Override
	protected void onFindPeerAgentResponse(SAPeerAgent remoteAgent, int result) {

		if (result == PEER_AGENT_FOUND) {
			onPeerFound(remoteAgent);
		}
	}

	@Override
	protected void onServiceConnectionResponse(SAPeerAgent peerAgent, SASocket thisConnection,
			int connResult) {

		if (connResult == CONNECTION_SUCCESS) {

			this.mConnectionHandler = thisConnection;

			Toast.makeText(getBaseContext(), R.string.ConnectionEstablishedMsg,
					Toast.LENGTH_LONG).show();
		} else if (connResult == CONNECTION_ALREADY_EXIST) {

			Toast.makeText(getBaseContext(), R.string.ConnectionAlreadyExist,
					Toast.LENGTH_LONG).show();
		} else {

			Toast.makeText(getBaseContext(), R.string.ConnectionFailure,
					Toast.LENGTH_LONG).show();
		}
	}

	@Override
	public IBinder onBind(Intent intent) {
		
		return mBinder;
	}

	public boolean sendHelloAccessory() {

		boolean retvalue = false;

		String jsonStringToSend = "Hello Accessory!";

		if (mConnectionHandler != null) {
			try {
				mConnectionHandler.send(HELLOACCESSORY_CHANNEL_ID,
						jsonStringToSend.getBytes());

				retvalue = true;
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		return retvalue;
	}

	public void onPeerFound(SAPeerAgent remoteAgent) {

		if (remoteAgent != null) {

			establishConnection(remoteAgent);
		} else {

			Toast.makeText(getApplicationContext(), R.string.NoPeersFound,
					Toast.LENGTH_LONG).show();
		}
	}

	public boolean closeConnection() {
		if (mConnectionHandler != null) {
			mConnectionHandler.close();

			mConnectionHandler = null;
		}

		return true;
	}

	public boolean establishConnection(SAPeerAgent peerAgent) {
		if (peerAgent != null) {

			requestServiceConnection(peerAgent);

			return true;
		}

		return false;
	}
}