package com.hmkcode.android;
 
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import com.hmkcode.android.AboutActivity;
import com.hmkcode.android.MainActivity;
import lecho.lib.hellocharts.view.AbstractChartView;
import lecho.lib.hellocharts.view.LineChartView;
import org.json.JSONArray;
import org.json.JSONObject;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemClickListener;
import android.app.Activity;
import com.hmkcode.android.R;

 
public class MainActivity extends ActionBarActivity {
 
    TextView IsConnected;
    // oAuth2 Client Credentials 
	public static String grantTypeStr = "client_credentials";
	public static String url2Str = "https://api.omniture.com/token";
	public static Intent intents7pageViews;
	public static Intent intents7calledpages;
	public static Intent intents7bounces;
	public static String jsonStringPageViews;
	public static String jsonStringCalledPages;
	public static String jsonStringBounces;
	public static String jsonStringPageViewsAlerts;
	public static String jsonStringCalledPagesAlerts;
	public static String jsonStringBouncesAlerts;
	public static int setColorGT = 0; 
	public static int setColorS7 = 0;
	public static int setColorSG = 0;
	public static String alert1 = "No Alert";
	public static String alert2;
	public static String alert3;


    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
 
        // Get reference to the views
        IsConnected = (TextView) findViewById(R.id.tvIsConnected);
        
        
        // Check if you are connected or not
        if(isConnected()){
        	IsConnected.setBackgroundColor(0xFF00CC00);
        	IsConnected.setText("You are conncted");
        }
        else{
        	IsConnected.setText("You are NOT conncted");
        }
        
        
        try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

        // call AsynTask to perform network operation on separate thread
       new HttpAsyncTaskS7PageViews().execute("www3.omniture.com");
       new HttpAsyncTaskS7CalledPages().execute("www3.omniture.com");
       new HttpAsyncTaskS7Bounces().execute("www3.omniture.com");
       
       new HttpAsyncTaskS7PageViewsAlert().execute("www3.omniture.com");
		
        if (savedInstanceState == null) {
			getSupportFragmentManager().beginTransaction().add(R.id.container, new PlaceholderFragment()).commit();
		}
    }
    
    /**
     * ---------------------------------------------------------------------------------------------------------
	 * Android: Menu
	 */
    
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// If the menu exists, the menue is inflated and the items are added
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// The action bar will automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_about) {
			Intent intent = new Intent(this, AboutActivity.class);
			startActivity(intent);
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
 
    /**
     * ---------------------------------------------------------------------------------------------------------
	 * Android: Layout 
	 */
	
	public static class PlaceholderFragment extends Fragment implements OnItemClickListener {

		private ListView listView;
		private ChartSamplesAdapter adapter;

		public PlaceholderFragment() {
		}

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
			//View and list creation of the main site
			View rootView = inflater.inflate(R.layout.fragment_main, container, false);
			listView = (ListView) rootView.findViewById(android.R.id.list);
			adapter = new ChartSamplesAdapter(getActivity(), 0, generateSamplesDescriptions());
			listView.setAdapter(adapter);
			listView.setOnItemClickListener(this);
			return rootView;
		}

		@Override
		public void onItemClick(AdapterView<?> adapter, View view, int position, long id) {
			Intent intent;

			switch (position) {
			case 0:
				// One Item is added to the list
				// Intent is used to activate another activity: ViewPagerChartsActivitySkill7
				intent = new Intent(getActivity(), ViewPagerChartsActivitySkill7.class);
				startActivity(intent);
				// Other intents are used to transfer data to the next activity: key and value are needed
		    	intents7pageViews = new Intent(getActivity(),ViewPagerChartsActivitySkill7.class );
		    	intents7pageViews.putExtra("s7pageViews", jsonStringPageViews.toString());
		    	intents7pageViews.putExtra("s7calledpages", jsonStringCalledPages.toString());
		    	intents7pageViews.putExtra("s7bounces", jsonStringBounces.toString());
		    	Log.i("Intent Saved", "Intent Saved");
				startActivity(intents7pageViews);
				break;
			default:
				break;
			}
		}
		
		//Creates the list with the image on the right side
		private List<ChartSampleDescription> generateSamplesDescriptions() {
			List<ChartSampleDescription> list = new ArrayList<MainActivity.ChartSampleDescription>();
			list.add(new ChartSampleDescription("Skill7","", ChartType.OTHER));
			return list;
		}
	}

	public static class ChartSamplesAdapter extends ArrayAdapter<ChartSampleDescription> {
		//Prepare charts and lists

		public ChartSamplesAdapter(Context context, int resource, List<ChartSampleDescription> objects) {
			super(context, resource, objects);
		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent) {
			ViewHolder holder;

			if (convertView == null) {
				convertView = View.inflate(getContext(), R.layout.list_item_sample, null);

				holder = new ViewHolder();
				holder.text1 = (TextView) convertView.findViewById(R.id.text1);
				holder.text2 = (TextView) convertView.findViewById(R.id.text2);
				holder.chartLayout = (FrameLayout) convertView.findViewById(R.id.chart_layout);

				convertView.setTag(holder);
			} else {
				holder = (ViewHolder) convertView.getTag();
			}

			ChartSampleDescription item = getItem(position);

			holder.chartLayout.setVisibility(View.VISIBLE);
			holder.chartLayout.removeAllViews();
			AbstractChartView chart;
			switch (item.chartType) {
			case OTHER:
				chart = new LineChartView(getContext());
				holder.chartLayout.addView(chart);
				break;
			default:
				chart = null;
				holder.chartLayout.setVisibility(View.GONE);
				break;
			}

			if (null != chart) {
				chart.setInteractive(false);// Disable touch handling for chart on the ListView.
			}
			holder.text1.setText(item.text1);
			holder.text2.setText(item.text2);

			return convertView;
		}

		private class ViewHolder {

			TextView text1;
			TextView text2;
			FrameLayout chartLayout;
		}

	}
	//Prepare description
	public static class ChartSampleDescription {
		String text1;
		String text2;
		ChartType chartType;

		public ChartSampleDescription(String text1, String text2, ChartType chartType) {
			this.text1 = text1;
			this.text2 = text2;
			this.chartType = chartType;
		}
	}

	public enum ChartType {
		LINE_CHART, COLUMN_CHART, OTHER
	}


 /**
 * ---------------------------------------------------------------------------------------------------------
 * REST: Requests
 * ---------------------------------------------------------------------------------------------------------
 * REST: Requests  S7 Page Views
 */

public static String GETS7PageViews(String url){
    String result = "";
try {
	       
    // Create the string that includes the necessary data with StringBuilder
StringBuilder data = new StringBuilder();
data.append("&client_id=" + applicationIDStr);
data.append("&client_secret=" + clientSecretStr);
data.append("&grant_type=" + grantTypeStr);
URL url2 = new URL(url2Str);  

//Establish connection
HttpsURLConnection con = (HttpsURLConnection) url2.openConnection();
//Add request header
con.setRequestMethod("POST");
//Send post request, not GET
con.setDoOutput(true);
DataOutputStream wr = new DataOutputStream(con.getOutputStream());
wr.writeBytes(data.toString());
wr.flush();
wr.close();

//BufferedReader is used to get the input stream data
BufferedReader in = new BufferedReader(
        new InputStreamReader(con.getInputStream()));
String inputLine;
//Stringbuffer is used to read each line of the response and the result is saved as a string 
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		
		//The response includes the access token for the request
String token = response.toString();

in.close();
//With the accesstoken a new data is made
String resultREST1 = GETReportIDS7PageViews(token);
Thread.sleep(5000); 
String resultREST2 = "NULL";
String strError ="400";
String strError2 ="FileNotFound";
//As long as the result is Null, the request will be sent
while (resultREST2 == "NULL" | resultREST2.toLowerCase().contains(strError) |  resultREST2.toLowerCase().contains(strError2) )
{
	Thread.sleep(1000); 
	resultREST2 = GETReportS7PageViews(token, resultREST1);
}
Log.i("resultREST2", resultREST2);


//result = response.toString();
            result = resultREST2;
 
        } catch (Exception e) {
        	Log.i("MyActivityMain", "Test:" + e.toString());
        }
 
        return result;
    }
    
    public static String GETReportIDS7PageViews(String receivedToken){
    	// This report returns an ID of the report that is processed. After it is finished, the report could be requested with this ID
 String result2 = "";
try {  
	//Create the request
JSONObject json = new JSONObject(receivedToken);
 receivedToken = json.getString("access_token");
 String elementID = "siteSection";
 String reportsuiteID = "---";
 String datef = "2014-12-04";
 String datet = "2014-12-06";
 String granularity = "day";
 String metricID = "pageviews";
 String anomalyDetection = "true";
 String currentData ="true";
 
     String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Queue&access_token=" + receivedToken;
 String json2 = "{" +
 "\"reportDescription\":{" +
     "\"reportSuiteID\":\"" + reportsuiteID + "\"," +
     "\"dateFrom\":\"" + datef + "\"," +
     "\"dateTo\":\"" + datet + "\"," +
    "\"anomalyDetection\":\"" + anomalyDetection + "\"," + 
    "\"currentData\":\"" + currentData + "\"," + 
     "\"dateGranularity\":\"" + granularity + "\"," +
     "\"metrics\":[" +
                 "{" +
                     "\"id\":\"" + metricID + "\"" +
                 "}]," +
     "\"elements\":[" +
                 "{" +
                 "\"id\":\"" + elementID + "\"" +
                 "}]" +
      "}" +
 "}";
	
	
   
    
    	URL urlElements = new URL(urlGetElements);  
    	
		HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
		con2.setDoOutput(true);
		con2.setRequestMethod("POST");
con2.setRequestProperty("Content-Type", "application/json");

// Send post request
    		OutputStream wr2 = con2.getOutputStream();
    		wr2.write(json2.getBytes());
    		wr2.flush();
    		
    		BufferedReader in = new BufferedReader(
    		        new InputStreamReader(con2.getInputStream()));
    		
    		String inputLine;
    		StringBuffer response = new StringBuffer();
     
    		while ((inputLine = in.readLine()) != null) {
    			response.append(inputLine);
    		}
    		in.close();
            
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 1", "Test:" + e.toString());
        }
		return result2;
 
}
    
    public static String GETReportS7PageViews(String receivedTokenJSON, String reportIDJSON){
    	//It is responsible to use the report ID to get the report data from Adobe Analytics
 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedTokenJSON);
String receivedToken = json.getString("access_token");
 JSONObject jsonReportID = new JSONObject(reportIDJSON);
 String reportID = jsonReportID.getString("reportID");
 Log.i("MyActivity", "reportID:" + reportID);
 
 String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Get&access_token=" + receivedToken;
 String json2  = "{" +
 "\"reportID\":\"" + reportID + "\"" +
 "}";

URL urlElements = new URL(urlGetElements);  

HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
con2.setDoOutput(true);
con2.setRequestMethod("POST");
con2.setRequestProperty("Content-Type", "application/json");

// Send post request
	OutputStream wr2 = con2.getOutputStream();
	wr2.write(json2.getBytes());
	wr2.flush();
	
   // if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
   //     throw new RuntimeException("Failed : HTTP error code : "
   //         + con2.getResponseCode());
   // }
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
Log.i("REST Report Call 2", "ResponseCode:" + con2.getResponseCode());
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 2", "Error" + e.toString());
			       	result2 = e.toString();
			        }
					return result2;
			 
			}
			  
   
    /**
 * ---------------------------------------------------------------------------------------------------------
 * REST: Requests  S7 Number of called pages
 */

public static String GETS7CalledPages(String url){
    String result = "";
try {
	       
    // Create the data to send
StringBuilder data = new StringBuilder();
data.append("&client_id=" + applicationIDStr);
data.append("&client_secret=" + clientSecretStr);
data.append("&grant_type=" + grantTypeStr);
URL url2 = new URL(url2Str);  

HttpsURLConnection con = (HttpsURLConnection) url2.openConnection();
//add request header
con.setRequestMethod("POST");
// Send post request
		con.setDoOutput(true);
		DataOutputStream wr = new DataOutputStream(con.getOutputStream());
		wr.writeBytes(data.toString());
		wr.flush();
		wr.close();

		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con.getInputStream()));
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		
		String token = response.toString();
		
		in.close();
		String resultREST1 = GETReportIDS7CalledPages(token);
		Thread.sleep(5000); 
		String resultREST2 = "NULL";
String strError ="400";
String strError2 ="FileNotFound";
while (resultREST2 == "NULL" | resultREST2.toLowerCase().contains(strError) |  resultREST2.toLowerCase().contains(strError2) )
{
	Thread.sleep(1000); 
	resultREST2 = GETReportS7CalledPages(token, resultREST1);
}
Log.i("resultREST2", resultREST2);


//result = response.toString();
            result = resultREST2;
 
        } catch (Exception e) {
        	Log.i("MyActivityMain", "Test:" + e.toString());
        }
 
        return result;
    }
    
    public static String GETReportIDS7CalledPages(String receivedToken){
    	 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedToken);
 receivedToken = json.getString("access_token");
 String elementID = "siteSection";
 String reportsuiteID = "---";
 String datef = "2014-12-04";
 String datet = "2014-12-06";
 String granularity = "day";
 String metricID = "entries";
 String anomalyDetection = "true";
 String currentData ="true";
 
     String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Queue&access_token=" + receivedToken;
 String json2 = "{" +
 "\"reportDescription\":{" +
     "\"reportSuiteID\":\"" + reportsuiteID + "\"," +
     "\"dateFrom\":\"" + datef + "\"," +
     "\"dateTo\":\"" + datet + "\"," +
    "\"anomalyDetection\":\"" + anomalyDetection + "\"," + 
    "\"currentData\":\"" + currentData + "\"," + 
     "\"dateGranularity\":\"" + granularity + "\"," +
     "\"metrics\":[" +
                 "{" +
                     "\"id\":\"" + metricID + "\"" +
                 "}]," +
     "\"elements\":[" +
                 "{" +
                 "\"id\":\"" + elementID + "\"" +
                 "}]" +
      "}" +
 "}";
	
	
   
    
    	URL urlElements = new URL(urlGetElements);  
    	
		HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
		con2.setDoOutput(true);
		con2.setRequestMethod("POST");
con2.setRequestProperty("Content-Type", "application/json");

// Send post request
OutputStream wr2 = con2.getOutputStream();
wr2.write(json2.getBytes());
wr2.flush();

//if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
//    throw new RuntimeException("Failed : HTTP error code : "
//        + con2.getResponseCode());
//}
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
            
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 1", "Test:" + e.toString());
        }
		return result2;
 
}
    
    public static String GETReportS7CalledPages(String receivedTokenJSON, String reportIDJSON){
    	 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedTokenJSON);
String receivedToken = json.getString("access_token");
 JSONObject jsonReportID = new JSONObject(reportIDJSON);
 String reportID = jsonReportID.getString("reportID");
 Log.i("MyActivity", "reportID:" + reportID);
 
 String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Get&access_token=" + receivedToken;
 String json2  = "{" +
 "\"reportID\":\"" + reportID + "\"" +
 "}";

URL urlElements = new URL(urlGetElements);  

HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
con2.setDoOutput(true);
con2.setRequestMethod("POST");
con2.setRequestProperty("Content-Type", "application/json");

// Send post request
		OutputStream wr2 = con2.getOutputStream();
		wr2.write(json2.getBytes());
		wr2.flush();
		
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
Log.i("REST Report Call 2", "ResponseCode:" + con2.getResponseCode());
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 2", "Error" + e.toString());
       	result2 = e.toString();
        }
		return result2;
 
}
  
/**
 * ---------------------------------------------------------------------------------------------------------
 * REST: Requests  S7 Bounces
 */

public static String GETS7Bounces(String url){
    String result = "";
try {
	       
    // Create the data to send
StringBuilder data = new StringBuilder();
data.append("&client_id=" + applicationIDStr);
data.append("&client_secret=" + clientSecretStr);
data.append("&grant_type=" + grantTypeStr);
URL url2 = new URL(url2Str);  

HttpsURLConnection con = (HttpsURLConnection) url2.openConnection();
//add request header
con.setRequestMethod("POST");
// Send post request
		con.setDoOutput(true);
		DataOutputStream wr = new DataOutputStream(con.getOutputStream());
		wr.writeBytes(data.toString());
		wr.flush();
		wr.close();

		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con.getInputStream()));
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		
		String token = response.toString();
		
		in.close();
		String resultREST1 = GETReportIDS7Bounces(token);
		Thread.sleep(5000); 
		String resultREST2 = "NULL";
String strError ="400";
String strError2 ="FileNotFound";
while (resultREST2 == "NULL" | resultREST2.toLowerCase().contains(strError) |  resultREST2.toLowerCase().contains(strError2) )
{
	Thread.sleep(1000); 
	resultREST2 = GETReportS7Bounces(token, resultREST1);
}
Log.i("resultREST2", resultREST2);


//result = response.toString();
            result = resultREST2;
 
        } catch (Exception e) {
        	Log.i("MyActivityMain", "Test:" + e.toString());
        }
 
        return result;
    }
    
    public static String GETReportIDS7Bounces(String receivedToken){
    	 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedToken);
 receivedToken = json.getString("access_token");
 String elementID = "siteSection";
 String reportsuiteID = "---";
 String datef = "2014-12-04";
 String datet = "2014-12-06";
 String granularity = "day";
 String metricID = "bounces";
 String anomalyDetection = "true";
 String currentData ="true";
 
     String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Queue&access_token=" + receivedToken;
 String json2 = "{" +
 "\"reportDescription\":{" +
     "\"reportSuiteID\":\"" + reportsuiteID + "\"," +
     "\"dateFrom\":\"" + datef + "\"," +
     "\"dateTo\":\"" + datet + "\"," +
    "\"anomalyDetection\":\"" + anomalyDetection + "\"," + 
    "\"currentData\":\"" + currentData + "\"," + 
     "\"dateGranularity\":\"" + granularity + "\"," +
     "\"metrics\":[" +
                 "{" +
                     "\"id\":\"" + metricID + "\"" +
                 "}]," +
     "\"elements\":[" +
                 "{" +
                 "\"id\":\"" + elementID + "\"" +
                 "}]" +
      "}" +
 "}";
	
	
   
    
    	URL urlElements = new URL(urlGetElements);  
    	
		HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
		con2.setDoOutput(true);
		con2.setRequestMethod("POST");
con2.setRequestProperty("Content-Type", "application/json");

// Send post request
OutputStream wr2 = con2.getOutputStream();
wr2.write(json2.getBytes());
wr2.flush();

//if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
//    throw new RuntimeException("Failed : HTTP error code : "
//        + con2.getResponseCode());
//}
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
            
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 1", "Test:" + e.toString());
        }
		return result2;
 
}
    
    public static String GETReportS7Bounces(String receivedTokenJSON, String reportIDJSON){
			    	 String result2 = "";
	try {  
	JSONObject json = new JSONObject(receivedTokenJSON);
	String receivedToken = json.getString("access_token");
	 JSONObject jsonReportID = new JSONObject(reportIDJSON);
	 String reportID = jsonReportID.getString("reportID");
	 Log.i("MyActivity", "reportID:" + reportID);
	 
     String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Get&access_token=" + receivedToken;
     String json2  = "{" +
             "\"reportID\":\"" + reportID + "\"" +
         "}";
    
    	URL urlElements = new URL(urlGetElements);  
    	
		HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
		con2.setDoOutput(true);
		con2.setRequestMethod("POST");
		con2.setRequestProperty("Content-Type", "application/json");

		// Send post request
		OutputStream wr2 = con2.getOutputStream();
		wr2.write(json2.getBytes());
		wr2.flush();
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
		Log.i("REST Report Call 2", "ResponseCode:" + con2.getResponseCode());
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 2", "Error" + e.toString());
						       	result2 = e.toString();
						        }
								return result2;
						 
						}
						
   
    /**
 * ---------------------------------------------------------------------------------------------------------
 * REST: HttpAsyncTask
 */


public class HttpAsyncTaskS7PageViews extends AsyncTask<String, Void, String> {
	//AsyncTasc is used to exclude tasks into a Background Thread to open the UI Thread
@Override
protected String doInBackground(String... urls) {
	//Every task inside the doInBackground method is excecuted in the Background Thread!
//Attention! No access to these variables during execution from the UI Thread.
    return GETS7PageViews(urls[0]);
}
// onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String resultpageviews) {
	//After the background task, the data is usable in the UI Thread again
//The Toast shows that the data is received by the App
 Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
 try {
 
	 jsonStringPageViews = resultpageviews;

	   	 
 } catch (Exception e) {
	 Log.i("MyActivity", "Test:" + e.toString());
        	 }
          }
        }
    
    public class HttpAsyncTaskS7CalledPages extends AsyncTask<String, Void, String> {
        @Override
        protected String doInBackground(String... urls) {
 
            return GETS7CalledPages(urls[0]);
        }
        // onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String resultcalledpages) {
	         	 Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
 try {
 
	 jsonStringCalledPages = resultcalledpages;


	   	 
 } catch (Exception e) {
	 Log.i("MyActivity", "Test:" + e.toString());
        	 }
          }
        }
    
    public class HttpAsyncTaskS7Bounces extends AsyncTask<String, Void, String> {
        @Override
        protected String doInBackground(String... urls) {
 
            return GETS7Bounces(urls[0]);
        }
        // onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String resultbounces) {
	         	 Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
 try {
 
	 jsonStringBounces = resultbounces;

	   	 
 } catch (Exception e) {
	 Log.i("MyActivity", "Test:" + e.toString());
        	 }
          }
        }
    

   

    			
    			
    			
    /**
 * ---------------------------------------------------------------------------------------------------------
 * REST: Diverse Methods
 */

//Show connection status
//Source= http://www.programcreek.com/java-api-examples/index.php?api=android.net.ConnectivityManager
public boolean isConnected(){
	//Used for the connection status of the service and handles the green isConnected item on the main page
    ConnectivityManager connMgr = (ConnectivityManager) getSystemService(Activity.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected())
            return true;
        else
            return false;  
}

//Get date of the day before to let the query process on the day before
//Source= http://stackoverflow.com/questions/11425236/get-yesterdays-date-using-date
private static String getYesterdayDateString() {
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, -1);    
        return dateFormat.format(cal.getTime());
}
    
    /**
 * ---------------------------------------------------------------------------------------------------------
 * Alerts: Set Timer [http://nerdwin15.com/2013/04/android-creating-an-alarm-with-alarmmanager/?redirect]
 	 * REST: Requests  S7 Page Views
 */


    public class HttpAsyncTaskS7PageViewsAlert extends AsyncTask<String, Void, String> {
        @Override
        protected String doInBackground(String... urls) {
 
            return GETS7PageViewsAlert(urls[0]);
        }
        // onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String resultpageviewsAlert) {
	         	 Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
	 try {
	 
		 //Define the result as JSON object				
    	 JSONObject outerObject = new JSONObject(resultpageviewsAlert);
    	 //Get access to the various itemss
    	 JSONObject innerObject = outerObject.getJSONObject("report");
    	 JSONArray jsonArray = innerObject.getJSONArray("data");
    	 float[] dataCounts = new float[jsonArray.length()];
    	 float[] dataUpperBounds = new float[jsonArray.length()];
    	 float[] dataLowerBounds = new float[jsonArray.length()];
    	 float[] dataForecasts = new float[jsonArray.length()];
    	 String[] dataDay = new String[jsonArray.length()];
    	 int countsFinal = 0;
    	 int upperBoundsFinal= 0;
    	 int lowerBoundsFinal= 0;
    	 int forecastsFinal= 0;
    	 
    	 //Retrieve the necessary information for the alerts
    	 for (int i = 0, size = jsonArray.length(); i < size; i++) {
    		 
    		 JSONObject first = jsonArray.getJSONObject(i);
    		 String name = first.getString("name");
    		 dataDay[i] = name;
    		 //daySelected = daySelected + ", " + name;
    		 
    	     JSONArray breakdownArray = first.getJSONArray("breakdown");
    	     JSONObject firstBreakdown = breakdownArray.getJSONObject(0);
    	     
    	     JSONArray countArray = firstBreakdown.getJSONArray("counts");
    	     String counts = countArray.getString(0);
    	     dataCounts[i] = Float.valueOf(counts);
    	     
    	     JSONArray upperBoundsArray = firstBreakdown.getJSONArray("upperBounds");
    	     String upperBounds = upperBoundsArray.getString(0);
    	     dataUpperBounds[i] = Float.valueOf(upperBounds);
    	     
    	     JSONArray lowerBoundsArray = firstBreakdown.getJSONArray("lowerBounds");
    	     String lowerBounds = lowerBoundsArray.getString(0);
    	     dataLowerBounds[i] = Float.valueOf(lowerBounds);
    	     
    	     JSONArray forecastsArray = firstBreakdown.getJSONArray("forecasts");
    	     String forecasts = forecastsArray.getString(0);
    	     dataForecasts[i] = Float.valueOf(forecasts);
    	     
    	    ///daySelected = daySelected + "!! " + counts;
    	   }
    	 
			for (int j = 0; j < dataUpperBounds.length; j++) {
				switch (j) {
				case 0: upperBoundsFinal = (int)(Math.round(dataUpperBounds[j])); break;
				case 1: countsFinal = (int)(Math.round(dataCounts[j])); break;
				case 2: lowerBoundsFinal = (int)(Math.round(dataLowerBounds[j])); break;
				case 3: forecastsFinal = (int)(Math.round(dataForecasts[j])); break;
				}
				
			}
			int alertvalue=0;
			//Check if the retrieved values are correct
			Log.i("countsFinal", String.valueOf(countsFinal));
			Log.i("upperBoundsFinal", String.valueOf(upperBoundsFinal));
			Log.i("lowerBoundsFinal", String.valueOf(lowerBoundsFinal));
			Log.i("forecastsFinal", String.valueOf(forecastsFinal));
			
			//Conditions when the alert should be sent
			if(countsFinal > upperBoundsFinal) {
				alertvalue = countsFinal - upperBoundsFinal;
				alert1 = "Alert: +" + alertvalue;
				Log.i("Alert High", String.valueOf(alertvalue));
			}
			if(countsFinal < lowerBoundsFinal) {
				alertvalue = lowerBoundsFinal - countsFinal;
				alert1 = "Alert: -" + alertvalue;
				Log.i("Alert Low", String.valueOf(alertvalue));
			}
			else
			{
				Log.i("Alert Notactivated", String.valueOf(alertvalue));
			}
			
			
			Toast.makeText(getBaseContext(), alert1, Toast.LENGTH_SHORT).show();

				Intent intent = new Intent("myData");
				intent.putExtra("data", "Hello Gear!");
				sendBroadcast(intent);
    	 
    	   	 
	 } catch (Exception e) {
    	 // TODO Auto-generated catch block
		 Log.i("MyActivity", "Test:" + e.toString());
        	 }
          }
        }
    
    public class HttpAsyncTaskS7CalledPagesAlert extends AsyncTask<String, Void, String> {
        @Override
        protected String doInBackground(String... urls) {
 
            return GETS7CalledPagesAlert(urls[0]);
        }
        // onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String resultcalledpagesAlert) {
	         	 Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
	 try {
	 
		 //jsonStringCalledPagesAlerts = resultcalledpages;
		 JSONObject outerObject = new JSONObject(resultcalledpagesAlert);
    	 JSONObject innerObject = outerObject.getJSONObject("report");
    	 JSONArray jsonArray = innerObject.getJSONArray("data");
    	 float[] dataCounts = new float[jsonArray.length()];
    	 float[] dataUpperBounds = new float[jsonArray.length()];
    	 float[] dataLowerBounds = new float[jsonArray.length()];
    	 float[] dataForecasts = new float[jsonArray.length()];
    	 String[] dataDay = new String[jsonArray.length()];
    	 
    	 for (int i = 0, size = jsonArray.length(); i < size; i++) {
    		 
    		 JSONObject first = jsonArray.getJSONObject(i);
    		 String name = first.getString("name");
    		 dataDay[i] = name;
    		 //daySelected = daySelected + ", " + name;
    		 
    	     JSONArray breakdownArray = first.getJSONArray("breakdown");
    	     JSONObject firstBreakdown = breakdownArray.getJSONObject(0);
    	     
    	     JSONArray countArray = firstBreakdown.getJSONArray("counts");
    	     String counts = countArray.getString(0);
    	     dataCounts[i] = Float.valueOf(counts);
    	     
    	     JSONArray upperBoundsArray = firstBreakdown.getJSONArray("upperBounds");
    	     String upperBounds = upperBoundsArray.getString(0);
    	     dataUpperBounds[i] = Float.valueOf(upperBounds);
    	     
    	     JSONArray lowerBoundsArray = firstBreakdown.getJSONArray("lowerBounds");
    	     String lowerBounds = lowerBoundsArray.getString(0);
    	     dataLowerBounds[i] = Float.valueOf(lowerBounds);
    	     
    	     JSONArray forecastsArray = firstBreakdown.getJSONArray("forecasts");
    	     String forecasts = forecastsArray.getString(0);
    	     dataForecasts[i] = Float.valueOf(forecasts);

    	 }   	 
	 } catch (Exception e) {
    	 // TODO Auto-generated catch block
		 Log.i("MyActivity", "Test:" + e.toString());
        	 }
          }
        }
    
    public class HttpAsyncTaskS7BouncesAlert extends AsyncTask<String, Void, String> {
        @Override
        protected String doInBackground(String... urls) {
 
            return GETS7BouncesAlert(urls[0]);
        }
        // onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String resultbouncesAlert) {
	         	 Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
	 try {
	 
		 //jsonStringBouncesAlerts = resultbounces;
		 
		 JSONObject outerObject = new JSONObject(resultbouncesAlert);
    	 JSONObject innerObject = outerObject.getJSONObject("report");
    	 JSONArray jsonArray = innerObject.getJSONArray("data");
    	 float[] dataCounts = new float[jsonArray.length()];
    	 float[] dataUpperBounds = new float[jsonArray.length()];
    	 float[] dataLowerBounds = new float[jsonArray.length()];
    	 float[] dataForecasts = new float[jsonArray.length()];
    	 String[] dataDay = new String[jsonArray.length()];
    	 
    	 for (int i = 0, size = jsonArray.length(); i < size; i++) {
    		 
    		 JSONObject first = jsonArray.getJSONObject(i);
    		 String name = first.getString("name");
    		 dataDay[i] = name;
    		 //daySelected = daySelected + ", " + name;
    		 
    	     JSONArray breakdownArray = first.getJSONArray("breakdown");
    	     JSONObject firstBreakdown = breakdownArray.getJSONObject(0);
    	     
    	     JSONArray countArray = firstBreakdown.getJSONArray("counts");
    	     String counts = countArray.getString(0);
    	     dataCounts[i] = Float.valueOf(counts);
    	     
    	     JSONArray upperBoundsArray = firstBreakdown.getJSONArray("upperBounds");
    	     String upperBounds = upperBoundsArray.getString(0);
    	     dataUpperBounds[i] = Float.valueOf(upperBounds);
    	     
    	     JSONArray lowerBoundsArray = firstBreakdown.getJSONArray("lowerBounds");
    	     String lowerBounds = lowerBoundsArray.getString(0);
    	     dataLowerBounds[i] = Float.valueOf(lowerBounds);
    	     
    	     JSONArray forecastsArray = firstBreakdown.getJSONArray("forecasts");
    	     String forecasts = forecastsArray.getString(0);
    	     dataForecasts[i] = Float.valueOf(forecasts);

    	 }   	 
    	   	 
	 } catch (Exception e) {
    	 // TODO Auto-generated catch block
		 Log.i("MyActivity", "Test:" + e.toString());
    	 }
      }
    }




public static String GETS7PageViewsAlert(String url){
    String result = "";
try {
	       
    // Create the data to send
    StringBuilder data = new StringBuilder();
    data.append("&client_id=" + applicationIDStr);
    data.append("&client_secret=" + clientSecretStr);
    data.append("&grant_type=" + grantTypeStr);
	URL url2 = new URL(url2Str);  
	
    HttpsURLConnection con = (HttpsURLConnection) url2.openConnection();
	//add request header
	con.setRequestMethod("POST");
	// Send post request
		con.setDoOutput(true);
		DataOutputStream wr = new DataOutputStream(con.getOutputStream());
		wr.writeBytes(data.toString());
		wr.flush();
		wr.close();

		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con.getInputStream()));
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		
		String token = response.toString();
		
		in.close();
		String resultREST1 = GETReportIDS7PageViewsAlert(token);
		Thread.sleep(5000); 
		String resultREST2 = "NULL";
	String strError ="400";
	String strError2 ="FileNotFound";
	while (resultREST2 == "NULL" | resultREST2.toLowerCase().contains(strError) |  resultREST2.toLowerCase().contains(strError2) )
	{
		Thread.sleep(1000); 
		resultREST2 = GETReportS7PageViewsAlert(token, resultREST1);
	}
	Log.i("resultREST2", resultREST2);
	
	
	//result = response.toString();
            result = resultREST2;
 
        } catch (Exception e) {
        	Log.i("MyActivityMain", "Test:" + e.toString());
        }
 
        return result;
    }
    
    public static String GETReportIDS7PageViewsAlert(String receivedToken){
    	 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedToken);
 receivedToken = json.getString("access_token");
 String elementID = "siteSection";
 String reportsuiteID = "---";
 String datef = "2014-12-04";
 String datet = "2014-12-06";
 String granularity = "day";
 String metricID = "pageviews";
 String anomalyDetection = "true";
 String currentData ="true";
 
     String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Queue&access_token=" + receivedToken;
 String json2 = "{" +
         "\"reportDescription\":{" +
             "\"reportSuiteID\":\"" + reportsuiteID + "\"," +
             "\"dateFrom\":\"" + datef + "\"," +
             "\"dateTo\":\"" + datet + "\"," +
            "\"anomalyDetection\":\"" + anomalyDetection + "\"," + 
            "\"currentData\":\"" + currentData + "\"," + 
             "\"dateGranularity\":\"" + granularity + "\"," +
             "\"metrics\":[" +
                         "{" +
                             "\"id\":\"" + metricID + "\"" +
                         "}]," +
             "\"elements\":[" +
                         "{" +
                         "\"id\":\"" + elementID + "\"" +
                         "}]" +
              "}" +
     "}";
	
	
   
    
    	URL urlElements = new URL(urlGetElements);  
    	
		HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
		con2.setDoOutput(true);
		con2.setRequestMethod("POST");
	con2.setRequestProperty("Content-Type", "application/json");

	// Send post request
	OutputStream wr2 = con2.getOutputStream();
	wr2.write(json2.getBytes());
	wr2.flush();
	
    //if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
    //    throw new RuntimeException("Failed : HTTP error code : "
    //        + con2.getResponseCode());
    //}
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
            
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 1", "Test:" + e.toString());
        }
		return result2;
 
}
    
    public static String GETReportS7PageViewsAlert(String receivedTokenJSON, String reportIDJSON){
    	 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedTokenJSON);
String receivedToken = json.getString("access_token");
 JSONObject jsonReportID = new JSONObject(reportIDJSON);
 String reportID = jsonReportID.getString("reportID");
 Log.i("MyActivity", "reportID:" + reportID);
 
 String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Get&access_token=" + receivedToken;
 String json2  = "{" +
         "\"reportID\":\"" + reportID + "\"" +
     "}";

	URL urlElements = new URL(urlGetElements);  
	
	HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
	con2.setDoOutput(true);
	con2.setRequestMethod("POST");
	con2.setRequestProperty("Content-Type", "application/json");

	// Send post request
	OutputStream wr2 = con2.getOutputStream();
	wr2.write(json2.getBytes());
	wr2.flush();
	
   // if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
   //     throw new RuntimeException("Failed : HTTP error code : "
   //         + con2.getResponseCode());
   // }
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
	Log.i("REST Report Call 2", "ResponseCode:" + con2.getResponseCode());
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 2", "Error" + e.toString());
			       	result2 = e.toString();
			        }
					return result2;
			 
			}
			  
   
    /**
 * ---------------------------------------------------------------------------------------------------------
 * REST: Requests  S7 Number of called pages
 */

public static String GETS7CalledPagesAlert(String url){
    String result = "";
try {
	       
    // Create the data to send
    StringBuilder data = new StringBuilder();
    data.append("&client_id=" + applicationIDStr);
    data.append("&client_secret=" + clientSecretStr);
    data.append("&grant_type=" + grantTypeStr);
	URL url2 = new URL(url2Str);  
	
    HttpsURLConnection con = (HttpsURLConnection) url2.openConnection();
	//add request header
	con.setRequestMethod("POST");
	// Send post request
		con.setDoOutput(true);
		DataOutputStream wr = new DataOutputStream(con.getOutputStream());
		wr.writeBytes(data.toString());
		wr.flush();
		wr.close();

		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con.getInputStream()));
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		
		String token = response.toString();
		
		in.close();
		String resultREST1 = GETReportIDS7CalledPagesAlert(token);
		Thread.sleep(5000); 
		String resultREST2 = "NULL";
	String strError ="400";
	String strError2 ="FileNotFound";
	while (resultREST2 == "NULL" | resultREST2.toLowerCase().contains(strError) |  resultREST2.toLowerCase().contains(strError2) )
	{
		Thread.sleep(1000); 
		resultREST2 = GETReportS7CalledPagesAlert(token, resultREST1);
	}
	Log.i("resultREST2", resultREST2);
	
	
	//result = response.toString();
            result = resultREST2;
 
        } catch (Exception e) {
        	Log.i("MyActivityMain", "Test:" + e.toString());
        }
 
        return result;
    }
    
    public static String GETReportIDS7CalledPagesAlert(String receivedToken){
    	 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedToken);
 receivedToken = json.getString("access_token");
 String elementID = "siteSection";
 String reportsuiteID = "---";
 String datef = "2014-12-04";
 String datet = "2014-12-06";
 String granularity = "day";
 String metricID = "entries";
 String anomalyDetection = "true";
 String currentData ="true";
 
     String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Queue&access_token=" + receivedToken;
 String json2 = "{" +
         "\"reportDescription\":{" +
             "\"reportSuiteID\":\"" + reportsuiteID + "\"," +
             "\"dateFrom\":\"" + datef + "\"," +
             "\"dateTo\":\"" + datet + "\"," +
            "\"anomalyDetection\":\"" + anomalyDetection + "\"," + 
            "\"currentData\":\"" + currentData + "\"," + 
             "\"dateGranularity\":\"" + granularity + "\"," +
             "\"metrics\":[" +
                         "{" +
                             "\"id\":\"" + metricID + "\"" +
                         "}]," +
             "\"elements\":[" +
                         "{" +
                         "\"id\":\"" + elementID + "\"" +
                         "}]" +
              "}" +
     "}";
	
	
   
    
    	URL urlElements = new URL(urlGetElements);  
    	
		HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
		con2.setDoOutput(true);
		con2.setRequestMethod("POST");
	con2.setRequestProperty("Content-Type", "application/json");

	// Send post request
	OutputStream wr2 = con2.getOutputStream();
	wr2.write(json2.getBytes());
	wr2.flush();
	
    //if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
    //    throw new RuntimeException("Failed : HTTP error code : "
    //        + con2.getResponseCode());
    //}
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
            
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 1", "Test:" + e.toString());
        }
		return result2;
 
}
    
    public static String GETReportS7CalledPagesAlert(String receivedTokenJSON, String reportIDJSON){
    	 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedTokenJSON);
String receivedToken = json.getString("access_token");
 JSONObject jsonReportID = new JSONObject(reportIDJSON);
 String reportID = jsonReportID.getString("reportID");
 Log.i("MyActivity", "reportID:" + reportID);
 
 String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Get&access_token=" + receivedToken;
 String json2  = "{" +
         "\"reportID\":\"" + reportID + "\"" +
     "}";

	URL urlElements = new URL(urlGetElements);  
	
	HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
	con2.setDoOutput(true);
	con2.setRequestMethod("POST");
	con2.setRequestProperty("Content-Type", "application/json");

	// Send post request
	OutputStream wr2 = con2.getOutputStream();
	wr2.write(json2.getBytes());
	wr2.flush();
	
   // if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
   //     throw new RuntimeException("Failed : HTTP error code : "
   //         + con2.getResponseCode());
   // }
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
	Log.i("REST Report Call 2", "ResponseCode:" + con2.getResponseCode());
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 2", "Error" + e.toString());
       	result2 = e.toString();
        }
		return result2;
 
}
  
/**
 * ---------------------------------------------------------------------------------------------------------
 * REST: Requests  S7 Bounces
 */

public static String GETS7BouncesAlert(String url){
    String result = "";
try {
	       
    // Create the data to send
    StringBuilder data = new StringBuilder();
    data.append("&client_id=" + applicationIDStr);
    data.append("&client_secret=" + clientSecretStr);
    data.append("&grant_type=" + grantTypeStr);
	URL url2 = new URL(url2Str);  
	
    HttpsURLConnection con = (HttpsURLConnection) url2.openConnection();
	//add request header
	con.setRequestMethod("POST");
	// Send post request
		con.setDoOutput(true);
		DataOutputStream wr = new DataOutputStream(con.getOutputStream());
		wr.writeBytes(data.toString());
		wr.flush();
		wr.close();

		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con.getInputStream()));
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		
		String token = response.toString();
		
		in.close();
		String resultREST1 = GETReportIDS7BouncesAlert(token);
		Thread.sleep(5000); 
		String resultREST2 = "NULL";
	String strError ="400";
	String strError2 ="FileNotFound";
	while (resultREST2 == "NULL" | resultREST2.toLowerCase().contains(strError) |  resultREST2.toLowerCase().contains(strError2) )
	{
		Thread.sleep(1000); 
		resultREST2 = GETReportS7BouncesAlert(token, resultREST1);
	}
	Log.i("resultREST2", resultREST2);
	
	
	//result = response.toString();
            result = resultREST2;
 
        } catch (Exception e) {
        	Log.i("MyActivityMain", "Test:" + e.toString());
        }
 
        return result;
    }
    
    public static String GETReportIDS7BouncesAlert(String receivedToken){
    	 String result2 = "";
try {  
JSONObject json = new JSONObject(receivedToken);
 receivedToken = json.getString("access_token");
 String elementID = "siteSection";
 String reportsuiteID = "---";
 String datef = "2014-12-04";
 String datet = "2014-12-06";
 String granularity = "day";
 String metricID = "bounces";
 String anomalyDetection = "true";
 String currentData ="true";
 
     String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Queue&access_token=" + receivedToken;
 String json2 = "{" +
         "\"reportDescription\":{" +
             "\"reportSuiteID\":\"" + reportsuiteID + "\"," +
             "\"dateFrom\":\"" + datef + "\"," +
             "\"dateTo\":\"" + datet + "\"," +
            "\"anomalyDetection\":\"" + anomalyDetection + "\"," + 
            "\"currentData\":\"" + currentData + "\"," + 
             "\"dateGranularity\":\"" + granularity + "\"," +
             "\"metrics\":[" +
                         "{" +
                             "\"id\":\"" + metricID + "\"" +
                         "}]," +
             "\"elements\":[" +
                         "{" +
                         "\"id\":\"" + elementID + "\"" +
                         "}]" +
              "}" +
     "}";
	
	
   
    
    	URL urlElements = new URL(urlGetElements);  
    	
		HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
		con2.setDoOutput(true);
		con2.setRequestMethod("POST");
	con2.setRequestProperty("Content-Type", "application/json");

	// Send post request
	OutputStream wr2 = con2.getOutputStream();
	wr2.write(json2.getBytes());
	wr2.flush();
	
    //if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
    //    throw new RuntimeException("Failed : HTTP error code : "
    //        + con2.getResponseCode());
    //}
		
		BufferedReader in = new BufferedReader(
		        new InputStreamReader(con2.getInputStream()));
		
		String inputLine;
		StringBuffer response = new StringBuffer();
 
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();
		//print result
            
    		result2 = response.toString();      	  
 
        } catch (Exception e) {
       	 Log.i("REST Report Call 1", "Test:" + e.toString());
        }
		return result2;
 
}
    
    public static String GETReportS7BouncesAlert(String receivedTokenJSON, String reportIDJSON){
			    	 String result2 = "";
	    	try {  
	    	JSONObject json = new JSONObject(receivedTokenJSON);
			String receivedToken = json.getString("access_token");
			 JSONObject jsonReportID = new JSONObject(reportIDJSON);
			 String reportID = jsonReportID.getString("reportID");
			 Log.i("MyActivity", "reportID:" + reportID);
			 
	         String urlGetElements = "https://api.omniture.com/admin/1.4/rest/?method=Report.Get&access_token=" + receivedToken;
	         String json2  = "{" +
	                 "\"reportID\":\"" + reportID + "\"" +
	             "}";
	        
	        	URL urlElements = new URL(urlGetElements);  
	        	
	    		HttpsURLConnection con2 = (HttpsURLConnection) urlElements.openConnection();
	    		con2.setDoOutput(true);
	    		con2.setRequestMethod("POST");
	    		con2.setRequestProperty("Content-Type", "application/json");
	
	    		// Send post request
	    		OutputStream wr2 = con2.getOutputStream();
	    		wr2.write(json2.getBytes());
	    		wr2.flush();
	    		
	           // if (con2.getResponseCode() != HttpURLConnection.HTTP_CREATED) {
	           //     throw new RuntimeException("Failed : HTTP error code : "
	           //         + con2.getResponseCode());
	           // }
	    		
	    		BufferedReader in = new BufferedReader(
	    		        new InputStreamReader(con2.getInputStream()));
	    		
	    		String inputLine;
	    		StringBuffer response = new StringBuffer();
	     
	    		while ((inputLine = in.readLine()) != null) {
	    			response.append(inputLine);
	    		}
	    		in.close();
	    		//print result
	    		Log.i("REST Report Call 2", "ResponseCode:" + con2.getResponseCode());
	    		result2 = response.toString();      	  
	 
	        } catch (Exception e) {
	       	 Log.i("REST Report Call 2", "Error" + e.toString());
								       	result2 = e.toString();
								        }
										return result2;
								 
								}
						


					    

					    
					    
 }