package com.hmkcode.android;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import lecho.lib.hellocharts.gesture.ContainerScrollType;
import lecho.lib.hellocharts.gesture.ZoomType;
import lecho.lib.hellocharts.model.Axis;
import lecho.lib.hellocharts.model.Line;
import lecho.lib.hellocharts.model.LineChartData;
import lecho.lib.hellocharts.model.PointValue;
import lecho.lib.hellocharts.model.ValueShape;
import lecho.lib.hellocharts.model.Viewport;
import lecho.lib.hellocharts.util.Utils;
import lecho.lib.hellocharts.view.LineChartView;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class ViewPagerChartsActivitySkill7 extends ActionBarActivity implements ActionBar.TabListener {

private static LineChartData data;
private static LineChartData datapageviews;
private static LineChartData datapagecalledpages;
private static LineChartData datapagebounces;
private static RelativeLayout layout;
private static int maxNumberOfLines = 4;
private static int numberOfPoints = 12;

static float[][] randomNumbersTabPageViews = new float[maxNumberOfLines][numberOfPoints];
static float[][] randomNumbersTabCalledPages = new float[maxNumberOfLines][numberOfPoints];
static float[][] randomNumbersTabBounces = new float[maxNumberOfLines][numberOfPoints];

private static boolean hasAxes = true;
private static boolean hasAxesNames = true;
private static boolean hasLines = true;
private static boolean hasPoints = true;
private static ValueShape shape = ValueShape.CIRCLE;
private static boolean isFilled = false;
private static boolean hasLabels = true;
private static boolean isCubic = false;
private static boolean hasLabelForSelected = false;
public String filename;
public static String fileOutputPageViews;
public static String fileOutputCalledPages;
public static String fileOutputBounces;

/**
 * The {@link android.support.v4.view.PagerAdapter} that will provide fragments for each of the sections. We use a
 * {@link FragmentPagerAdapter} derivative, which will keep every loaded fragment in memory. If this becomes too
 * memory intensive, it may be best to switch to a {@link android.support.v4.app.FragmentStatePagerAdapter}.
 */
SectionsPagerAdapter mSectionsPagerAdapter;

/**
 * The {@link ViewPager} that will host the section contents.
 */
ViewPager mViewPager;

@Override
protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.activity_view_pager_charts_s7);

	// Set up the action bar.
final ActionBar actionBar = getSupportActionBar();
actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);

// Create the adapter that will return a fragment for each of the three
// primary sections of the activity.
mSectionsPagerAdapter = new SectionsPagerAdapter(getSupportFragmentManager());

// Set up the ViewPager with the sections adapter.
mViewPager = (ViewPager) findViewById(R.id.pager);
mViewPager.setAdapter(mSectionsPagerAdapter);

// When swiping between different sections, select the corresponding
// tab. We can also use ActionBar.Tab#select() to do this if we have
// a reference to the Tab.
mViewPager.setOnPageChangeListener(new ViewPager.SimpleOnPageChangeListener() {
	@Override
	public void onPageSelected(int position) {
		actionBar.setSelectedNavigationItem(position);
	}
});

// For each of the sections in the app, add a tab to the action bar.
for (int i = 0; i < mSectionsPagerAdapter.getCount(); i++) {
	// Create a tab with text corresponding to the page title defined by
// the adapter. Also specify this Activity object, which implements
// the TabListener interface, as the callback (listener) for when
// this tab is selected.
		actionBar.addTab(actionBar.newTab().setText(mSectionsPagerAdapter.getPageTitle(i)).setTabListener(this));
	}
}

@Override
public void onTabSelected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
	// When the given tab is selected, switch to the corresponding page in
// the ViewPager.
	mViewPager.setCurrentItem(tab.getPosition());
}

@Override
public void onTabUnselected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
}

@Override
public void onTabReselected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
}

/**
 * A {@link FragmentPagerAdapter} that returns a fragment corresponding to one of the sections/tabs/pages.
 */
public class SectionsPagerAdapter extends FragmentPagerAdapter {

	public SectionsPagerAdapter(FragmentManager fm) {
		super(fm);
	}

	@Override
	public Fragment getItem(int position) {
		// getItem is called to instantiate the fragment for the given page.
// Return a PlaceholderFragment (defined as a static inner class below).
	return PlaceholderFragment.newInstance(position + 1);
}

@Override
public int getCount() {
	return 3;
}

@Override
public CharSequence getPageTitle(int position) {
	switch (position) {
	case 0:
		return "Page Views"; 
case 1:
	return "Started Games"; 
case 2:
	return "Bounces";
		}
		return null;
	}
}

/**
 * A placeholder fragment containing a simple view.
 */
public static class PlaceholderFragment extends Fragment {
	/**
 * The fragment argument representing the section number for this fragment.
 */
private final static String ARG_SECTION_NUMBER = "section_number";

/**
 * Returns a new instance of this fragment for the given section number.
 */
public static PlaceholderFragment newInstance(int sectionNumber) {
	PlaceholderFragment fragment = new PlaceholderFragment();
	Bundle args = new Bundle();
	args.putInt(ARG_SECTION_NUMBER, sectionNumber);
	fragment.setArguments(args);
	Log.i("newFragment!", "PlaceholderFragment");
	return fragment;
}

public PlaceholderFragment() {
}

@Override
public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
	View rootView = inflater.inflate(R.layout.fragment_view_pager_charts_s7, container, false);
	layout = (RelativeLayout) rootView;
	int sectionNum = getArguments().getInt(ARG_SECTION_NUMBER);
	Log.i("sectionNum", "sectionNum :" + sectionNum);
//Gets the active slide and process the wanted data with the given key for the Intent 
switch (sectionNum) {
case 1:
	fileOutputPageViews = readFromIntentPageViews("s7pageViews");
	break;
case 2:
	fileOutputCalledPages = readFromIntentCalledPages("s7calledpages");
	break;
case 3:
	fileOutputBounces = readFromIntentBounces("s7bounces");
				break;
			}

			return rootView;
		}


 /**
 * ---------------------------------------------------------------------------------------------------------
 * PROCESS DATA: Read Intent
 */

 public String readFromIntentPageViews(String key){		
	 String contentIntentPageViews = "";

 try{
	 //With the key, access to the transferred data is given
	 contentIntentPageViews= getActivity().getIntent().getStringExtra(key);      
	 Log.i("contentIntent", contentIntentPageViews);
	 fileOutputPageViews = contentIntentPageViews;
	 //As the data is now available in JSON Format, the processing could start
	 new HttpAsyncTaskFromFilePageViews().execute("http://www3.omniture.com");
 }
 catch (Exception e)
 {
	 //Catches the exception and displays it in the Console
	 Log.i("ErrorIntent PageViews: ", e.toString());
	 }
	return contentIntentPageViews;
}

 
 public String readFromIntentCalledPages(String key){		
	 String contentIntentCalledPages = "";

 try{
	 contentIntentCalledPages= getActivity().getIntent().getStringExtra(key);      
	 Log.i("contentIntent", contentIntentCalledPages);
	 fileOutputCalledPages = contentIntentCalledPages;
	 new HttpAsyncTaskFromFileCalledPages().execute("http://www3.omniture.com");
 }
 catch (Exception e)
 {
	 Log.i("ErrorIntent Called Pages: ", e.toString());
	 }
	return contentIntentCalledPages;
}
 
 public String readFromIntentBounces(String key){		
	 String contentIntentBounces = "";

 try{
	 contentIntentBounces= getActivity().getIntent().getStringExtra(key);      
	 Log.i("contentIntent", contentIntentBounces);
	 fileOutputBounces = contentIntentBounces;
	 new HttpAsyncTaskFromFileBounces().execute("http://www3.omniture.com");
 }
 catch (Exception e)
 {
	 Log.i("ErrorIntent Bounces: ", e.toString());
	    	 }
			return contentIntentBounces;
	    }
		 
		 
 /**
 * ---------------------------------------------------------------------------------------------------------
 * PROCESS DATA: HTTP Async Tasks
 */
 
		 
	    private class HttpAsyncTaskFromFilePageViews extends AsyncTask<String, Void, String> {
	        @Override
	        protected String doInBackground(String... urls) {
	 
	            return GETPageViews(urls[0]);
	        }
	        // onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String result) {
	         	 //Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
	 try {
    	 JSONObject json = new JSONObject(result);
    	 String showJSON = json.toString();
    	 //String showToken = json.getString("access_token");
    	 
    	 String daySelected = " ";
    	 Log.i("InsideHTTPAsync: ", "InsideHTTPAsync");
    	      
        	 JSONObject outerObject = new JSONObject(result);
        	 JSONObject innerObject = outerObject.getJSONObject("report");
        	 JSONArray jsonArray = innerObject.getJSONArray("data");
        	 float[] dataCounts = new float[jsonArray.length()];
        	 float[] dataUpperBounds = new float[jsonArray.length()];
        	 float[] dataLowerBounds = new float[jsonArray.length()];
        	 float[] dataForecasts = new float[jsonArray.length()];
        	 String[] dataDay = new String[jsonArray.length()];
        	 
        	 for (int i = 0, size = jsonArray.length(); i < size; i++) {
        		 
        		 JSONObject first = jsonArray.getJSONObject(i);
        		 String name = first.getString("name");
        		 dataDay[i] = name;
        		 daySelected = daySelected + ", " + name;
        		 
        	     JSONArray breakdownArray = first.getJSONArray("breakdown");
        	     JSONObject firstBreakdown = breakdownArray.getJSONObject(0);
        	     
        	     JSONArray countArray = firstBreakdown.getJSONArray("counts");
        	     String counts = countArray.getString(0);
        	     dataCounts[i] = Float.valueOf(counts);
        	     
        	     JSONArray upperBoundsArray = firstBreakdown.getJSONArray("upperBounds");
        	     String upperBounds = upperBoundsArray.getString(0);
        	     dataUpperBounds[i] = Float.valueOf(upperBounds);
        	     
        	     JSONArray lowerBoundsArray = firstBreakdown.getJSONArray("lowerBounds");
        	     String lowerBounds = lowerBoundsArray.getString(0);
        	     dataLowerBounds[i] = Float.valueOf(lowerBounds);
        	     
        	     JSONArray forecastsArray = firstBreakdown.getJSONArray("forecasts");
        	     String forecasts = forecastsArray.getString(0);
        	     dataForecasts[i] = Float.valueOf(forecasts);
        	     
        	     daySelected = daySelected + "!! " + counts;
        	   }
        	 //After the data is generated, the values are prepared for the graph
        	 Log.i("AfterresetViewport: ", "AfterresetViewport");
        	 generateValuesPageViews(dataUpperBounds, dataCounts, dataLowerBounds, dataForecasts);
        	 Log.i("AftergenerateValues: ", "AftergenerateValues");
        	 generateDataPageViews();
        	 Log.i("AftergenerateData: ", "AftergenerateData");
        	 
        Log.i("Response", "daySelected:" + daySelected);

    	 //etResponse.setText(daySelected);
    	 
	 } catch (JSONException e) {
    	 // TODO Auto-generated catch block
		 Log.i("MyActivity", "Test:" + e.toString());
        	 }
          }
        }

    private class HttpAsyncTaskFromFileCalledPages extends AsyncTask<String, Void, String> {
        @Override
        protected String doInBackground(String... urls) {
 
            return GETCalledPages(urls[0]);
        }
        // onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String result) {
	         	 //Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
	 try {
    	 JSONObject json = new JSONObject(result);
    	 String showJSON = json.toString();
    	 //String showToken = json.getString("access_token");
    	 
    	 String daySelected = " ";
    	 Log.i("InsideHTTPAsync: ", "InsideHTTPAsync");
    	      
        	 JSONObject outerObject = new JSONObject(result);
        	 JSONObject innerObject = outerObject.getJSONObject("report");
        	 JSONArray jsonArray = innerObject.getJSONArray("data");
        	 float[] dataCounts = new float[jsonArray.length()];
        	 float[] dataUpperBounds = new float[jsonArray.length()];
        	 float[] dataLowerBounds = new float[jsonArray.length()];
        	 float[] dataForecasts = new float[jsonArray.length()];
        	 String[] dataDay = new String[jsonArray.length()];
        	 
        	 for (int i = 0, size = jsonArray.length(); i < size; i++) {
        		 
        		 JSONObject first = jsonArray.getJSONObject(i);
        		 String name = first.getString("name");
        		 dataDay[i] = name;
        		 daySelected = daySelected + ", " + name;
        		 
        	     JSONArray breakdownArray = first.getJSONArray("breakdown");
        	     JSONObject firstBreakdown = breakdownArray.getJSONObject(0);
        	     
        	     JSONArray countArray = firstBreakdown.getJSONArray("counts");
        	     String counts = countArray.getString(0);
        	     dataCounts[i] = Float.valueOf(counts);
        	     
        	     JSONArray upperBoundsArray = firstBreakdown.getJSONArray("upperBounds");
        	     String upperBounds = upperBoundsArray.getString(0);
        	     dataUpperBounds[i] = Float.valueOf(upperBounds);
        	     
        	     JSONArray lowerBoundsArray = firstBreakdown.getJSONArray("lowerBounds");
        	     String lowerBounds = lowerBoundsArray.getString(0);
        	     dataLowerBounds[i] = Float.valueOf(lowerBounds);
        	     
        	     JSONArray forecastsArray = firstBreakdown.getJSONArray("forecasts");
        	     String forecasts = forecastsArray.getString(0);
        	     dataForecasts[i] = Float.valueOf(forecasts);
        	     
        	     daySelected = daySelected + "!! " + counts;
        	   }
        	 Log.i("AfterresetViewport: ", "AfterresetViewport");
        	 generateValuesCalledPages(dataUpperBounds, dataCounts, dataLowerBounds, dataForecasts);
        	 Log.i("AftergenerateValues: ", "AftergenerateValues");
        	 generateDataCalledPages();
        	 Log.i("AftergenerateData: ", "AftergenerateData");

        	 
        Log.i("Response", "daySelected:" + daySelected);

    	 //etResponse.setText(daySelected);
    	 
	 } catch (JSONException e) {
    	 // TODO Auto-generated catch block
		 Log.i("MyActivity", "Test:" + e.toString());
        	 }
          }
        }
    
    private class HttpAsyncTaskFromFileBounces extends AsyncTask<String, Void, String> {
        @Override
        protected String doInBackground(String... urls) {
 
            return GETBounces(urls[0]);
        }
        // onPostExecute displays the results of the AsyncTask.
@Override
protected void onPostExecute(String result) {
	         	 //Toast.makeText(getBaseContext(), "Received!", Toast.LENGTH_LONG).show();
	 try {
    	 JSONObject json = new JSONObject(result);
    	 String showJSON = json.toString();
    	 //String showToken = json.getString("access_token");
    	 
    	 String daySelected = " ";
    	 Log.i("InsideHTTPAsync: ", "InsideHTTPAsync");
    	      
        	 JSONObject outerObject = new JSONObject(result);
        	 JSONObject innerObject = outerObject.getJSONObject("report");
        	 JSONArray jsonArray = innerObject.getJSONArray("data");
        	 float[] dataCounts = new float[jsonArray.length()];
        	 float[] dataUpperBounds = new float[jsonArray.length()];
        	 float[] dataLowerBounds = new float[jsonArray.length()];
        	 float[] dataForecasts = new float[jsonArray.length()];
        	 String[] dataDay = new String[jsonArray.length()];
        	 
        	 for (int i = 0, size = jsonArray.length(); i < size; i++) {
        		 
        		 JSONObject first = jsonArray.getJSONObject(i);
        		 String name = first.getString("name");
        		 dataDay[i] = name;
        		 daySelected = daySelected + ", " + name;
        		 
        	     JSONArray breakdownArray = first.getJSONArray("breakdown");
        	     JSONObject firstBreakdown = breakdownArray.getJSONObject(0);
        	     
        	     JSONArray countArray = firstBreakdown.getJSONArray("counts");
        	     String counts = countArray.getString(0);
        	     dataCounts[i] = Float.valueOf(counts);
        	     
        	     JSONArray upperBoundsArray = firstBreakdown.getJSONArray("upperBounds");
        	     String upperBounds = upperBoundsArray.getString(0);
        	     dataUpperBounds[i] = Float.valueOf(upperBounds);
        	     
        	     JSONArray lowerBoundsArray = firstBreakdown.getJSONArray("lowerBounds");
        	     String lowerBounds = lowerBoundsArray.getString(0);
        	     dataLowerBounds[i] = Float.valueOf(lowerBounds);
        	     
        	     JSONArray forecastsArray = firstBreakdown.getJSONArray("forecasts");
        	     String forecasts = forecastsArray.getString(0);
        	     dataForecasts[i] = Float.valueOf(forecasts);
        	     
        	     daySelected = daySelected + "!! " + counts;
        	   }
        	 Log.i("AfterresetViewport: ", "AfterresetViewport");
        	 generateValuesBounces(dataUpperBounds, dataCounts, dataLowerBounds, dataForecasts);
        	 Log.i("AftergenerateValues: ", "AftergenerateValues");
        	 generateDataBounces();
        	 Log.i("AftergenerateData: ", "AftergenerateData");

        	
        	 
        Log.i("Response", "daySelected:" + daySelected);

    	 //etResponse.setText(daySelected);
    	 
	 } catch (JSONException e) {
    	 // TODO Auto-generated catch block
		 Log.i("MyActivity", "Test:" + e.toString());
    	 }
      }
    }



public String GETPageViews(String url){	

   return fileOutputPageViews;

}

public String GETCalledPages(String url){	

   return fileOutputCalledPages;

}

public String GETBounces(String url){	

   return fileOutputBounces;

}


/**
 * ---------------------------------------------------------------------------------------------------------
 * Graph Settings
 */
//The values are sorted and saved in multidimensional arrays for a better readability

private void generateValuesPageViews(float[] dataUpperBounds, float[] dataCounts, float[] dataLowerBounds, float[] dataForecasts) {
	for (int i = 0; i < maxNumberOfLines; i++) {
		for (int j = 0; j < dataUpperBounds.length; j++) {
			switch (i) {
			case 0: randomNumbersTabPageViews[i][j] = dataUpperBounds[j]; break;
			case 1: randomNumbersTabPageViews[i][j] = dataCounts[j]; break;
			case 2: randomNumbersTabPageViews[i][j] = dataLowerBounds[j]; break;
			case 3: randomNumbersTabPageViews[i][j] = dataForecasts[j]; break;
			}
			
		}
	}
}

private void generateValuesCalledPages(float[] dataUpperBounds, float[] dataCounts, float[] dataLowerBounds, float[] dataForecasts) {
	for (int i = 0; i < maxNumberOfLines; i++) {
		for (int j = 0; j < dataUpperBounds.length; j++) {
			switch (i) {
			case 0: randomNumbersTabCalledPages[i][j] = dataUpperBounds[j]; break;
			case 1: randomNumbersTabCalledPages[i][j] = dataCounts[j]; break;
			case 2: randomNumbersTabCalledPages[i][j] = dataLowerBounds[j]; break;
			case 3: randomNumbersTabCalledPages[i][j] = dataForecasts[j]; break;
			}
			
		}
	}
}

private void generateValuesBounces(float[] dataUpperBounds, float[] dataCounts, float[] dataLowerBounds, float[] dataForecasts) {
	for (int i = 0; i < maxNumberOfLines; i++) {
		for (int j = 0; j < dataUpperBounds.length; j++) {
			switch (i) {
			case 0: randomNumbersTabBounces[i][j] = dataUpperBounds[j]; break;
			case 1: randomNumbersTabBounces[i][j] = dataCounts[j]; break;
			case 2: randomNumbersTabBounces[i][j] = dataLowerBounds[j]; break;
			case 3: randomNumbersTabBounces[i][j] = dataForecasts[j]; break;
			}
			
		}
	}
}




private void generateDataPageViews() {
	
	//Set up of the lines and the graph

	List<Line> lines = new ArrayList<Line>();
	for (int i = 0; i < maxNumberOfLines; ++i) {

		List<PointValue> values = new ArrayList<PointValue>();
		for (int j = 0; j < (randomNumbersTabPageViews.length - 1); ++j) {
			values.add(new PointValue(j, randomNumbersTabPageViews[i][j]));
			 Log.i("Output Generate Data", "i :" + i + "j : " + j + " value: " + randomNumbersTabPageViews[i][j]);
		}

		Line line = new Line(values);
		line.setColor(Utils.COLORS[i]);
		line.setShape(shape);
		line.setCubic(isCubic);
		line.setFilled(isFilled);
		line.setHasLabels(hasLabels);
		line.setHasLabelsOnlyForSelected(hasLabelForSelected);
		line.setHasLines(hasLines);
		line.setHasPoints(hasPoints);
		lines.add(line);
	}

	datapageviews = new LineChartData(lines);

	if (hasAxes) {
		Axis axisX = new Axis();
		Axis axisY = new Axis().setHasLines(true);
		if (hasAxesNames) {
			axisX.setName("Axis X");
			axisY.setName("Axis Y");
		}
		datapageviews.setAxisXBottom(axisX);
		datapageviews.setAxisYLeft(axisY);
	} else {
		datapageviews.setAxisXBottom(null);
		datapageviews.setAxisYLeft(null);
	}

	datapageviews.setBaseValue(Float.NEGATIVE_INFINITY);
	
	//Set Linechart
	LineChartView lineChartViewPageViews = new LineChartView(getActivity());
	lineChartViewPageViews.setLineChartData(datapageviews);
	lineChartViewPageViews.setZoomType(ZoomType.HORIZONTAL);
	final Viewport v = new Viewport(lineChartViewPageViews.getMaximumViewport());
	v.bottom = 0;
	v.top = 200000;
	lineChartViewPageViews.setMaximumViewport(v);
	lineChartViewPageViews.setCurrentViewport(v, false);

	/** Note: Chart is within ViewPager so enable container scroll mode. **/
	lineChartViewPageViews.setContainerScrollEnabled(true, ContainerScrollType.HORIZONTAL);
	layout.addView(lineChartViewPageViews);

}

private void generateDataCalledPages() {

	List<Line> lines = new ArrayList<Line>();
	for (int i = 0; i < maxNumberOfLines; ++i) {

		List<PointValue> values = new ArrayList<PointValue>();
		for (int j = 0; j < (randomNumbersTabCalledPages.length - 1); ++j) {
			values.add(new PointValue(j, randomNumbersTabCalledPages[i][j]));
			 Log.i("Output Generate Data", "i :" + i + "j : " + j + " value: " + randomNumbersTabCalledPages[i][j]);
		}

		Line line = new Line(values);
		line.setColor(Utils.COLORS[i]);
		line.setShape(shape);
		line.setCubic(isCubic);
		line.setFilled(isFilled);
		line.setHasLabels(hasLabels);
		line.setHasLabelsOnlyForSelected(hasLabelForSelected);
		line.setHasLines(hasLines);
		line.setHasPoints(hasPoints);
		lines.add(line);
	}

	datapagecalledpages = new LineChartData(lines);

	if (hasAxes) {
		Axis axisX = new Axis();
		Axis axisY = new Axis().setHasLines(true);
		if (hasAxesNames) {
			axisX.setName("Axis X");
			axisY.setName("Axis Y");
		}
		datapagecalledpages.setAxisXBottom(axisX);
		datapagecalledpages.setAxisYLeft(axisY);
	} else {
		datapagecalledpages.setAxisXBottom(null);
		datapagecalledpages.setAxisYLeft(null);
	}

	datapagecalledpages.setBaseValue(Float.NEGATIVE_INFINITY);
	
 //set linechart
	LineChartView lineChartViewCalledPages = new LineChartView(getActivity());
	lineChartViewCalledPages.setLineChartData(datapagecalledpages);
	lineChartViewCalledPages.setZoomType(ZoomType.HORIZONTAL);
	final Viewport v = new Viewport(lineChartViewCalledPages.getMaximumViewport());
	v.bottom = 0;
	v.top = 200000;
	lineChartViewCalledPages.setMaximumViewport(v);
	lineChartViewCalledPages.setCurrentViewport(v, false);

	/** Note: Chart is within ViewPager so enable container scroll mode. **/
	lineChartViewCalledPages.setContainerScrollEnabled(true, ContainerScrollType.HORIZONTAL);
	layout.addView(lineChartViewCalledPages);

}

private void generateDataBounces() {

	List<Line> lines = new ArrayList<Line>();
	for (int i = 0; i < maxNumberOfLines; ++i) {

		List<PointValue> values = new ArrayList<PointValue>();
		for (int j = 0; j < (randomNumbersTabBounces.length - 1); ++j) {
			values.add(new PointValue(j, randomNumbersTabBounces[i][j]));
			 Log.i("Output Generate Data", "i :" + i + "j : " + j + " value: " + randomNumbersTabBounces[i][j]);
		}

		Line line = new Line(values);
		line.setColor(Utils.COLORS[i]);
		line.setShape(shape);
		line.setCubic(isCubic);
		line.setFilled(isFilled);
		line.setHasLabels(hasLabels);
		line.setHasLabelsOnlyForSelected(hasLabelForSelected);
		line.setHasLines(hasLines);
		line.setHasPoints(hasPoints);
		lines.add(line);
	}

	datapagebounces = new LineChartData(lines);

	if (hasAxes) {
		Axis axisX = new Axis();
		Axis axisY = new Axis().setHasLines(true);
		if (hasAxesNames) {
			axisX.setName("Axis X");
			axisY.setName("Axis Y");
		}
		datapagebounces.setAxisXBottom(axisX);
		datapagebounces.setAxisYLeft(axisY);
	} else {
		datapagebounces.setAxisXBottom(null);
		datapagebounces.setAxisYLeft(null);
	}

	datapagebounces.setBaseValue(Float.NEGATIVE_INFINITY);
	
 //set linechart
	LineChartView lineChartViewBounces = new LineChartView(getActivity());
	lineChartViewBounces.setLineChartData(datapagebounces);
	lineChartViewBounces.setZoomType(ZoomType.HORIZONTAL);
	final Viewport v = new Viewport(lineChartViewBounces.getMaximumViewport());
	v.bottom = 0;
	v.top = 10000;
	lineChartViewBounces.setMaximumViewport(v);
	lineChartViewBounces.setCurrentViewport(v, false);

	/** Note: Chart is within ViewPager so enable container scroll mode. **/
				lineChartViewBounces.setContainerScrollEnabled(true, ContainerScrollType.HORIZONTAL);
				layout.addView(lineChartViewBounces);
	
			}
			
			
		
			
		


	}

}
