/*
   RexxPOS v1.1
   New Releases will be published at website: www.lieferex.at/rexxpos
   e-mail: h0553559@gmail.com

   author:  H. Kaya Aydin  (implemented from fxml99 sample of Prof. Rony G. Flatscher)
   date:    2018-01-08
   changes: 2018-01-13 Bugfixes
    
   purpose: this is RexxPOS, a Point of Sale System (German: Kassensystem) for Austria
            It allows a shop, restaurant etc. create a POS and have Invoices printed
            with QR Code.

	    It has been coded during a Bachelor thesis. 

          
            The structure of this program (classes, controller) had been implementet from
            the fxml_99 Sample found under bsf4oorexx/samples Folder
            The controllers are coded in this Rexx file (a "Rexx package") as Rexx classes.

	    Prof. Rony G. Flatscher is greatly appreciated for this Sample (fxml_99) 
            thanks this code, it is easy to do many things with BSF4ooRexx and JavaFX
           
   license: Apache License 2.0 (see at bottom)

   invoke:
	    double click on start.rxj 

   needs: ooRexx 5.0 or higher, and BSF4ooRexx 6.00 or higher

*/

/* ========================================================================
   FIND CURRENT FOLDER NAME AND CHANGE TO SUB DIRECTORY /BIN 
===========================================================================
*/

PARSE SOURCE . . name
dir=FILESPEC('D', name) || FILESPEC('P', name)
"cd "dir
"cd bin"

/* ========================================================================
   CHECK CLASSPATH and ADD .JAR FILES AUTOMATICALLY INTO IT IF NOT EXISTS
===========================================================================
*/

if POS("mysql-connector",value("CLASSPATH",,"ENVIRONMENT"))=.false then
do
ver=SysVersion() -- get operating system version
	if ver~left(1)~upper="W" then -- a Windows OS
		do
			"set CLASSPATH=%CLASSPATH%;"directory()"\lib\mysql-connector-java-5.1.45-bin.jar;"
		end
	else if ver~left(1)~upper="L" | ver~left(1)~upper="U" then -- a Linux OS
		do
			"export CLASSPATH=$CLASSPATH:"directory()"/lib/mysql-connector-java-5.1.45-bin.jar"
		end
	else if ver~left(1)~upper="M" | ver~left(1)~upper="D" then -- a MacOS
		do
			say "***********************************************************************"
			say "Classpath Error:" 
			say "The .jar archieve mysql-connector-java-5.1.45-bin.jar or newer must be "
			say "added in  Classpath"
			say "***********************************************************************"
			say
			say "Please install official mysql driver at https://dev.mysql.com/downloads/connector/j/ "
			say
			say "Please check instruction on www how to edit Classpath on Mac"
			pull . 
		end
end


--if classp~contains("zxing")=.false then           -- check zxing .jar file
if POS("core-3.3.0.jar",value("CLASSPATH",,"ENVIRONMENT"))=.false then

do
ver=SysVersion() -- get operating system version
	if ver~left(1)~upper="W" then -- a Windows OS
		do
			"set CLASSPATH=%CLASSPATH%;"directory()"\lib\core-3.3.0.jar;"
		end
	else if ver~left(1)~upper="L" | ver~left(1)~upper="U" then -- a Linux OS
		do
			"export CLASSPATH=$CLASSPATH:"directory()"/lib/core-3.3.0.jar"
		end
	else if ver~left(1)~upper="M" | ver~left(1)~upper="D" then -- a MacOS
		do
			say "***********************************************************************"
			say "Classpath Error:" 
			say "The .jar archieve zxing.jar must be added in  Classpath"
			say "This is necessary for QR Code Barcode creation"
			say "***********************************************************************"
			say
			say "The file allready exists in lib directory of RexxPOS"
			say "Please check instruction on www how to edit Classpath on Mac"
			pull .
		end
end

if POS("javase-3.3.0.jar",value("CLASSPATH",,"ENVIRONMENT"))=.false then

do
ver=SysVersion() -- get operating system version
	if ver~left(1)~upper="W" then -- a Windows OS
		do
			"set CLASSPATH=%CLASSPATH%;"directory()"\lib\javase-3.3.0.jar;"
		end
	else if ver~left(1)~upper="L" | ver~left(1)~upper="U" then -- a Linux OS
		do
			"export CLASSPATH=$CLASSPATH:"directory()"/lib/javase-3.3.0.jar"
		end
	else if ver~left(1)~upper="M" | ver~left(1)~upper="D" then -- a MacOS
		do
			say "***********************************************************************"
			say "Classpath Error:" 
			say "The .jar archieve zxing.jar must be added in  Classpath"
			say "This is necessary for QR Code Barcode creation"
			say "***********************************************************************"
			say
			say "The file allready exists in lib directory of RexxPOS"
			say "Please check instruction on www how to edit Classpath on Mac"
			pull .
		end
end

-- ======== CHECK CLASSPATH End ===========================================

/* ========================================================================
   RUN MAIN APP   POS.RXJ
===========================================================================
*/

call "pos.rxj"


/*
      ------------------------ Apache Version 2.0 license -------------------------
         Copyright 2018 H. Kaya Aydin

         Licensed under the Apache License, Version 2.0 (the "License");
         you may not use this file except in compliance with the License.
         You may obtain a copy of the License at

             http://www.apache.org/licenses/LICENSE-2.0

         Unless required by applicable law or agreed to in writing, software
         distributed under the License is distributed on an "AS IS" BASIS,
         WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
         See the License for the specific language governing permissions and
         limitations under the License.
      -----------------------------------------------------------------------------
*/

