/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.bsf.BSFException;
import org.rexxla.bsf.engines.rexx.RexxCommandHandler;
import org.rexxla.bsf.engines.rexx.RexxExitHandler;

public class RexxConfiguration {
    public static final String version = "101.20161104";
    private String external_call_path = null;
    private String external_call_extensions = ".rxj,.rxo,.rxjo,.jrexx";
    private ArrayList<String> load_required_library = new ArrayList();
    private static BitSet validExits = new BitSet(16);
    private ArrayList<RexxExitHandler> exitHandlers = new ArrayList(16);
    private BitSet definedExits = new BitSet(16);
    private HashMap<String, RexxCommandHandler> commandHandlers = new HashMap();
    protected String initial_address_environment = null;
    protected boolean modifiable = true;

    public void setExternalCallPath(String string) throws BSFException {
        if (!this.modifiable) {
            throw new BSFException("RexxConfiguration already deployed, must not change value");
        }
        this.external_call_path = string;
    }

    public String getExternalCallPath() {
        return this.external_call_path;
    }

    public void setExternalCallExtensions(String string) throws BSFException {
        if (!this.modifiable) {
            throw new BSFException("RexxConfiguration already deployed, must not change value");
        }
        this.external_call_extensions = string;
    }

    public String getExternalCallExtensions() {
        return this.external_call_extensions;
    }

    public void addRequiredLibrary(String string) throws BSFException {
        if (string == null) {
            throw new BSFException("Required library name must not be null!");
        }
        if (!this.modifiable) {
            throw new BSFException("RexxConfiguration already deployed, must not change value");
        }
        this.load_required_library.add(string);
    }

    public String[] getRequiredLibraries() {
        int n = this.load_required_library.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.load_required_library.get(i);
        }
        return stringArray;
    }

    public String[] getRequiredLibraries4JNI() {
        if (this.load_required_library.size() == 0) {
            return null;
        }
        return this.getRequiredLibraries();
    }

    public RexxConfiguration() {
        for (int i = 0; i < 16; ++i) {
            this.exitHandlers.add(i, null);
        }
    }

    public Object[] getExitHandlers() {
        int n = this.definedExits.cardinality();
        int[] nArray = new int[n];
        RexxExitHandler[] rexxExitHandlerArray = new RexxExitHandler[n];
        Object[] objectArray = new Object[]{nArray, rexxExitHandlerArray};
        int n2 = 0;
        int n3 = this.definedExits.nextSetBit(0);
        while (n3 >= 0) {
            nArray[n2] = n3;
            rexxExitHandlerArray[n2] = this.exitHandlers.get(n3);
            ++n2;
            n3 = this.definedExits.nextSetBit(n3 + 1);
        }
        return objectArray;
    }

    public int[] getExitHandlers4JNI() {
        int n = this.definedExits.cardinality();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = this.definedExits.nextSetBit(0);
        while (n3 >= 0) {
            nArray[n2] = n3;
            ++n2;
            n3 = this.definedExits.nextSetBit(n3 + 1);
        }
        return nArray;
    }

    public BitSet getDefinedExits() {
        return (BitSet)this.definedExits.clone();
    }

    public Object[] getCommandHandlers() {
        int n = this.commandHandlers.size();
        String[] stringArray = new String[n];
        RexxCommandHandler[] rexxCommandHandlerArray = new RexxCommandHandler[n];
        Object[] objectArray = new Object[]{stringArray, rexxCommandHandlerArray};
        int n2 = 0;
        Iterator<String> iterator = this.commandHandlers.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n2] = string = iterator.next();
            rexxCommandHandlerArray[n2] = this.commandHandlers.get(string);
            ++n2;
        }
        return objectArray;
    }

    public String[] getCommandHandlerNames4JNI() {
        int n = this.commandHandlers.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        Iterator<String> iterator = this.commandHandlers.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n2] = string = iterator.next();
            ++n2;
        }
        return stringArray;
    }

    public void setInitialAddressEnvironment(String string) throws BSFException {
        if (!this.modifiable) {
            throw new BSFException("RexxConfiguration already deployed, must not change value");
        }
        this.initial_address_environment = string;
    }

    public String getInitialAddressEnvironment() {
        return this.initial_address_environment;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public void addExitHandler(int n, RexxExitHandler rexxExitHandler) throws BSFException {
        if (!this.modifiable) {
            throw new BSFException("RexxConfiguration already deployed, must not add new exit handlers. To change a RexxExitHandler object use 'setExitHandler()' instead.");
        }
        if (!validExits.get(n)) {
            throw new BSFException("Invalid Rexx exit function number [" + n + "]");
        }
        this.exitHandlers.add(n, rexxExitHandler);
        this.definedExits.set(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RexxExitHandler setExitHandler(int n, RexxExitHandler rexxExitHandler) throws BSFException {
        if (!validExits.get(n)) {
            throw new BSFException("Invalid Rexx exit function number [" + n + "]");
        }
        if (!this.definedExits.get(n)) {
            throw new BSFException("No exit handling defined for exit function number [" + n + "]");
        }
        RexxExitHandler rexxExitHandler2 = null;
        RexxConfiguration rexxConfiguration = this;
        synchronized (rexxConfiguration) {
            rexxExitHandler2 = this.exitHandlers.get(n);
            this.exitHandlers.set(n, rexxExitHandler);
        }
        return rexxExitHandler2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RexxExitHandler getExitHandler(int n) {
        if (!validExits.get(n)) {
            return null;
        }
        if (!this.definedExits.get(n)) {
            return null;
        }
        RexxExitHandler rexxExitHandler = null;
        RexxConfiguration rexxConfiguration = this;
        synchronized (rexxConfiguration) {
            rexxExitHandler = this.exitHandlers.get(n);
        }
        return rexxExitHandler;
    }

    public void addCommandHandler(String string, RexxCommandHandler rexxCommandHandler) throws BSFException {
        if (!this.modifiable) {
            throw new BSFException("RexxConfiguration already deployed, must not add new command handlers. To change a RexxCommandHandler object use 'setCommandHandler()' instead.");
        }
        if (string == null) {
            throw new BSFException("Rexx environment name must not be null!");
        }
        if (rexxCommandHandler == null) {
            throw new BSFException("RexxCommandHandler must not be null!");
        }
        this.commandHandlers.put(string, rexxCommandHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RexxCommandHandler setCommandHandler(String string, RexxCommandHandler rexxCommandHandler) throws BSFException {
        if (string == null) {
            throw new BSFException("Rexx environment name must not be null!");
        }
        if (!this.commandHandlers.containsKey(string)) {
            throw new BSFException("Rexx environment name [" + string + "] was not defined");
        }
        if (rexxCommandHandler == null) {
            throw new BSFException("RexxCommandHandler must not be null!");
        }
        RexxCommandHandler rexxCommandHandler2 = null;
        RexxConfiguration rexxConfiguration = this;
        synchronized (rexxConfiguration) {
            rexxCommandHandler2 = this.commandHandlers.get(string);
            this.commandHandlers.put(string, rexxCommandHandler);
        }
        return rexxCommandHandler2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RexxCommandHandler getCommandHandler(String string) {
        if (string == null) {
            return null;
        }
        RexxCommandHandler rexxCommandHandler = null;
        RexxConfiguration rexxConfiguration = this;
        synchronized (rexxConfiguration) {
            rexxCommandHandler = this.commandHandlers.get(string);
        }
        return rexxCommandHandler;
    }

    public Object[] getArguments4JNI() {
        Object[] objectArray = new Object[]{this, this.initial_address_environment, this.external_call_path, this.external_call_extensions, this.getRequiredLibraries4JNI(), this.getExitHandlers4JNI(), this.getCommandHandlerNames4JNI()};
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("initialAddressEnvironment=[").append(this.initial_address_environment).append(']');
        stringBuffer.append(',');
        stringBuffer.append("externalCallPath=[").append(this.external_call_path).append(']');
        stringBuffer.append(',');
        stringBuffer.append("externalCallExtensions=[").append(this.external_call_extensions).append(']');
        stringBuffer.append(',');
        stringBuffer.append("loadRequiredLibrary=");
        this.requiredLibraryToString(stringBuffer);
        stringBuffer.append(',');
        stringBuffer.append("exitHandlers=");
        this.exitHandlersToString(stringBuffer);
        stringBuffer.append(',');
        stringBuffer.append("commandHandlers=");
        this.commandHandlersToString(stringBuffer);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void requiredLibraryToString(StringBuffer stringBuffer) {
        boolean bl = false;
        stringBuffer.append('{');
        for (int i = 0; i < this.load_required_library.size(); ++i) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.load_required_library.get(i));
            bl = true;
        }
        stringBuffer.append('}');
    }

    private void commandHandlersToString(StringBuffer stringBuffer) {
        boolean bl = false;
        stringBuffer.append('{');
        Iterator<String> iterator = this.commandHandlers.keySet().iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(',');
            }
            String string = iterator.next();
            stringBuffer.append((Object)string).append('=').append(this.commandHandlers.get(string));
            bl = true;
        }
        stringBuffer.append('}');
    }

    private void exitHandlersToString(StringBuffer stringBuffer) {
        boolean bl = false;
        stringBuffer.append('{');
        int n = this.definedExits.nextSetBit(0);
        while (n >= 0) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append(RexxExitHandler.RX_EXIT_NAMES[n]);
            stringBuffer.append('/').append(n).append('/');
            stringBuffer.append(this.exitHandlers.get(n));
            bl = true;
            n = this.definedExits.nextSetBit(n + 1);
        }
        stringBuffer.append('}');
    }

    static {
        validExits.set(2);
        validExits.set(3);
        validExits.set(4);
        validExits.set(5);
        validExits.set(7);
        validExits.set(8);
        validExits.set(9);
        validExits.set(10);
        validExits.set(12);
        validExits.set(13);
        validExits.set(14);
        validExits.set(15);
    }
}

