/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bsf.BSFException;
import org.rexxla.bsf.engines.rexx.InvocationType;
import org.rexxla.bsf.engines.rexx.RexxAndJava;
import org.rexxla.bsf.engines.rexx.RexxReflectInterface;
import org.rexxla.bsf.engines.rexx.RexxReflectUtil;

class RexxReflectJava7
implements RexxReflectInterface {
    private static final boolean bDebug = false;
    public boolean useCaching = true;
    public boolean useReflectInvoke = false;
    public boolean useUnreflect = true;
    public int debugLevel = 0;
    boolean bDebugSuccess = false;
    public final MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
    public final MethodHandles.Lookup lookup;
    private MethodHandles.Lookup thisLookup = this.lookup = MethodHandles.lookup();
    boolean lookupWasSetToPublic = false;
    public int javaVersion2Support = 9;
    static Class<?>[] emptyClassArray = new Class[0];
    static ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, ArrayList<CachedFieldOrMethod>>> cachedFields = new ConcurrentHashMap();
    static ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, ArrayList<CachedFieldOrMethod>>> cachedMethods = new ConcurrentHashMap();
    static ConcurrentHashMap<Class<?>, ArrayList<CachedConstructor>> cachedConstructors = new ConcurrentHashMap();

    public MethodHandles.Lookup getLookup() {
        return this.thisLookup;
    }

    public void setLookup(MethodHandles.Lookup lookup) {
        if (!this.lookupWasSetToPublic) {
            this.lookupWasSetToPublic = lookup == this.publicLookup;
        }
        this.thisLookup = lookup;
    }

    @Override
    public boolean isPublicLookup() {
        return this.lookupWasSetToPublic;
    }

    @Override
    public void setPublicLookup() {
        if (!this.lookupWasSetToPublic) {
            this.setLookup(this.publicLookup);
        }
    }

    public static void clearCache() {
        cachedFields = new ConcurrentHashMap();
        cachedMethods = new ConcurrentHashMap();
        cachedConstructors = new ConcurrentHashMap();
    }

    RexxReflectJava7(int n) {
        this.javaVersion2Support = n;
    }

    @Override
    public void reflect(RexxReflectUtil rexxReflectUtil) throws BSFException {
        switch (rexxReflectUtil.reflectionType) {
            case REFLECT_FIELD: {
                this.reflectField(rexxReflectUtil);
                return;
            }
            case REFLECT_METHOD: {
                if (rexxReflectUtil.bBeanIsClass && rexxReflectUtil.funcArgs.length == 0) {
                    this.reflectNestedClass(rexxReflectUtil);
                    if (rexxReflectUtil.success) {
                        return;
                    }
                }
                this.reflectMethod(rexxReflectUtil);
                return;
            }
            case REFLECT_CONSTRUCTOR: {
                this.reflectConstructor(rexxReflectUtil);
                return;
            }
        }
        throw new BSFException(100, "Unexecpected reflection type '" + (Object)((Object)rexxReflectUtil.reflectionType) + "'");
    }

    void reflectField(RexxReflectUtil rexxReflectUtil) throws BSFException {
        ArrayList<CachedFieldOrMethod> arrayList;
        if (this.useCaching && cachedFields.containsKey(rexxReflectUtil.beanClz) && (arrayList = cachedFields.get(rexxReflectUtil.beanClz).get(rexxReflectUtil.keyMemberName)) != null) {
            block5: for (CachedFieldOrMethod object2 : arrayList) {
                switch (object2.mhk) {
                    case GETTER: 
                    case STATIC_GETTER: {
                        if (!rexxReflectUtil.bFieldGet) break;
                        if (object2.parameterTypes.length > 0 || rexxReflectUtil.funcArgs.length > 0) continue block5;
                        this.invokeFieldGet(object2, rexxReflectUtil);
                        break;
                    }
                    case SETTER: 
                    case STATIC_SETTER: {
                        if (rexxReflectUtil.bFieldGet) break;
                        if (object2.parameterTypes.length != 1 || rexxReflectUtil.funcArgs.length != 1) continue block5;
                        this.invokeFieldSet(object2, rexxReflectUtil);
                        break;
                    }
                    case METHOD: 
                    case STATIC_METHOD: {
                        this.invokeMethod(object2, rexxReflectUtil);
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (!rexxReflectUtil.success) continue;
                if (this.debugLevel > 1) {
                    System.err.println("... reflectField():  WOW: found cached Field/MethodHandle (field name: \"" + rexxReflectUtil.keyMemberName + "\") and could execute it appropriately! : [" + object2.mh.toString() + "], result=[" + rexxReflectUtil.result + "]");
                }
                return;
            }
        }
        boolean bl = true;
        Class clazz = rexxReflectUtil.beanClz;
        while (!rexxReflectUtil.success) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int n = field.getModifiers();
                if ((n & 1) == 0 || !rexxReflectUtil.bFieldGet && (n & 0x10) != 0 || (rexxReflectUtil.bBeanIsClass || rexxReflectUtil.bStatic) && (n & 8) == 0) continue;
                this.processField(field, rexxReflectUtil);
                if (!rexxReflectUtil.success) continue;
                return;
            }
            if (rexxReflectUtil.bFieldGet) {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    this.getAndProcessFieldFromInterface(clazz2, rexxReflectUtil);
                    if (!rexxReflectUtil.success) continue;
                    return;
                }
            }
            if ((clazz = clazz.getSuperclass()) != Object.class) continue;
            break;
        }
        if (rexxReflectUtil.bRecursing) {
            return;
        }
        if (!rexxReflectUtil.bStrict) {
            RexxReflectUtil rexxReflectUtil2 = rexxReflectUtil.copy();
            rexxReflectUtil2.bOtherKind = true;
            rexxReflectUtil2.bRecursing = true;
            if (!rexxReflectUtil2.bFieldGet) {
                rexxReflectUtil2.bFieldGet = false;
                rexxReflectUtil2.memberName = "SET" + rexxReflectUtil.keyMemberName;
                this.reflectMethod(rexxReflectUtil2);
            } else {
                rexxReflectUtil2.memberName = "GET" + rexxReflectUtil.keyMemberName;
                this.reflectMethod(rexxReflectUtil2);
                if (rexxReflectUtil2.success) {
                    rexxReflectUtil.success = true;
                    rexxReflectUtil.result = rexxReflectUtil2.result;
                    return;
                }
                rexxReflectUtil2.memberName = "IS" + rexxReflectUtil.keyMemberName;
                this.reflectMethod(rexxReflectUtil2);
                if (rexxReflectUtil2.success) {
                    rexxReflectUtil.success = true;
                    rexxReflectUtil.result = rexxReflectUtil2.result;
                    return;
                }
                rexxReflectUtil2.memberName = "HAS" + rexxReflectUtil.keyMemberName;
                this.reflectMethod(rexxReflectUtil2);
            }
            if (rexxReflectUtil2.success) {
                rexxReflectUtil.success = rexxReflectUtil2.success;
                rexxReflectUtil.result = rexxReflectUtil2.result;
                return;
            }
        }
        rexxReflectUtil.throwNotFoundBSFException();
    }

    void getAndProcessFieldFromInterface(Class clazz, RexxReflectUtil rexxReflectUtil) {
        for (Field annotatedElement : clazz.getDeclaredFields()) {
            this.processField(annotatedElement, rexxReflectUtil);
            if (!rexxReflectUtil.success) continue;
            return;
        }
        for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
            this.getAndProcessFieldFromInterface((Class)annotatedElement, rexxReflectUtil);
            if (!rexxReflectUtil.success) continue;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processField(Field field, RexxReflectUtil rexxReflectUtil) {
        Class<?> clazz;
        Object object;
        MethodHandle methodHandle;
        boolean bl;
        block44: {
            Object[] objectArray;
            block45: {
                block43: {
                    String string = field.getName();
                    if (rexxReflectUtil.bStrict ? !string.equals(rexxReflectUtil.memberName) : !string.equalsIgnoreCase(rexxReflectUtil.memberName)) {
                        return;
                    }
                    int n = field.getModifiers();
                    bl = (n & 8) != 0;
                    methodHandle = null;
                    if (this.useUnreflect) {
                        try {
                            if (rexxReflectUtil.bFieldGet) {
                                methodHandle = this.thisLookup.unreflectGetter(field);
                            }
                            methodHandle = this.thisLookup.unreflectSetter(field);
                        }
                        catch (Throwable throwable) {
                            if (this.debugLevel > 0) {
                                System.err.println("// // :( RexxReflectJava7.processField(), thisLookup=\"" + this.thisLookup + "\".unreflect(tmpMethod) caused \"" + throwable + "\", hence Field \"" + field.getDeclaringClass().toString() + "\".\"" + field.toString() + "\" not a candidate, returning");
                            }
                            rexxReflectUtil.throwable = throwable;
                            return;
                        }
                    } else {
                        object = null;
                        try {
                            if (rexxReflectUtil.bFieldGet) {
                                if (bl) {
                                    object = "findStaticGetter";
                                    methodHandle = this.thisLookup.findStaticGetter(field.getDeclaringClass(), string, field.getType());
                                    break block43;
                                } else {
                                    object = "findGetter";
                                    methodHandle = this.thisLookup.findGetter(field.getDeclaringClass(), string, field.getType());
                                }
                                break block43;
                            }
                            if (bl) {
                                object = "findStaticSetter";
                                methodHandle = this.thisLookup.findStaticSetter(field.getDeclaringClass(), string, field.getType());
                            } else {
                                object = "findSetter";
                                methodHandle = this.thisLookup.findSetter(field.getDeclaringClass(), string, field.getType());
                            }
                        }
                        catch (Throwable throwable) {
                            if (this.debugLevel > 0) {
                                System.err.println("// // :( RexxReflectJava7.processField(), thisLookup=\"" + this.thisLookup + "\"." + (String)object + "(...) caused \"" + throwable + "\", hence Field \"" + field.getDeclaringClass().toString() + "\".\"" + field.toString() + "\" not a candidate, returning");
                            }
                            rexxReflectUtil.throwable = throwable;
                            return;
                        }
                    }
                }
                methodHandle = methodHandle.asFixedArity();
                if (this.debugLevel > 0) {
                    System.err.println("// // :) RexxReflectJava7.processField(), tmpField=[" + field.toString() + "]");
                }
                object = null;
                clazz = null;
                if (!rexxReflectUtil.bFieldGet) {
                    object = rexxReflectUtil.funcArgs[0];
                    clazz = field.getType();
                    if (object != null) {
                        objectArray = rexxReflectUtil.rajo.coerceArgs(new Object[]{object}, new Class[]{clazz});
                        if (objectArray == null) {
                            return;
                        }
                        object = objectArray[0];
                    }
                }
                if (!this.useReflectInvoke) break block45;
                if (rexxReflectUtil.bFieldGet) {
                    try {
                        rexxReflectUtil.result = bl ? field.get(null) : field.get(rexxReflectUtil.bean);
                    }
                    catch (Throwable throwable) {
                        if (this.debugLevel > 0) {
                            System.err.println("// // :( -> RexxReflectJava7.processField(): GET invocation for Field \"" + field.getDeclaringClass().toString() + "\".\"" + field.toString() + "\" caused \"" + throwable + "\", not a candidate, returning");
                        }
                        rexxReflectUtil.throwable = throwable;
                        return;
                    }
                    rexxReflectUtil.success = true;
                    break block44;
                } else {
                    try {
                        field.set(rexxReflectUtil.bean, object);
                        rexxReflectUtil.success = true;
                        return;
                    }
                    catch (Throwable throwable) {
                        if (this.debugLevel > 0) {
                            System.err.println("// // :( -> RexxReflectJava7.processField(): SET invocation for bean's =\"" + rexxReflectUtil.bean + "\" Field \"" + field.getDeclaringClass().toString() + "\".\"" + field.toString() + "\" to the valeu=\"" + object + "\" caused \"" + throwable + "\", not a candidate, returning");
                        }
                        rexxReflectUtil.throwable = throwable;
                        return;
                    }
                }
            }
            objectArray = null;
            try {
                if (rexxReflectUtil.bFieldGet) {
                    if (bl) {
                        objectArray = "GET (STATIC)";
                        rexxReflectUtil.result = methodHandle.invoke();
                        break block44;
                    } else {
                        objectArray = "GET";
                        rexxReflectUtil.result = methodHandle.invoke(rexxReflectUtil.bean);
                    }
                    break block44;
                }
                if (bl) {
                    objectArray = "SET (STATIC)";
                    methodHandle.invoke(object);
                } else {
                    objectArray = "SET";
                    methodHandle.invoke(rexxReflectUtil.bean, object);
                }
            }
            catch (Throwable throwable) {
                if (this.debugLevel > 0) {
                    System.err.println("// // :( -> RexxReflectJava7.processField(): MethodHandle " + (String)objectArray + " invocation caused \"" + throwable + "\", not a candidate, returning");
                }
                rexxReflectUtil.throwable = throwable;
                return;
            }
        }
        rexxReflectUtil.success = true;
        if (this.debugLevel > 2 || this.bDebugSuccess) {
            System.err.println("// // :) -> RexxReflectJava7.processField(): bean=\"" + rexxReflectUtil.bean + "\", [" + (Object)((Object)rexxReflectUtil.choice) + "] invocation using [" + (this.useReflectInvoke ? "java.lang.reflect.Field" : "MethodHandle") + "] [" + field.toString() + "] SUCCESSFUL, rru.result=\"" + rexxReflectUtil.result + "\"" + (rexxReflectUtil.result == null ? "" : " .toString()=\"" + rexxReflectUtil.result.toString() + "\"") + (rexxReflectUtil.bFieldGet ? "" : " - newValue=\"" + object + "\"" + (object == null ? "" : " .toString()=\"" + object.toString() + "\"")));
        }
        if (!this.useCaching) return;
        if (rexxReflectUtil.bFieldGet) {
            if (bl) {
                if (!rexxReflectUtil.bOtherKind) {
                    this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(field, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.STATIC_GETTER, emptyClassArray), cachedFields, rexxReflectUtil);
                    return;
                }
                this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(field, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.STATIC_METHOD, emptyClassArray), cachedMethods, rexxReflectUtil);
                return;
            }
            if (!rexxReflectUtil.bOtherKind) {
                this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(field, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.GETTER, emptyClassArray), cachedFields, rexxReflectUtil);
                return;
            }
            this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(field, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.METHOD, emptyClassArray), cachedMethods, rexxReflectUtil);
            return;
        }
        if (bl) {
            if (!rexxReflectUtil.bOtherKind) {
                this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(field, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.STATIC_SETTER, new Class[]{clazz}), cachedFields, rexxReflectUtil);
                return;
            }
            this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(field, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.STATIC_METHOD, new Class[]{clazz}), cachedMethods, rexxReflectUtil);
            return;
        }
        if (!rexxReflectUtil.bOtherKind) {
            this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(field, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.SETTER, new Class[]{clazz}), cachedFields, rexxReflectUtil);
            return;
        }
        this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(field, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.METHOD, new Class[]{clazz}), cachedMethods, rexxReflectUtil);
    }

    void invokeFieldGet(CachedFieldOrMethod cachedFieldOrMethod, RexxReflectUtil rexxReflectUtil) {
        try {
            rexxReflectUtil.result = cachedFieldOrMethod.mhk == MH_Kind.STATIC_GETTER ? (this.useReflectInvoke ? (cachedFieldOrMethod.bOtherKind ? ((Method)cachedFieldOrMethod.ro).invoke(rexxReflectUtil.bean, new Object[0]) : ((Field)cachedFieldOrMethod.ro).get(rexxReflectUtil.bean)) : cachedFieldOrMethod.mh.invoke()) : (this.useReflectInvoke ? (cachedFieldOrMethod.bOtherKind ? ((Method)cachedFieldOrMethod.ro).invoke(rexxReflectUtil.bean, new Object[0]) : ((Field)cachedFieldOrMethod.ro).get(rexxReflectUtil.bean)) : cachedFieldOrMethod.mh.invoke(rexxReflectUtil.bean));
        }
        catch (Throwable throwable) {
            if (this.debugLevel > 3) {
                System.err.println("// // :( -> RexxReflectJava7.invokeFieldGet(), t=\"" + throwable + "\"");
            }
            rexxReflectUtil.throwable = throwable;
            return;
        }
        rexxReflectUtil.success = true;
        if (this.debugLevel > 2 || this.bDebugSuccess) {
            System.err.println("// // :) -> RexxReflectJava7.invokeFieldGet(): bean=\"" + rexxReflectUtil.bean + "\",[" + (Object)((Object)rexxReflectUtil.choice) + "] invocation using [" + (this.useReflectInvoke ? "java.lang.reflect.Field" : "MethodHandle") + "] successful, rru.result=\"" + rexxReflectUtil.result + "\"" + (rexxReflectUtil.result == null ? "" : " .toString()=\"" + rexxReflectUtil.result.toString() + "\""));
        }
    }

    void invokeFieldSet(CachedFieldOrMethod cachedFieldOrMethod, RexxReflectUtil rexxReflectUtil) {
        Object object = rexxReflectUtil.funcArgs[0];
        try {
            Object var4_4 = null;
            if (object != null) {
                object = rexxReflectUtil.rajo.coerceArgs(new Object[]{object}, cachedFieldOrMethod.parameterTypes)[0];
            }
            if (cachedFieldOrMethod.mhk == MH_Kind.STATIC_SETTER) {
                if (this.useReflectInvoke) {
                    if (cachedFieldOrMethod.bOtherKind) {
                        ((Method)cachedFieldOrMethod.ro).invoke(rexxReflectUtil.bean, object);
                    } else {
                        ((Field)cachedFieldOrMethod.ro).set(rexxReflectUtil.bean, object);
                    }
                } else {
                    cachedFieldOrMethod.mh.invoke(object);
                }
            } else if (this.useReflectInvoke) {
                if (cachedFieldOrMethod.bOtherKind) {
                    ((Method)cachedFieldOrMethod.ro).invoke(rexxReflectUtil.bean, object);
                } else {
                    ((Field)cachedFieldOrMethod.ro).set(rexxReflectUtil.bean, object);
                }
            } else {
                cachedFieldOrMethod.mh.invoke(rexxReflectUtil.bean, object);
            }
        }
        catch (Throwable throwable) {
            if (this.debugLevel > 3) {
                System.err.println("// // :( -> RexxReflectJava7.invokeFieldSet(), t=\"" + throwable + "\"");
            }
            rexxReflectUtil.throwable = throwable;
            return;
        }
        if (this.debugLevel > 2 || this.bDebugSuccess) {
            System.err.println("// // :) -> RexxReflectJava7.invokeFieldSet(): bean=\"" + rexxReflectUtil.bean + "\",[" + (Object)((Object)rexxReflectUtil.choice) + "] invocation using [" + (this.useReflectInvoke ? "java.lang.reflect.Field" : "MethodHandle") + "] successfulnewValue=\"" + object + "\"" + (object == null ? "" : " \".toString()=\"" + object.toString() + "\""));
        }
        rexxReflectUtil.success = true;
    }

    void reflectNestedClass(RexxReflectUtil rexxReflectUtil) {
        boolean bl = false;
        for (Class clazz = rexxReflectUtil.beanClz; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Class<?>[] classArray = clazz.getDeclaredClasses();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                String string = clazz2.getSimpleName();
                boolean bl2 = false;
                bl2 = rexxReflectUtil.bStrict ? string.equals(rexxReflectUtil.memberName) : string.equalsIgnoreCase(rexxReflectUtil.memberName);
                if (!bl2) continue;
                int n = clazz2.getModifiers();
                if ((n & 1) != 0 || bl && (n & 4) != 0) {
                    rexxReflectUtil.result = clazz2;
                    rexxReflectUtil.success = true;
                    return;
                }
                return;
            }
            bl = true;
        }
    }

    void reflectMethod(RexxReflectUtil rexxReflectUtil) throws BSFException {
        Object object;
        ArrayList<CachedFieldOrMethod> arrayList;
        if (this.useCaching && cachedMethods.containsKey(rexxReflectUtil.beanClz) && (arrayList = cachedMethods.get(rexxReflectUtil.beanClz).get(rexxReflectUtil.keyMemberName)) != null) {
            block5: for (CachedFieldOrMethod cachedFieldOrMethod : arrayList) {
                switch (cachedFieldOrMethod.mhk) {
                    case METHOD: 
                    case STATIC_METHOD: {
                        this.invokeMethod(cachedFieldOrMethod, rexxReflectUtil);
                        break;
                    }
                    case GETTER: 
                    case STATIC_GETTER: {
                        if (!rexxReflectUtil.bFieldGet) break;
                        this.invokeFieldGet(cachedFieldOrMethod, rexxReflectUtil);
                        break;
                    }
                    case SETTER: 
                    case STATIC_SETTER: {
                        if (rexxReflectUtil.bFieldGet) break;
                        this.invokeFieldSet(cachedFieldOrMethod, rexxReflectUtil);
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (!rexxReflectUtil.success) continue;
                if (this.debugLevel > 1) {
                    System.err.println("... reflectMethod(): WOW, found cached Method/MethodHandle (method name=\"" + rexxReflectUtil.keyMemberName + "\") and could execute it appropriately! : [" + cachedFieldOrMethod.mh.toString() + "], result=[" + rexxReflectUtil.result + "]" + (rexxReflectUtil.result == null ? "" : " .toString()=\"" + rexxReflectUtil.result.toString() + "\""));
                }
                return;
            }
        }
        boolean bl = true;
        Class<Object> clazz = rexxReflectUtil.beanClz;
        boolean bl2 = false;
        while (!rexxReflectUtil.success) {
            object = clazz.getDeclaredMethods();
            for (int i = 0; i < ((Method[])object).length; ++i) {
                Method method = object[i];
                int n = method.getModifiers();
                if ((n & 1) == 0 || (rexxReflectUtil.bBeanIsClass || rexxReflectUtil.bStatic) && !bl2 && (n & 8) == 0) continue;
                this.processMethod(method, rexxReflectUtil);
                if (!rexxReflectUtil.success) continue;
                return;
            }
            RexxAndJava cfr_ignored_0 = rexxReflectUtil.rajo;
            if (RexxAndJava.javaRuntimeVersion >= 8) {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    this.getAndProcessMethodFromInterface(clazz2, rexxReflectUtil);
                    if (!rexxReflectUtil.success) continue;
                    return;
                }
            }
            if (rexxReflectUtil.bBeanIsClass && clazz == Object.class && !bl2) {
                clazz = Class.class;
                bl2 = true;
                continue;
            }
            if ((clazz = clazz.isPrimitive() || clazz.isInterface() ? Object.class : clazz.getSuperclass()) != null) continue;
            break;
        }
        if (rexxReflectUtil.bRecursing) {
            return;
        }
        if (!rexxReflectUtil.bStrict && rexxReflectUtil.funcArgs.length < 2) {
            if (rexxReflectUtil.funcArgs.length == 0 && "MAKEARRAY SUPPLIER".indexOf(rexxReflectUtil.keyMemberName) >= 0) {
                rexxReflectUtil.processMakearrayOrSupplier();
                if (rexxReflectUtil.success) {
                    return;
                }
            }
            object = rexxReflectUtil.copy();
            object.bOtherKind = true;
            object.bRecursing = true;
            if (rexxReflectUtil.funcArgs.length == 1) {
                object.bFieldGet = false;
                object.memberName = rexxReflectUtil.keyMemberName;
                this.reflectField((RexxReflectUtil)object);
                if (object.success) {
                    rexxReflectUtil.success = true;
                    rexxReflectUtil.result = object.result;
                    return;
                }
                object.memberName = "SET" + rexxReflectUtil.keyMemberName;
                this.reflectMethod((RexxReflectUtil)object);
            } else {
                object.bFieldGet = true;
                object.memberName = rexxReflectUtil.keyMemberName;
                this.reflectField((RexxReflectUtil)object);
                if (object.success) {
                    rexxReflectUtil.success = true;
                    rexxReflectUtil.result = object.result;
                    return;
                }
                object.bOtherKind = false;
                object.memberName = "GET" + rexxReflectUtil.keyMemberName;
                this.reflectMethod((RexxReflectUtil)object);
                if (object.success) {
                    rexxReflectUtil.success = true;
                    rexxReflectUtil.result = object.result;
                    return;
                }
                object.memberName = "IS" + rexxReflectUtil.keyMemberName;
                this.reflectMethod((RexxReflectUtil)object);
                if (object.success) {
                    rexxReflectUtil.success = true;
                    rexxReflectUtil.result = object.result;
                    return;
                }
                object.memberName = "HAS" + rexxReflectUtil.keyMemberName;
                this.reflectMethod((RexxReflectUtil)object);
            }
            if (object.success) {
                rexxReflectUtil.success = object.success;
                rexxReflectUtil.result = object.result;
                return;
            }
        }
        rexxReflectUtil.throwNotFoundBSFException();
    }

    void getAndProcessMethodFromInterface(Class clazz, RexxReflectUtil rexxReflectUtil) {
        for (Method genericDeclaration : clazz.getDeclaredMethods()) {
            this.processMethod(genericDeclaration, rexxReflectUtil);
            if (!rexxReflectUtil.success) continue;
            return;
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            this.getAndProcessMethodFromInterface((Class)genericDeclaration, rexxReflectUtil);
            if (!rexxReflectUtil.success) continue;
            return;
        }
    }

    void processMethod(Method method, RexxReflectUtil rexxReflectUtil) {
        int n;
        Object[] objectArray;
        String string = method.getName();
        if (rexxReflectUtil.bStrict ? !string.equals(rexxReflectUtil.memberName) : !string.equalsIgnoreCase(rexxReflectUtil.memberName)) {
            return;
        }
        Class[] classArray = method.getParameterTypes();
        if (classArray.length != rexxReflectUtil.funcArgs.length) {
            return;
        }
        Object[] objectArray2 = objectArray = classArray.length == 0 ? rexxReflectUtil.funcArgs : rexxReflectUtil.rajo.coerceArgs(rexxReflectUtil.funcArgs, classArray);
        if (objectArray == null) {
            return;
        }
        if (this.debugLevel > 0) {
            System.err.println("// // // RexxReflectJava7.processMethod(), FOUND candidate method=\"" + method.getDeclaringClass().toString() + "\".\"" + method.toString() + "\"...");
        }
        if (rexxReflectUtil.bOtherKind && classArray.length == 0 && (rexxReflectUtil.keyMemberName.startsWith("IS") || rexxReflectUtil.keyMemberName.startsWith("HAS"))) {
            Class<?> clazz = method.getReturnType();
            System.err.println("// // T? RexxReflectJava7.processMethod(), IS or HAS getter (\"" + rexxReflectUtil.keyMemberName + "\"), return type boolean, or Boolean?: \"" + clazz.toString() + "\".");
            if (clazz != Boolean.TYPE && clazz != Boolean.class) {
                System.err.println("// // :( RexxReflectJava7.processMethod(), IS or HAS getter (\"" + rexxReflectUtil.keyMemberName + "\") not of type boolean, nor Boolean, instead: \"" + clazz + "\", not eligible, returning");
                return;
            }
        }
        boolean bl = ((n = method.getModifiers()) & 8) != 0;
        Class<?> clazz = method.getDeclaringClass();
        if (bl && rexxReflectUtil.beanClz != clazz && clazz.isInterface()) {
            return;
        }
        MethodHandle methodHandle = null;
        if (this.useUnreflect) {
            try {
                methodHandle = this.thisLookup.unreflect(method);
            }
            catch (Throwable throwable) {
                if (this.debugLevel > 0) {
                    System.err.println("// // :( RexxReflectJava7.processMethod(), thisLookup=\"" + this.thisLookup + "\".unreflect(tmpMethod) caused \"" + throwable + "\", hence Method \"" + method.getDeclaringClass().toString() + "\".\"" + method.toString() + "\" not a candidate, returning");
                }
                rexxReflectUtil.throwable = throwable;
                return;
            }
        }
        String string2 = null;
        try {
            Class<?> clazz2 = method.getReturnType();
            MethodType methodType = MethodType.methodType(clazz2, classArray);
            if (bl) {
                string2 = "findStatic";
                methodHandle = this.thisLookup.findStatic(clazz, string, methodType);
            } else {
                string2 = "findVirtual";
                methodHandle = this.thisLookup.findVirtual(clazz, string, methodType);
            }
        }
        catch (Throwable throwable) {
            if (this.debugLevel > 0) {
                System.err.println("// // :( RexxReflectJava7.processMethod(), thisLookup=\"" + this.thisLookup + "\"." + string2 + "(...) caused \"" + throwable + "\", hence Method \"" + method.getDeclaringClass().toString() + "\".\"" + method.toString() + "\" not a candidate, returning");
            }
            rexxReflectUtil.throwable = throwable;
            return;
        }
        methodHandle = methodHandle.asFixedArity();
        if (this.debugLevel > 0) {
            System.err.println("// // F? RexxReflectJava7.processMethod(), FOUND? try invoking - tmpMethod=[" + method.toString() + "], mh=[" + methodHandle + "]");
        }
        if (this.useReflectInvoke) {
            try {
                rexxReflectUtil.result = method.invoke(rexxReflectUtil.bean, objectArray);
            }
            catch (Throwable throwable) {
                if (this.debugLevel > 0) {
                    System.err.println("// // :( RexxReflectJava7.processMethod(), tmpMethod.invoke(...) for bean=\"" + rexxReflectUtil.bean + "\" Method \"" + method.getDeclaringClass().toString() + "\".\"" + method.toString() + "\" caused \"" + throwable + "\", not a candidate, returning");
                }
                rexxReflectUtil.throwable = throwable;
                return;
            }
        }
        if (bl) {
            try {
                rexxReflectUtil.result = methodHandle.invokeWithArguments(objectArray);
            }
            catch (Throwable throwable) {
                if (this.debugLevel > 0) {
                    System.err.println("// // :( RexxReflectJava7.processMethod(): STATIC, mh.invokeWithArguments(...) caused Throwable \"" + throwable + "\", SHOULD NOT OCCUR?");
                }
                rexxReflectUtil.throwable = throwable;
                return;
            }
        }
        try {
            rexxReflectUtil.result = methodHandle.bindTo(rexxReflectUtil.bean).invokeWithArguments(objectArray);
        }
        catch (Throwable throwable) {
            if (this.debugLevel > 0) {
                System.err.println("// // :( RexxReflectJava7.processMethod(): INSTANCE, mh.invokeWithArguments(...) caused Throwable: \"" + throwable + "\"");
            }
            rexxReflectUtil.throwable = throwable;
            return;
        }
        rexxReflectUtil.success = true;
        if (this.debugLevel > 2 || this.bDebugSuccess) {
            System.err.println("// // :) -> RexxReflectJava7.processMethod(): bean=\"" + rexxReflectUtil.bean + "\",[" + (Object)((Object)rexxReflectUtil.choice) + "] invocation using [" + (this.useReflectInvoke ? "java.lang.reflect.Method" : "MethodHandle") + "] [" + method.toString() + "] SUCCESSFUL, rru.result=\"" + rexxReflectUtil.result + "\"");
        }
        if (this.useCaching) {
            if (bl) {
                if (!rexxReflectUtil.bOtherKind) {
                    this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(method, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.STATIC_METHOD, classArray), cachedMethods, rexxReflectUtil);
                } else if (classArray.length == 0) {
                    this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(method, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.STATIC_GETTER, classArray), cachedFields, rexxReflectUtil);
                } else {
                    this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(method, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.STATIC_SETTER, classArray), cachedFields, rexxReflectUtil);
                }
            } else if (!rexxReflectUtil.bOtherKind) {
                this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(method, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.METHOD, classArray), cachedMethods, rexxReflectUtil);
            } else if (classArray.length == 0) {
                this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(method, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.GETTER, classArray), cachedFields, rexxReflectUtil);
            } else {
                this.add2cachedFieldsOrMethods(new CachedFieldOrMethod(method, rexxReflectUtil.bOtherKind, methodHandle, MH_Kind.SETTER, classArray), cachedFields, rexxReflectUtil);
            }
        }
    }

    void invokeMethod(CachedFieldOrMethod cachedFieldOrMethod, RexxReflectUtil rexxReflectUtil) throws BSFException {
        Object[] objectArray;
        Class[] classArray = cachedFieldOrMethod.parameterTypes;
        if (classArray.length != rexxReflectUtil.funcArgs.length) {
            return;
        }
        if (classArray.length == 0) {
            objectArray = rexxReflectUtil.funcArgs;
        } else {
            objectArray = rexxReflectUtil.rajo.coerceArgs(rexxReflectUtil.funcArgs, classArray);
            if (objectArray == null) {
                return;
            }
        }
        try {
            if (this.useReflectInvoke) {
                if (cachedFieldOrMethod.bOtherKind) {
                    if (classArray.length == 0) {
                        rexxReflectUtil.result = ((Field)cachedFieldOrMethod.ro).get(rexxReflectUtil.bean);
                    } else {
                        ((Field)cachedFieldOrMethod.ro).set(rexxReflectUtil.bean, objectArray[0]);
                    }
                } else {
                    rexxReflectUtil.result = ((Method)cachedFieldOrMethod.ro).invoke(rexxReflectUtil.bean, objectArray);
                }
                rexxReflectUtil.success = true;
                if (this.debugLevel > 2) {
                    System.err.println("// // :) -> RexxReflectJava7.invokeMethod(): bean=\"" + rexxReflectUtil.bean + "\",[" + (Object)((Object)rexxReflectUtil.choice) + "] invocation using [" + (this.useReflectInvoke ? "java.lang.reflect.Method" : "MethodHandle") + "] successful, rru.result=\"" + rexxReflectUtil.result + "\"");
                }
                return;
            }
            rexxReflectUtil.result = cachedFieldOrMethod.mhk == MH_Kind.STATIC_METHOD ? (objectArray.length == 0 ? cachedFieldOrMethod.mh.invoke() : cachedFieldOrMethod.mh.invokeWithArguments(objectArray)) : (objectArray.length == 0 ? cachedFieldOrMethod.mh.bindTo(rexxReflectUtil.bean).invoke() : cachedFieldOrMethod.mh.bindTo(rexxReflectUtil.bean).invokeWithArguments(objectArray));
        }
        catch (Throwable throwable) {
            if (this.debugLevel > 3) {
                System.err.println("// // // :( -> RexxReflectJava7.invokeMethod(): Method=\"" + cachedFieldOrMethod.ro + "\", caused Throwable: \"" + throwable + "\"");
            }
            rexxReflectUtil.throwable = throwable;
            return;
        }
        rexxReflectUtil.success = true;
        if (this.debugLevel > 2 || this.bDebugSuccess) {
            System.err.println("// // :) -> RexxReflectJava7.invokeMethod(): bean=\"" + rexxReflectUtil.bean + "\",[" + (Object)((Object)rexxReflectUtil.choice) + "] invocation using [" + (this.useReflectInvoke ? "java.lang.reflect.Method" : "MethodHandle") + "] successful, rru.result=\"" + rexxReflectUtil.result + "\"");
        }
    }

    void add2cachedFieldsOrMethods(CachedFieldOrMethod cachedFieldOrMethod, ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, ArrayList<CachedFieldOrMethod>>> concurrentHashMap, RexxReflectUtil rexxReflectUtil) {
        if (concurrentHashMap.containsKey(rexxReflectUtil.beanClz)) {
            ConcurrentHashMap<String, ArrayList<CachedFieldOrMethod>> concurrentHashMap2 = concurrentHashMap.get(rexxReflectUtil.beanClz);
            ArrayList<CachedFieldOrMethod> arrayList = concurrentHashMap2.get(rexxReflectUtil.keyMemberName);
            if (arrayList == null) {
                arrayList = new ArrayList();
                concurrentHashMap2.put(rexxReflectUtil.keyMemberName, arrayList);
            }
            arrayList.add(cachedFieldOrMethod);
            return;
        }
        ArrayList<CachedFieldOrMethod> arrayList = new ArrayList<CachedFieldOrMethod>();
        arrayList.add(cachedFieldOrMethod);
        ConcurrentHashMap<String, ArrayList<CachedFieldOrMethod>> concurrentHashMap3 = new ConcurrentHashMap<String, ArrayList<CachedFieldOrMethod>>();
        concurrentHashMap3.put(rexxReflectUtil.keyMemberName, arrayList);
        concurrentHashMap.put(rexxReflectUtil.beanClz, concurrentHashMap3);
    }

    void reflectConstructor(RexxReflectUtil rexxReflectUtil) throws BSFException {
        ArrayList<CachedConstructor> arrayList;
        if (this.useCaching && cachedConstructors.containsKey(rexxReflectUtil.beanClz) && (arrayList = cachedConstructors.get(rexxReflectUtil.beanClz)) != null) {
            for (CachedConstructor object : arrayList) {
                if (object.parameterTypes.length != rexxReflectUtil.funcArgs.length) continue;
                this.invokeConstructor(object, rexxReflectUtil);
                if (!rexxReflectUtil.success) continue;
                if (this.debugLevel > 1) {
                    System.err.println("... reflectConstructor(): WOW, found cached Constructor/MethodHandle handle for class \"" + rexxReflectUtil.beanClz + "\" and could use it successfully: [" + object.mh.toString() + "]");
                }
                return;
            }
        }
        boolean bl = true;
        Class clazz = rexxReflectUtil.beanClz;
        while (!rexxReflectUtil.success) {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Constructor<?> constructor = constructorArray[i];
                int n = constructor.getModifiers();
                if ((n & 1) == 0) continue;
                this.processConstructor(constructor, rexxReflectUtil);
                if (!rexxReflectUtil.success) continue;
                return;
            }
            if ((clazz = clazz.getSuperclass()) != null) continue;
            break;
        }
        rexxReflectUtil.throwNotFoundBSFException();
    }

    void processConstructor(Constructor constructor, RexxReflectUtil rexxReflectUtil) {
        Object object;
        Object[] objectArray;
        Class[] classArray = constructor.getParameterTypes();
        if (classArray.length != rexxReflectUtil.funcArgs.length) {
            return;
        }
        Object[] objectArray2 = objectArray = classArray.length == 0 ? rexxReflectUtil.funcArgs : rexxReflectUtil.rajo.coerceArgs(rexxReflectUtil.funcArgs, classArray);
        if (objectArray == null) {
            return;
        }
        if (this.debugLevel > 0) {
            System.err.println("// // // RexxReflectJava7.processConstructor(), FOUND candidate constructor=\"" + constructor.getDeclaringClass().toString() + "\".\"" + constructor.toString() + "\"...");
        }
        MethodHandle methodHandle = null;
        String string = "";
        try {
            if (this.useUnreflect) {
                string = "unreflect";
                methodHandle = this.thisLookup.unreflectConstructor(constructor);
            } else {
                string = "findConstructor";
                object = MethodType.methodType(Void.TYPE, classArray);
                methodHandle = this.thisLookup.findConstructor(constructor.getDeclaringClass(), (MethodType)object);
            }
            methodHandle = methodHandle.asFixedArity();
        }
        catch (Throwable throwable) {
            if (this.debugLevel > 0) {
                System.err.println("// // :( RexxReflectJava7.processConstructor(), thisLookup=\"" + this.thisLookup + "\"." + string + "(...) caused \"" + throwable + "\", hence Method \"" + constructor.getDeclaringClass().toString() + "\".\"" + constructor.toString() + "\" not a candidate, returning");
            }
            rexxReflectUtil.throwable = throwable;
            return;
        }
        if (this.debugLevel > 0) {
            System.err.println("// // :) RexxReflectJava7.processConstructor(), tmpConstructor=[" + constructor.toString() + "]");
        }
        object = "";
        try {
            if (this.useReflectInvoke) {
                object = "tmpConstructor.newInstance(...)";
                rexxReflectUtil.result = constructor.newInstance(objectArray);
            } else {
                object = "mh.invokeWithArguments(...)";
                rexxReflectUtil.result = methodHandle.invokeWithArguments(objectArray);
            }
        }
        catch (Throwable throwable) {
            if (this.debugLevel > 0) {
                System.err.println("// // :( RexxReflectJava7.processConstructor(), " + (String)object + " for Constructor \"" + constructor.getDeclaringClass().toString() + "\".\"" + constructor.toString() + "\" caused \"" + throwable + "\", hence not a candidate, tsk, ...");
            }
            rexxReflectUtil.throwable = throwable;
            return;
        }
        rexxReflectUtil.success = true;
        if (this.debugLevel > 2 || this.bDebugSuccess) {
            System.err.println("// // :) -> RexxReflectJava7.processConstructor(): bean=\"" + rexxReflectUtil.bean + "\",[" + (Object)((Object)rexxReflectUtil.choice) + "] invocation using [" + (this.useReflectInvoke ? "java.lang.reflect.Constructor" : "MethodHandle") + "] [" + constructor.toString() + "] SUCCESSFUL, rru.result=\"" + rexxReflectUtil.result + "\"");
        }
        if (this.useCaching) {
            ArrayList<CachedConstructor> arrayList = cachedConstructors.get(rexxReflectUtil.beanClz);
            if (arrayList == null) {
                arrayList = new ArrayList();
                cachedConstructors.put(rexxReflectUtil.beanClz, arrayList);
            }
            arrayList.add(new CachedConstructor(constructor, methodHandle, classArray));
        }
    }

    void invokeConstructor(CachedConstructor cachedConstructor, RexxReflectUtil rexxReflectUtil) {
        Object[] objectArray;
        if (cachedConstructor.parameterTypes.length != rexxReflectUtil.funcArgs.length) {
            return;
        }
        if (cachedConstructor.parameterTypes.length != rexxReflectUtil.funcArgs.length) {
            return;
        }
        if (cachedConstructor.parameterTypes.length == 0) {
            objectArray = rexxReflectUtil.funcArgs;
        } else {
            objectArray = rexxReflectUtil.rajo.coerceArgs(rexxReflectUtil.funcArgs, cachedConstructor.parameterTypes);
            if (objectArray == null) {
                return;
            }
        }
        try {
            rexxReflectUtil.result = this.useReflectInvoke ? cachedConstructor.ro.newInstance(objectArray) : cachedConstructor.mh.invokeWithArguments(objectArray);
        }
        catch (Throwable throwable) {
            if (this.debugLevel > 3) {
                System.err.println("// // // :( -> RexxReflectJava7.invokeConstructor(): throwable: \"" + throwable + "\"\n");
            }
            rexxReflectUtil.throwable = throwable;
            return;
        }
        rexxReflectUtil.success = true;
        if (this.debugLevel > 2 || this.bDebugSuccess) {
            System.err.println("// // :) -> RexxReflectJava7.invokeConstructor(): bean=\"" + rexxReflectUtil.bean + "\",[" + (Object)((Object)rexxReflectUtil.choice) + "] invocation using [" + (this.useReflectInvoke ? "java.lang.reflect.Constructor" : "MethodHandle") + "] successful, rru.result=\"" + rexxReflectUtil.result + "\"");
        }
    }

    static void main(String[] stringArray) {
        System.err.println(RexxReflectJava7.class + ": main() - REFLECT_METHOD=" + (Object)((Object)RexxReflectUtil.ReflectionType.REFLECT_METHOD));
        RexxReflectUtil.ReflectionType reflectionType = RexxReflectUtil.ReflectionType.REFLECT_FIELD;
        System.err.println(RexxReflectJava7.class + ": main() - rt=" + (Object)((Object)reflectionType));
        System.err.println("\n" + RexxReflectJava7.class + ": main() - all ReflectionType enums:");
        for (RexxReflectUtil.ReflectionType enum_ : RexxReflectUtil.ReflectionType.values()) {
            System.err.println("\t" + (Object)((Object)enum_));
        }
        System.err.println("\n" + RexxReflectJava7.class + ": main() - all InvocationType enums:");
        for (Enum enum_ : InvocationType.values()) {
            System.err.println("\t" + enum_);
        }
    }

    static class CachedConstructor {
        Constructor ro;
        MethodHandle mh;
        Class<?>[] parameterTypes;

        CachedConstructor(Constructor constructor, MethodHandle methodHandle, Class<?>[] classArray) {
            this.ro = constructor;
            this.mh = methodHandle;
            this.parameterTypes = classArray;
        }

        public String toString() {
            return "CachedConstructor[o=" + this.ro + ",mh=" + this.mh + ",parameterTypes=" + Arrays.deepToString(this.parameterTypes) + "]";
        }
    }

    static class CachedFieldOrMethod {
        Object ro;
        boolean bOtherKind;
        MethodHandle mh;
        MH_Kind mhk;
        Class<?>[] parameterTypes;

        CachedFieldOrMethod(Object object, boolean bl, MethodHandle methodHandle, MH_Kind mH_Kind, Class<?>[] classArray) {
            this.ro = object;
            this.bOtherKind = bl;
            this.mh = methodHandle;
            this.mhk = mH_Kind;
            this.parameterTypes = classArray;
        }

        public String toString() {
            return "CachedFieldOrMethod[o=" + this.ro + ",bOtherKind=" + this.bOtherKind + ",mhk=" + (Object)((Object)this.mhk) + ",mh=" + this.mh + ",parameterTypes=" + Arrays.deepToString(this.parameterTypes) + "]";
        }
    }

    static enum MH_Kind {
        METHOD,
        STATIC_METHOD,
        GETTER,
        STATIC_GETTER,
        SETTER,
        STATIC_SETTER;

    }
}

