/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.rexxla.bsf.engines.rexx.InvocationType;
import org.rexxla.bsf.engines.rexx.RexxAndJava;
import org.rexxla.bsf.engines.rexx.RexxProxy;

class RexxReflectUtil {
    static final boolean bDebug = false;
    static final Object[] emptyObjArr = new Object[0];
    static final ClassLoader rruClassLoader = RexxReflectUtil.class.getClassLoader();
    String[] rexxArgs;
    Object[] funcArgs;
    RexxAndJava rajo;
    InvocationType choice;
    ReflectionType reflectionType;
    Object bean = null;
    String beanName = null;
    Class beanClz = null;
    boolean bBeanIsClass = false;
    String memberName;
    String keyMemberName;
    boolean bStrict = false;
    boolean bStatic = false;
    boolean bFieldGet = false;
    boolean bReturnJSO = false;
    boolean bOtherKind = false;
    boolean bRecursing = false;
    boolean success = false;
    Object result = null;
    Throwable throwable = null;

    RexxReflectUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RexxReflectUtil(RexxAndJava rexxAndJava, InvocationType invocationType, String[] stringArray) throws BSFException {
        this.rajo = rexxAndJava;
        this.choice = invocationType;
        this.rexxArgs = stringArray;
        this.beanName = stringArray[1];
        if (stringArray.length >= 3) {
            this.memberName = stringArray[2];
        }
        switch (invocationType) {
            case REGISTER_BEAN: 
            case REGISTER_BEAN_STRICT: {
                if (stringArray[2] == null) {
                    throw new BSFException(0, "BSF4ooRexx subfunction \"" + stringArray[0] + '\"' + ": type/class argument must not be \"null\"");
                }
                if (!(stringArray[2] instanceof String)) {
                    throw new BSFException(0, "BSF4ooRexx subfunction \"" + stringArray[0] + '\"' + ": cannot load Java class with the name \"" + stringArray[2] + "\"");
                }
                this.beanClz = RexxReflectUtil.loadClass(rexxAndJava, stringArray[0], stringArray[2]);
                this.bean = this.beanClz;
                this.bBeanIsClass = true;
                if ((this.beanClz.getModifiers() & 0x400) == 0) break;
                throw new BSFException(0, "BSF4ooRexx subfunction \"" + stringArray[0] + '\"' + ": Java class \"" + stringArray[2] + "\" is abstract; cannot be instantiated");
            }
            default: {
                this.bean = RexxAndJava.lookupBean(rexxAndJava, stringArray[1]);
                if (this.bean == null) {
                    if (stringArray[1] == null) throw new BSFException(0, "BSF4ooRexx subfunction \"" + stringArray[0] + '\"' + ": object '" + stringArray[1] + "' not registered");
                    if (stringArray[1].equals(RexxAndJava.null4Rexx)) {
                        throw new BSFException(0, "BSF4ooRexx subfunction \"" + stringArray[0] + '\"' + ": object '" + stringArray[1] + "' not registered");
                    }
                    this.bean = stringArray[1];
                }
                this.bBeanIsClass = this.bean instanceof Class;
                this.beanClz = this.bBeanIsClass ? (Class<?>)this.bean : this.bean.getClass();
            }
        }
        switch (invocationType) {
            case GET_STATIC_FIELD_VALUE_JSO: 
            case GET_STATIC_FIELD_VALUE_STRICT_JSO: 
            case GET_STATIC_FIELD_VALUE: 
            case GET_STATIC_FIELD_VALUE_STRICT: {
                this.bStatic = true;
                if (this.bBeanIsClass) break;
                if (this.bean instanceof String) {
                    this.beanClz = RexxReflectUtil.loadClass(rexxAndJava, stringArray[0], (String)this.bean);
                    this.bean = this.beanClz;
                    this.bBeanIsClass = true;
                    break;
                }
                this.beanClz = this.bean.getClass();
                this.bean = this.bean;
                this.bBeanIsClass = true;
            }
        }
        switch (invocationType) {
            case SET_FIELD_VALUE_STRICT: {
                boolean bl;
                boolean bl2 = bl = stringArray.length == 4 || stringArray[3] == null || stringArray[4] == null;
                if (bl) {
                    this.funcArgs = new Object[1];
                    this.funcArgs[0] = stringArray.length == 4 || stringArray[4] == null ? rexxAndJava.convFromRexx(stringArray[3]) : rexxAndJava.convFromRexx(stringArray[4]);
                    this.bStrict = true;
                    break;
                }
            }
            case REGISTER_BEAN_STRICT: 
            case GET_STATIC_FIELD_VALUE_STRICT_JSO: 
            case GET_STATIC_FIELD_VALUE_STRICT: 
            case GET_FIELD_VALUE_STRICT: 
            case GET_FIELD_VALUE_STRICT_JSO: 
            case INVOKE_STRICT: 
            case INVOKE_STRICT_JSO: {
                this.bStrict = true;
                Object[] objectArray = this.funcArgs = stringArray.length == 3 ? emptyObjArr : new Object[(stringArray.length - 3) / 2];
                if (stringArray.length <= 3) break;
                int n = 3;
                int n2 = 0;
                while (n < stringArray.length) {
                    this.funcArgs[n2] = rexxAndJava.convFromRexx(stringArray[n], stringArray[n + 1]);
                    n += 2;
                    ++n2;
                }
                break;
            }
            default: {
                this.funcArgs = stringArray.length == 3 ? emptyObjArr : new Object[stringArray.length - 3];
                for (int i = 3; i < stringArray.length; ++i) {
                    this.funcArgs[i - 3] = rexxAndJava.convFromRexx(stringArray[i]);
                }
            }
        }
        switch (invocationType) {
            case INVOKE_STRICT_JSO: 
            case INVOKE_JSO: {
                this.bReturnJSO = true;
            }
            case INVOKE_STRICT: 
            case INVOKE: {
                this.reflectionType = ReflectionType.REFLECT_METHOD;
                this.bStatic = this.bBeanIsClass;
                break;
            }
            case REGISTER_BEAN: 
            case REGISTER_BEAN_STRICT: {
                this.reflectionType = ReflectionType.REFLECT_CONSTRUCTOR;
                if (this.bBeanIsClass) break;
                if (!(this.bean instanceof String)) throw new BSFException(0, "BSF4ooRexx subfunction \"NEW\": supplied argument '" + this.bean + "' is neither a Java class object, nor the fully qualified name of a Java class that can be loaded");
                this.beanClz = RexxReflectUtil.loadClass(rexxAndJava, stringArray[0], (String)this.bean);
                this.bean = this.beanClz;
                this.bBeanIsClass = true;
                break;
            }
            case GET_STATIC_FIELD_VALUE_JSO: 
            case GET_STATIC_FIELD_VALUE_STRICT_JSO: 
            case GET_FIELD_VALUE_STRICT_JSO: 
            case GET_FIELD_VALUE_JSO: {
                this.bReturnJSO = true;
            }
            case GET_STATIC_FIELD_VALUE: 
            case GET_STATIC_FIELD_VALUE_STRICT: 
            case GET_FIELD_VALUE_STRICT: 
            case GET_FIELD_VALUE: {
                this.bFieldGet = true;
            }
            case SET_FIELD_VALUE_STRICT: 
            case SET_FIELD_VALUE: {
                this.reflectionType = ReflectionType.REFLECT_FIELD;
            }
        }
        this.keyMemberName = this.bStrict || invocationType == InvocationType.REGISTER_BEAN ? this.memberName : this.memberName.toUpperCase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Class loadClass(RexxAndJava rexxAndJava, String string, String string2) throws BSFException {
        Object object;
        Class<?> clazz;
        block8: {
            clazz = (Class<?>)RexxAndJava.lookupBean(rexxAndJava, string2);
            if (clazz != null) {
                return clazz;
            }
            try {
                object = Thread.currentThread().getContextClassLoader();
                if (object != null) {
                    try {
                        clazz = ((ClassLoader)object).loadClass(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (object != null && clazz != null) break block8;
                try {
                    clazz = rruClassLoader.loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new BSFException(0, "BSF4ooRexx subfunction \"" + string + "\": while attempting to load class '" + string2 + "', threw exception: [" + classNotFoundException + "]", classNotFoundException);
                }
            }
            catch (Throwable throwable) {
                throw new BSFException(500, "BSF4ooRexx subfunction \"" + string + "\": while attempting to load class '" + string2 + "', threw: [" + throwable + "]", throwable);
            }
        }
        object = RexxAndJava.makeBeanName(rexxAndJava, clazz);
        RexxAndJava.registerBean(rexxAndJava, (String)object, clazz);
        return clazz;
    }

    RexxReflectUtil copy() {
        RexxReflectUtil rexxReflectUtil = new RexxReflectUtil();
        rexxReflectUtil.rexxArgs = this.rexxArgs;
        rexxReflectUtil.funcArgs = this.funcArgs;
        rexxReflectUtil.rajo = this.rajo;
        rexxReflectUtil.choice = this.choice;
        rexxReflectUtil.reflectionType = this.reflectionType;
        rexxReflectUtil.bean = this.bean;
        rexxReflectUtil.beanName = this.beanName;
        rexxReflectUtil.beanClz = this.beanClz;
        rexxReflectUtil.bBeanIsClass = this.bBeanIsClass;
        rexxReflectUtil.memberName = this.memberName;
        rexxReflectUtil.keyMemberName = this.keyMemberName;
        rexxReflectUtil.bStrict = this.bStrict;
        rexxReflectUtil.bStatic = this.bStatic;
        rexxReflectUtil.bFieldGet = this.bFieldGet;
        rexxReflectUtil.bReturnJSO = this.bReturnJSO;
        rexxReflectUtil.bOtherKind = this.bOtherKind;
        rexxReflectUtil.bRecursing = this.bRecursing;
        rexxReflectUtil.success = this.success;
        rexxReflectUtil.result = this.result;
        rexxReflectUtil.throwable = this.throwable;
        return rexxReflectUtil;
    }

    String debugString() {
        Object[] objectArray = Arrays.copyOfRange(this.rexxArgs, 3, this.rexxArgs.length);
        return this + ", field values:\n--->\tthis            =\"" + this + "\"\n\trajo            =\"" + this.rajo + "\"\n\tchoice          =\"" + (Object)((Object)this.choice) + "\"\n\treflectionType  =\"" + (Object)((Object)this.reflectionType) + "\"\n\tbeanName        =\"" + this.beanName + "\"\n\tbean            =\"" + this.bean + "\" instanceof Class? \"" + this.bBeanIsClass + "\"\n\tbeanClz         =\"" + this.beanClz + "\"\n\tbStatic         =\"" + this.bStatic + "\"\n\tbStrict         =\"" + this.bStrict + "\"\n\tmemberName      =\"" + this.memberName + "\" keyMemberName=\"" + this.keyMemberName + "\"\n\tbFieldGet       =\"" + this.bFieldGet + "\" bOtherKind=\"" + this.bOtherKind + "\" bRecursing=\"" + this.bRecursing + "\"\n\tsuccess         =\"" + this.success + "\"\n\trexxArgs[]      =\"" + this.rexxArgs + "\", rexxArgs.length   =\"" + this.rexxArgs.length + "\": " + Arrays.toString(this.rexxArgs) + "\n\ttmpRexxArgs[]   =\"" + objectArray + "\", tmpRexxArgs.length=\"" + objectArray.length + "\": " + Arrays.toString(objectArray) + "\n\tfuncArgs[]      =\"" + this.funcArgs + (this.funcArgs == null ? null + "\"" : "\", funcArgs.length   =\"" + this.funcArgs.length + "\": " + Arrays.toString(this.funcArgs)) + "\n\tbReturnJSO      =\"" + this.bReturnJSO + "\"\n\tthrowable       =\"" + (this.throwable == null ? null : this.throwable.toString()) + "\"\n\tresult ******** =\"" + this.result + "\"\n<---\n";
    }

    void processMakearrayOrSupplier() throws BSFException {
        boolean bl = this.keyMemberName.equals("MAKEARRAY");
        BSFEngine bSFEngine = this.rajo.getRexxEngine();
        Object object = null;
        String string = "return .array~new                          \n";
        String string2 = "use arg itemArray, indexArray              \nreturn .supplier~new(itemArray,indexArray) \n::requires BSF.CLS                           ";
        if (this.bBeanIsClass) {
            if (this.beanClz.isEnum()) {
                Enum[] enumArray = (Enum[])this.beanClz.getEnumConstants();
                if (bl) {
                    RexxProxy rexxProxy = (RexxProxy)bSFEngine.apply("Invoked_by_RexxReflectUtil_Enum_01.rex", 0, 0, string, null, null);
                    for (int i = 0; i < enumArray.length; ++i) {
                        rexxProxy.sendMessage1("APPEND", enumArray[i]);
                    }
                    object = rexxProxy;
                } else {
                    RexxProxy rexxProxy = (RexxProxy)bSFEngine.apply("Invoked_by_RexxReflectUtil_Enum_02.rex", 0, 0, string, null, null);
                    RexxProxy rexxProxy2 = (RexxProxy)bSFEngine.apply("Invoked_by_RexxReflectUtil_Enum_03.rex", 0, 0, string, null, null);
                    for (int i = 0; i < enumArray.length; ++i) {
                        rexxProxy.sendMessage1("APPEND", enumArray[i]);
                        rexxProxy2.sendMessage1("APPEND", enumArray[i].ordinal());
                    }
                    Vector<RexxProxy> vector = new Vector<RexxProxy>();
                    vector.add(rexxProxy);
                    vector.add(rexxProxy2);
                    object = bSFEngine.apply("Invoked_by_RexxReflectUtil_Enum_04.rex", 0, 0, string2, null, vector);
                }
            }
        } else {
            boolean bl2 = Map.class.isInstance(this.bean);
            if (bl2 || Iterable.class.isInstance(this.bean) || Iterator.class.isInstance(this.bean) || Collection.class.isInstance(this.bean) || Enumeration.class.isInstance(this.bean)) {
                Vector<RexxProxy> vector;
                Iterator iterator = null;
                if (bl2) {
                    iterator = ((Map)this.bean).keySet().iterator();
                } else if (Iterable.class.isInstance(this.bean)) {
                    iterator = ((Iterable)this.bean).iterator();
                } else if (Iterator.class.isInstance(this.bean)) {
                    iterator = (Iterator)this.bean;
                } else if (Collection.class.isInstance(this.bean)) {
                    iterator = ((Collection)this.bean).iterator();
                }
                RexxProxy rexxProxy = (RexxProxy)bSFEngine.apply("Invoked_by_RexxReflectUtil_01.rex", 0, 0, string, null, null);
                if (bl && iterator != null || iterator != null && !bl2) {
                    while (iterator.hasNext()) {
                        rexxProxy.sendMessage1("APPEND", iterator.next());
                    }
                } else if (Enumeration.class.isInstance(this.bean)) {
                    vector = (Enumeration)this.bean;
                    while (vector.hasMoreElements()) {
                        rexxProxy.sendMessage1("APPEND", vector.nextElement());
                    }
                }
                if (bl) {
                    object = rexxProxy;
                } else if (bl2) {
                    Object object2;
                    vector = (Map)this.bean;
                    RexxProxy rexxProxy3 = (RexxProxy)bSFEngine.apply("Invoked_by_RexxReflectUtil_02.rex", 0, 0, string, null, null);
                    while (iterator.hasNext()) {
                        object2 = iterator.next();
                        rexxProxy.sendMessage1("APPEND", object2);
                        rexxProxy3.sendMessage1("APPEND", vector.get(object2));
                    }
                    object2 = new Vector();
                    ((Vector)object2).add((RexxProxy)rexxProxy3);
                    ((Vector)object2).add(rexxProxy);
                    object = bSFEngine.apply("Invoked_by_RexxReflectUtil_03.rex", 0, 0, string2, null, (Vector)object2);
                } else {
                    vector = new Vector<RexxProxy>();
                    vector.add(rexxProxy);
                    vector.add(rexxProxy);
                    object = bSFEngine.apply("Invoked_by_RexxReflectUtil_04.rex", 0, 0, string2, null, vector);
                }
            }
        }
        if (object != null) {
            this.result = object;
            this.success = true;
        }
    }

    String throwNotFoundBSFException() throws BSFException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 1;
        if (this.bStrict && this.rexxArgs.length - 3 != this.funcArgs.length) {
            n2 = 2;
        }
        for (n = 0; n < this.funcArgs.length; ++n) {
            stringBuffer.append("\t\targ # " + (n + 1) + ": ");
            if (n2 == 1) {
                stringBuffer.append("Rexx argument=[" + this.rexxArgs[3 + n] + "]");
            } else {
                int n3 = 3 + n * n2;
                stringBuffer.append("Rexx strict argument=[" + (n3 < this.rexxArgs.length ? "type" : "Rexx value") + "=\"" + this.rexxArgs[n3]);
                if (n3 < this.rexxArgs.length) {
                    stringBuffer.append("\", Rexx value=\"" + this.truncString(this.rexxArgs[3 + n * n2 + 1], 65) + "\"]");
                } else {
                    stringBuffer.append("]");
                }
            }
            stringBuffer.append(" --> Java value=\"" + this.truncString("" + this.funcArgs[n], 65) + "\" type=<" + (this.funcArgs[n] == null ? null : this.funcArgs[n].getClass().getName()) + ">\n");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("BSF4ooRexx subfunction \"" + this.rexxArgs[0] + '\"' + ": \n\tbean:        [" + this.truncObject(this.bean, 65) + "] --> type: <" + (this.beanClz == null ? null : this.beanClz.getName()) + ">\n\t" + (this.reflectionType == ReflectionType.REFLECT_METHOD ? "method:      [" : (this.reflectionType == ReflectionType.REFLECT_FIELD ? "field:       [" : "constructor")));
        if (this.reflectionType != ReflectionType.REFLECT_CONSTRUCTOR) {
            stringBuffer2.append(this.rexxArgs[2] + "]");
        }
        if (this.reflectionType == ReflectionType.REFLECT_METHOD) {
            stringBuffer2.append(" not found or execution error!");
        } else {
            stringBuffer2.append(" not found!");
        }
        if (this.bStrict) {
            stringBuffer2.append(" (Strict mode invocation");
            if (this.reflectionType != ReflectionType.REFLECT_CONSTRUCTOR) {
                stringBuffer2.append(": check the *exact* case of the " + (this.reflectionType == ReflectionType.REFLECT_FIELD ? "field" : "method") + " name.)");
            }
        }
        stringBuffer2.append('\n');
        if (this.reflectionType == ReflectionType.REFLECT_CONSTRUCTOR) {
            stringBuffer2.append("\n\t-> check name=[" + this.rexxArgs[2] + "]");
            if (this.bean instanceof Class) {
                stringBuffer2.append(" -> Java class name=<" + this.beanClz.getName() + ">");
            }
        } else {
            stringBuffer2.append("\n\t-> check " + (this.reflectionType == ReflectionType.REFLECT_FIELD ? "field" : "method") + " name=[" + this.rexxArgs[2] + "]");
        }
        stringBuffer2.append(" (" + (this.bStrict ? "" : "caseless o.k., but ") + "correct spelling?)\n");
        if (stringBuffer.length() > 0) {
            stringBuffer2.append("\t-> check supplied arguments (correct number, correct types?):\n");
            stringBuffer2.append(stringBuffer.toString());
        }
        if (this.throwable != null) {
            throw new BSFException(0, stringBuffer2.toString(), this.throwable);
        }
        throw new BSFException(0, stringBuffer2.toString());
    }

    String truncString(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() > n) {
            return string.substring(0, n - 1) + "...";
        }
        return string;
    }

    String truncObject(Object object, int n) {
        String string;
        if (object == null) {
            return null;
        }
        String string2 = string = object instanceof String ? (String)object : object.toString();
        if (string.length() > n) {
            return string.substring(0, n - 1) + "...";
        }
        return string;
    }

    static enum ReflectionType {
        REFLECT_METHOD,
        REFLECT_FIELD,
        REFLECT_CONSTRUCTOR;

    }
}

