CREATE SCHEMA "IMMODB";

CREATE COLUMN TABLE "IMMODB"."CONTACT_PERSON" (contact_person_id INT NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE, contact_info VARCHAR(100) , phone_number VARCHAR(100) ,email VARCHAR(100));

CREATE COLUMN TABLE  "IMMODB"."KEY_FIGURES" (  key_figures_id INT NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE, living_space DOUBLE NULL,  total_amount DOUBLE NULL,  operating_cost DOUBLE NULL,  heating_cost DOUBLE NULL,  deposit DOUBLE NULL,  commission NVARCHAR(200) NULL);

CREATE COLUMN TABLE "IMMODB"."ADRESS" (  adress_id INT NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE,  country VARCHAR(45) NULL,  zip_code VARCHAR(45) NULL,  street VARCHAR(100) NULL,  floor VARCHAR(45) NULL);

CREATE COLUMN TABLE  "IMMODB"."CONSUMPTION" (  consumption_id INT NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE,  hwb_value VARCHAR(100) NULL,  energy_label VARCHAR(45) NULL,  energy_typ VARCHAR(100) NULL);

CREATE COLUMN TABLE "IMMODB"."CHARACTERISTIC" (  characteristic_id INT  NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE,  balcony BOOLEAN NULL,  basement BOOLEAN NULL,  terrace BOOLEAN NULL,  parking_spot BOOLEAN NULL,  elevator BOOLEAN NULL);

CREATE COLUMN TABLE "IMMODB"."APARTMENT" (  apartment_id INT NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE,  key_figures_id INT NULL,  adress_id INT NULL,  consumption_id INT NULL,  characteristic_id INT NULL,  room_count DOUBLE NULL,  construction_year VARCHAR(100) NULL,  construction_type VARCHAR(100) NULL,  apartment_condition VARCHAR(100) NULL);
ALTER TABLE "IMMODB"."APARTMENT" ADD  FOREIGN KEY (adress_id)   REFERENCES immodb.adress(adress_id)  ON DELETE CASCADE;
ALTER TABLE "IMMODB"."APARTMENT" ADD  FOREIGN KEY (key_figures_id)   REFERENCES immodb.key_figures(key_figures_id)  ON DELETE CASCADE;
ALTER TABLE "IMMODB"."APARTMENT" ADD  FOREIGN KEY (consumption_id)   REFERENCES immodb.consumption(consumption_id)  ON DELETE CASCADE;
ALTER TABLE "IMMODB"."APARTMENT" ADD  FOREIGN KEY (characteristic_id)  REFERENCES immodb.characteristic(characteristic_id)  ON DELETE CASCADE;

CREATE COLUMN TABLE "IMMODB"."CHRONOLOGY" (  chronology_id INT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE,  ad_creation_time SECONDDATE  NULL,  entry_creation_time SECONDDATE  NULL,  available_from VARCHAR(100) NULL,  rental_period VARCHAR(100) NULL);

CREATE COLUMN TABLE "IMMODB"."DATA_SOURCE" (  data_source_id INT NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE,  source_name VARCHAR(45) NULL,  internal_id VARCHAR(45) NULL,  url VARCHAR(200) NULL);

CREATE COLUMN TABLE  "IMMODB"."AD" (  ad_id INT NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE,  title NVARCHAR(200) NULL,  contact_person_id INT NULL,  apartment_id INT NULL,  chronology_id INT NULL,  data_source_id INT NULL);
ALTER TABLE "IMMODB"."AD" ADD   FOREIGN KEY(contact_person_id)   REFERENCES immodb.contact_person(contact_person_id)   ON DELETE CASCADE;
ALTER TABLE "IMMODB"."AD" ADD   FOREIGN KEY (apartment_id)   REFERENCES immodb.apartment(apartment_id)  ON DELETE CASCADE;
ALTER TABLE "IMMODB"."AD" ADD   FOREIGN KEY (chronology_id)   REFERENCES immodb.chronology(chronology_id)  ON DELETE CASCADE;
ALTER TABLE "IMMODB"."AD" ADD   FOREIGN KEY (data_source_id)   REFERENCES immodb.data_source(data_source_id)  ON DELETE CASCADE;

CREATE COLUMN TABLE  "IMMODB"."STATISTIC" (  statistic_id INT NOT NULL GENERATED BY DEFAULT AS IDENTITY UNIQUE,  description VARCHAR(200), adress_id INT NULL,  key_figures_id INT NULL,  chronology_id INT NULL,  data_source_id INT NULL);
ALTER TABLE "IMMODB"."STATISTIC" ADD  FOREIGN KEY(adress_id)   REFERENCES immodb.adress(adress_id)   ON DELETE CASCADE;
ALTER TABLE "IMMODB"."STATISTIC" ADD  FOREIGN KEY (key_figures_id)  REFERENCES immodb.key_figures(key_figures_id)  ON DELETE CASCADE;
ALTER TABLE "IMMODB"."STATISTIC" ADD  FOREIGN KEY (chronology_id)   REFERENCES immodb.chronology(chronology_id)  ON DELETE CASCADE;
ALTER TABLE "IMMODB"."STATISTIC" ADD  FOREIGN KEY (data_source_id)   REFERENCES immodb.data_source(data_source_id)  ON DELETE CASCADE;

