--------Apache Version 2.0 license (AL2.0)----------------------------------------------------------------------------
/*
        Copyright 2021 Andreas Burgstaller

        Licensed under the Apache License, Version 2.0 (the "License");
        you may not use this file except in compliance with the License.
        You may obtain a copy of the License at

         http://www.apache.org/licenses/LICENSE-2.0

        Unless required by applicable law or agreed to in writing, software
        distributed under the License is distributed on an "AS IS" BASIS,
        WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
        See the License for the specific language governing permissions and
        limitations under the License.
*/
----------------------------------------------------------------------------------------------------------------------

-- import ressources
FileReader = bsf.import("java.io.FileReader")
FileBuffered = bsf.import("java.io.BufferedReader")
JsonArray = bsf.import("org.json.JSONArray")

-- SAP HANA Connection Information
url = "jdbc:sap://<SQL-Endpoint>"
user = "<DB-User>"
pw = "<DB-PW>"

-- connect to SAP HANA Database
conImmoDB = .sapConnection~NEW(url,user,pw)

-- get current project directory
System = bsf.import("java.lang.System")
current_folder = System~getProperty("user.dir")

-- read the ist value JSON Array from JSON File
reader = FileReader~NEW(current_folder"\output\temp_ist.json ")
bfr = FileBuffered~NEW(reader)
content = bfr~readLine()

if (content \= .nil | content \= "")THEN
    DO
        adList = JsonArray~NEW(content) -- create the JSON Array
        DO i = 0 TO (adList~length - 1) -- iterate through all JSON Entries
            adEntry = adList~get(i)
            SAY  "INSERT "adEntry~get("data_source")~get("url")

            -- get data_source JSON Object and call method for INSERT INTO
            data_source = adEntry~get("data_source")
            conImmoDB~insertIntoDATA_SOURCE(data_source~get("name"),data_source~get("internal_id"),data_source~get("url"))

            -- get chronology JSON Object and call method for INSERT INTO
            chronology = adEntry~get("chronology")
            conImmoDB~insertIntoCHRONOLOGY(chronology~get("creation_time"),chronology~get("available_from"),chronology~get("rental_period"))

            -- get contact_person JSON Object and call method for INSERT INTO
            contact_person = adEntry~get("contact_person")
            conImmoDB~insertIntoCONTACT_PERSON(contact_person~get("contact_info"),contact_person~get("phone_number"),contact_person~get("email"))

            -- get adress JSON Object and call method for INSERT INTO
            adress = adEntry~get("adress")
            conImmoDB~insertIntoADRESS(adress~get("country"),adress~get("zip_code"),adress~get("street"),adress~get("floor"))

            -- get characteristic JSON Object and call method for INSERT INTO
            characteristic = adEntry~get("characteristic")
            conImmoDB~insertIntoCHARACTERISTIC(characteristic~get("balcony"),characteristic~get("basement"),characteristic~get("terrace"),characteristic~get("parking_spot"),characteristic~get("elavator"))

            -- get key_figures JSON Object and call method for INSERT INTO
            key_figures = adEntry~get("key_figures")
            conImmoDB~insertIntoKEY_FIGURES(key_figures~get("living_space"),key_figures~get("total_amount"),key_figures~get("operating_cost"),key_figures~get("heating_cost"),key_figures~get("deposit"),key_figures~get("commission"),)

            -- get consumption JSON Object and call method INSERT INTO
            consumption = adEntry~get("consumption")
            conImmoDB~insertIntoCONSUMPTION(consumption~get("hwb_value"),consumption~get("energy_label"),consumption~get("energy_type"))

            -- get apartment JSON Object and call method for INSERT INTO
            apartment = adEntry~get("apartment")
            conImmoDB~insertIntoAPARTMENT(apartment~get("room_count"),apartment~get("construction_year"),apartment~get("construction_type"),apartment~get("condition"),)

            -- get apartment JSON Object and call method for INSERT INTO
            ad = adEntry~get("ad")
            conImmoDB~insertIntoAD(ad~get("title"))
        END
    END

-- read the statistic value JSON Array from JSON File
reader = FileReader~NEW(current_folder"\output\temp_statistic.json ")
bfr = FileBuffered~NEW(reader)
content = bfr~readLine()

if (content \= .nil | content \= "")THEN
    DO
        adList = JsonArray~NEW(content) --create the JSON Array
        DO i = 0 TO (adList~length - 1) -- iterate through all JSON Entries
            adEntry = adList~get(i)
            SAY  "INSERT "adEntry~get("data_source")~get("url")

            -- get data_source JSON Object and call method for INSERT INTO
            data_source = adEntry~get("data_source")
            conImmoDB~insertIntoDATA_SOURCE(data_source~get("name"),data_source~get("internal_id"),data_source~get("url"))

            -- get chronology JSON Object and call method for INSERT INTO
            chronology = adEntry~get("chronology")
            conImmoDB~insertIntoCHRONOLOGY(chronology~get("creation_time"),chronology~get("available_from"),chronology~get("rental_period"))

            -- get adress JSON Object and call method for INSERT INTO
            adress = adEntry~get("adress")
            conImmoDB~insertIntoADRESS(adress~get("country"),adress~get("zip_code"),adress~get("street"),adress~get("floor"))

            -- get key_figures JSON Object and call method for INSERT INTO
            key_figures = adEntry~get("key_figures")
            conImmoDB~insertIntoKEY_FIGURES(key_figures~get("living_space"),key_figures~get("total_amount"),key_figures~get("operating_cost"),key_figures~get("heating_cost"),key_figures~get("deposit"),key_figures~get("commission"),)

            -- get key_figures JSON Object and call method for INSERT INTO
            statistic = adEntry~get("statistic")
            conImmoDB~insertIntoSTATISTIC(statistic~get("description"))

        END
    END

----------------------------------------------------------------------------------------------------------------------
::REQUIRES "BSF.CLS"
----------------------------------------------------------------------------------------------------------------------

::CLASS sapConnection
    ::METHOD conn ATTRIBUTE
    ::METHOD init
        USE ARG url, dbuser, dbpw
        DriverManager = bsf.import("java.sql.DriverManager")
        self~conn = DriverManager~getConnection(url,dbuser,dbpw)
        SAY "Connected success"
        SAY "HANA Url:" url
        SAY "User: "dbuser
    ::METHOD insertIntoDATA_SOURCE
        EXPOSE conn
        USE ARG source_name, internal_id, url
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.DATA_SOURCE(SOURCE_NAME, INTERNAL_ID, URL) VALUES('"source_name"', '"internal_id"', '"url"');")
    ::METHOD insertIntoCHRONOLOGY
        EXPOSE conn
        USE ARG ad_creation_time,  available_from, rental_period
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.CHRONOLOGY(AD_CREATION_TIME, ENTRY_CREATION_TIME, AVAILABLE_FROM, RENTAL_PERIOD) VALUES('"ad_creation_time"', CURRENT_TIMESTAMP, '"available_from"', '"rental_period"') ;")
    ::METHOD insertIntoCONTACT_PERSON
        EXPOSE conn
        USE ARG contact_info , phone_number ,  email
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.CONTACT_PERSON( CONTACT_INFO ,  PHONE_NUMBER ,  EMAIL ) VALUES('"contact_info"', '"phone_number"', '"email"');")
    ::METHOD insertIntoADRESS
        EXPOSE conn
        USE ARG  country ,  zip_code ,  street ,  floor
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.ADRESS( COUNTRY ,  ZIP_CODE ,  STREET ,  FLOOR ) VALUES('"country"', '"zip_code"', '"street"', '"floor"');")
    ::METHOD insertIntoCHARACTERISTIC
        EXPOSE conn
        USE ARG balcony ,  basement ,  terrace ,  parking_spot ,  elevator
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.CHARACTERISTIC( BALCONY ,  BASEMENT ,  TERRACE ,  PARKING_SPOT ,  ELEVATOR )  VALUES("balcony", "basement", "terrace", "parking_spot", "elevator");")
    ::METHOD insertIntoKEY_FIGURES
        EXPOSE conn
        USE ARG living_space, total_amount ,  operating_cost ,  heating_cost ,  deposit ,  commission
        IF (living_space == "" | living_space == "0.00 " | living_space == 0)THEN living_space="NULL"
        IF (total_amount == "" | living_space == "0.00 " | living_space == 0)THEN total_amount="NULL"
        IF (operating_cost == "")THEN operating_cost="NULL"
        IF (heating_cost == "")THEN heating_cost="NULL"
        IF (deposit == "")THEN deposit="NULL"
        IF (commission \= "")THEN commission = SUBSTR(commission,1,200)
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.KEY_FIGURES(LIVING_SPACE, TOTAL_AMOUNT ,  OPERATING_COST ,  HEATING_COST ,  DEPOSIT ,  COMMISSION ) VALUES("living_space","total_amount", "operating_cost", "heating_cost", "deposit", '"commission"');")
    ::METHOD insertIntoCONSUMPTION
        EXPOSE conn
        USE ARG hwb_value ,  energy_label ,  energy_typ
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.CONSUMPTION( HWB_VALUE ,  ENERGY_LABEL ,  ENERGY_TYP ) VALUES('"hwb_value"', '"energy_label"', '"energy_typ"');")
    ::METHOD insertIntoSTATISTIC
            EXPOSE conn
            USE ARG description
            description = SUBSTR(description,1,100)
            stmt=conn~createStatement
            stmt~executeUpdate("INSERT INTO IMMODB.STATISTIC(DESCRIPTION, ADRESS_ID, KEY_FIGURES_ID, CHRONOLOGY_ID, DATA_SOURCE_ID) VALUES(	'"description"', 	( SELECT MAX(ADRESS_ID)FROM IMMODB.ADRESS ),	( SELECT MAX(KEY_FIGURES_ID)FROM IMMODB.KEY_FIGURES ),	( SELECT MAX(CHRONOLOGY_ID)FROM IMMODB.CHRONOLOGY ),	( SELECT MAX(DATA_SOURCE_ID)FROM IMMODB.DATA_SOURCE ));")
    ::METHOD insertIntoAPARTMENT
        EXPOSE conn
        USE ARG room_count ,   construction_year ,  construction_type ,  apartment_condition
        IF (room_count == "")THEN room_count="NULL"
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.APARTMENT( KEY_FIGURES_ID ,  ADRESS_ID ,  CONSUMPTION_ID ,  CHARACTERISTIC_ID ,  ROOM_COUNT ,  CONSTRUCTION_YEAR ,  CONSTRUCTION_TYPE ,  APARTMENT_CONDITION ) VALUES(( SELECT MAX( KEY_FIGURES_ID )	FROM  IMMODB . KEY_FIGURES ), ( SELECT MAX( ADRESS_ID )FROM  IMMODB . ADRESS ),( SELECT MAX( CONSUMPTION_ID )FROM  IMMODB . CONSUMPTION ),( SELECT MAX( CONSUMPTION_ID )FROM  IMMODB . CONSUMPTION ),"room_count",'"construction_year"','"construction_type"','"apartment_condition"');")
    ::METHOD insertIntoAD
        EXPOSE conn
        USE ARG title
        stmt=conn~createStatement
        stmt~executeUpdate("INSERT INTO IMMODB.AD( TITLE ,  CONTACT_PERSON_ID ,  APARTMENT_ID ,  CHRONOLOGY_ID ,  DATA_SOURCE_ID ) VALUES('"title"',( SELECT MAX( CONTACT_PERSON_ID )FROM  IMMODB . CONTACT_PERSON  ), ( SELECT MAX( APARTMENT_ID )FROM  IMMODB . APARTMENT  ), ( SELECT MAX( CHRONOLOGY_ID )FROM  IMMODB . CHRONOLOGY  ),( SELECT MAX( DATA_SOURCE_ID )FROM  IMMODB . DATA_SOURCE)  );")

----------------------------------------------------------------------------------------------------------------------