/*
 Copyright (c) 2006 Damien Miller <djm@mindrot.org>

 Permission to use, copy, modify, and distribute this software for any
 purpose with or without fee is hereby granted, provided that the above
 copyright notice and this permission notice appear in all copies.

 THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/
::CLASS PasswordHandler PUBLIC
::ATTRIBUTE BCrypt
::ATTRIBUTE String
::METHOD init
 EXPOSE BCrypt String
 BCrypt = bsf.import("org.springframework.security.crypto.bcrypt.BCrypt")
------------------------------------------------------------------------------------------------------------------------
::METHOD hashPassword PUBLIC
 EXPOSE BCrypt hashedPWD
 USE ARG plainPW

 salt = BCrypt~gensalt(12)
 hashedPWD =  BCrypt~hashpw(plainPW, salt)
 RETURN hashedPWD
------------------------------------------------------------------------------------------------------------------------
::METHOD checkPass
 EXPOSE BCrypt
 USE ARG plainPW, hashedPWD

 password_verified = BCrypt~checkpw(plainPW, hashedPWD)
 RETURN password_verified
------------------------------------------------------------------------------------------------------------------------
::REQUIRES "BSF.CLS"
