/*
    This Class creates and stores QR-Code-Images for the receipt, created by the POS-System
*/

::CLASS QRCodeHandler PUBLIC
::METHOD BarcodeFormat ATTRIBUTE
::METHOD BitMatrix ATTRIBUTE
::METHOD QRCodeWriter ATTRIBUTE
::METHOD MatrixToImageWriter ATTRIBUTE
::METHOD init
 EXPOSE BarcodeFormat BitMatrix QRCodeWriter MatrixToImageWriter

 BarcodeFormat = bsf.loadClass("com.google.zxing.BarcodeFormat")
 BitMatrix = bsf.import("com.google.zxing.common.BitMatrix")
 QRCodeWriter = bsf.import("com.google.zxing.qrcode.QRCodeWriter")
 MatrixToImageWriter = bsf.import("com.google.zxing.client.j2se.MatrixToImageWriter")
------------------------------------------------------------------------------------------------------------------------
::METHOD makeQRCode PUBLIC
 EXPOSE BarcodeFormat BitMatrix QRCodeWriter MatrixToImageWriter
 USE ARG text
 text = text~makeString
 CALL mkDir "QR"
 path = "QR/qr.png"
 path = .bsf~new("java.io.File", path)
 QRCodeWriter = QRCodeWriter~new
 bitMatrix = QRCodeWriter~encode(text, BarcodeFormat~QR_CODE, 300, 300)
 MatrixToImageWriter~writeToFile(bitMatrix, "PNG", path)
 RETURN .true
------------------------------------------------------------------------------------------------------------------------
::REQUIRES "BSF.CLS"
::REQUIRES "collection.rexx"


/*   License:

     ------------------------ Apache Version 2.0 license -------------------------
        Copyright (C) 2021 Manuel Schwarzer

        Licensed under the Apache License, Version 2.0 (the "License");
        you may not use this file except in compliance with the License.
        You may obtain a copy of the License at

            http://www.apache.org/licenses/LICENSE-2.0

        Unless required by applicable law or agreed to in writing, software
        distributed under the License is distributed on an "AS IS" BASIS,
        WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
        See the License for the specific language governing permissions and
        limitations under the License.
     -----------------------------------------------------------------------------
 */