/*
    This Class file manages the interaction between tables and items.
*/

::CLASS PropertyValueFactory PUBLIC
::METHOD init
 EXPOSE  propName
 USE STRICT ARG propName
------------------------------------------------------------------------------------------------------------------------
::METHOD call
 EXPOSE propName
 USE ARG o
 RETURN BsfRexxProxy(o~getValue)~send(propName)
------------------------------------------------------------------------------------------------------------------------
::CLASS Order  PUBLIC
::ATTRIBUTE orderID
::ATTRIBUTE tableNR
::ATTRIBUTE type
::METHOD init
 EXPOSE orderID tableNR type
 USE ARG ID, NR, type
 SimpleStringProperty = bsf.import("javafx.beans.property.SimpleStringProperty")

 orderID = SimpleStringProperty~new(ID)
 tableNR = SimpleStringProperty~new(NR)
 type = SimpleStringProperty~new(type)
------------------------------------------------------------------------------------------------------------------------
::CLASS OrderHandler PUBLIC
::ATTRIBUTE orderArrayList
::ATTRIBUTE rsTableViewLeft
::ATTRIBUTE rsTableColumnOID
::ATTRIBUTE rsTableColumnTNr
::ATTRIBUTE rsTableColumnRType
::METHOD init
 EXPOSE orderArrayList rsTableViewLeft rsTableColumnOID rsTableColumnTNr rsTableColumnRType
 USE ARG orderArrayList, rsTableViewLeft, rsTableColumnOID, rsTableColumnTNr, rsTableColumnRType
 rp=BSFCreateRexxProxy(self, , "javafx.event.EventHandler")
 rsTableViewLeft~setOnMouseClicked(rp)
 rsTableColumnOID~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("orderID"), ,"javafx.util.Callback"))
 rsTableColumnTNr ~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("tableNR"),  ,"javafx.util.Callback"))
 rsTableColumnRType ~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("type"),  ,"javafx.util.Callback"))
 rsTableViewLeft~setColumnResizePolicy(rsTableViewLeft~CONSTRAINED_RESIZE_POLICY)
 self ~ setItems
------------------------------------------------------------------------------------------------------------------------
::METHOD setItems
 EXPOSE rsTableViewLeft orderArrayList
 rsTableViewLeft~setItems(orderArrayList)
------------------------------------------------------------------------------------------------------------------------
::METHOD handle
 USE ARG event

 table = event~getSource
IF table~getSelectionModel~getSelectedItem <> .nil THEN DO
    item = table~getSelectionModel~getSelectedItem
    order = BsfRexxProxy(item)
    FXCollections = bsf.import("javafx.collections.FXCollections")
   .my.app~orderDetailsHandler~orderDetailsArrayList = FXCollections~observableArrayList
   .my.app~DatabaseHandler~getAllProductsArrayListByID(order~orderID~get,.my.app~orderDetailsHandler)

   .my.app~currentOrderID = order~orderID~get
   .my.app~currentTableNR = order~tableNR~get
 END
------------------------------------------------------------------------------------------------------------------------
::CLASS OrderDetails PUBLIC
::ATTRIBUTE containsID
::ATTRIBUTE PID
::ATTRIBUTE Name
::ATTRIBUTE Price
::ATTRIBUTE Status
::METHOD INIT
 EXPOSE  containsID PID Name Price Status
 USE ARG containsID, PID, Name, Price, Status

 SimpleStringProperty = bsf.import("javafx.beans.property.SimpleStringProperty")
 SimpleIntegerProperty = bsf.import("javafx.beans.property.SimpleIntegerProperty")
 SimpleFloatProperty = bsf.import("javafx.beans.property.SimpleFloatProperty")

 PID = SimpleIntegerProperty~new(PID)
 Name = SimpleStringProperty~new(Name)
 Price = SimpleFloatProperty~new(Price)
 Status = SimpleStringProperty~new(Status)
------------------------------------------------------------------------------------------------------------------------
::CLASS OrderDetailsHandler PUBLIC
::ATTRIBUTE orderDetailsArrayList
::ATTRIBUTE rsTableViewRight
::ATTRIBUTE rsTableColumnPID
::ATTRIBUTE rsTableColumnName
::ATTRIBUTE rsTableColumnPrice
::ATTRIBUTE rsTableColumnCont
::ATTRIBUTE statusArray
::METHOD INIT
 EXPOSE orderDetailsArrayList rsTableViewRight rsTableColumnPID rsTableColumnName rsTableColumnPrice rsTableColumnCont statusArray
 USE ARG orderDetailsArrayList, rsTableViewRight, rsTableColumnPID, rsTableColumnName, rsTableColumnPrice, rsTableColumnCont
 statusArray = .array~new
 statusArray[1] = "not paid"
 statusArray[2] = "pending"
 statusArray[3] = "paid"

 rp = BSFCreateRexxProxy(self,, "javafx.event.EventHandler")
 rsTableViewRight~setOnMouseClicked(rp)

 rsTableColumnPID~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("PID"), ,"javafx.util.Callback"))
 rsTableColumnName~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("Name"), ,"javafx.util.Callback"))
 rsTableColumnPrice~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("Price"), ,"javafx.util.Callback"))
 rsTableColumnCont~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("Status"), ,"javafx.util.Callback"))
 rsTableViewRight~setColumnResizePolicy(rsTableViewRight~CONSTRAINED_RESIZE_POLICY)
 self~setItems
 ------------------------------------------------------------------------------------------------------------------------
::METHOD setItems
 EXPOSE rsTableViewRight orderDetailsArrayList
 rsTableViewRight~setItems(orderDetailsArrayList)
------------------------------------------------------------------------------------------------------------------------
::METHOD addItem PUBLIC
 EXPOSE rsTableViewRight orderDetailsArrayList
 USE ARG item
 orderDetailsArrayList~add(item)
 self~setItems
------------------------------------------------------------------------------------------------------------------------
::METHOD handle
 EXPOSE statusArray
 USE ARG event

 table = event~getSource
IF table~getSelectionModel~getSelectedItem <> .nil THEN DO
    item = table~getSelectionModel~getSelectedItem
    orderDetails = BsfRexxProxy(item)
    IF orderDetails~Status~get = statusArray[1] THEN DO
        orderDetails~Status~set(statusArray[2])
        .my.app~DatabaseHandler~updateContainsStatus(statusArray[2], orderDetails~containsID)
    END
    ELSE IF orderDetails~Status~get = statusArray[2] THEN DO
         orderDetails~Status~set(statusArray[1])
        .my.app~DatabaseHandler~updateContainsStatus(statusArray[1], orderDetails~containsID)
    END
END
------------------------------------------------------------------------------------------------------------------------
::CLASS newOrderHandler PUBLIC
::ATTRIBUTE newOrderArrayList
::ATTRIBUTE newOrderTableView
::ATTRIBUTE newOrderProdID
::ATTRIBUTE newOrderName
::ATTRIBUTE newOrderPrice
::ATTRIBUTE newOrderQuantity
::METHOD init
 EXPOSE newOrderArrayList newOrderTableView newOrderProdID newOrderName newOrderPrice newOrderQuantity
 USE ARG newOrderArrayList, newOrderTableView, newOrderProdID, newOrderName, newOrderPrice, newOrderQuantity
 rp=BSFCreateRexxProxy(self, "javafx.beans.value.ChangeListener", "javafx.event.EventHandler")
 newOrderTableView~setOnMouseClicked(rp)
 newOrderProdID~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("id"), ,"javafx.util.Callback"))
 newOrderName ~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("name"),  ,"javafx.util.Callback"))
 newOrderPrice ~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("price"),  ,"javafx.util.Callback"))
 newOrderQuantity ~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("quantity"),  ,"javafx.util.Callback"))
 newOrderTableView~setColumnResizePolicy(newOrderTableView~CONSTRAINED_RESIZE_POLICY)
 self ~ setItems
------------------------------------------------------------------------------------------------------------------------
::METHOD setItems
 EXPOSE newOrderTableView newOrderArrayList
 newOrderTableView~setItems(newOrderArrayList)
------------------------------------------------------------------------------------------------------------------------
::METHOD handle
 USE ARG event

 table = event~getSource
IF table~getSelectionModel~getSelectedItem <> .nil THEN DO
    item = table~getSelectionModel~getSelectedItem
    product = BsfRexxProxy(item)
    newOrderDetails = .newOrderDetails~new(product~id~get, product~name~get, 1)
    item = findItemNewOrderDetails(newOrderDetails)
    IF item = .nil THEN DO
        IF product~quantity~get >= 1 THEN DO
            call addNewOrderDetails newOrderDetails  -- if the product isnt already in Order, add it
            .my.app~DatabaseHandler~removeProductQuantity(product~id~get)
        END
        ELSE DO
            .my.app~stageHandler~showErrorWindow("Availability Error","Not enough quantity available!","ERROR")
        END
    END
    ELSE DO
        enough = incrementQuantityUntilQuant(item, product~quantity~get) -- if the product (item) is already there, increment its quantity
        IF enough == .false THEN DO
            .my.app~stageHandler~showErrorWindow("Availability Error","Not enough quantity available!","ERROR")
        END
        ELSE DO
            .my.app~DatabaseHandler~removeProductQuantity(product~id~get) --FEHLERQUELLE DENK ICH, bin mir ned sicher
        END
    END
END
------------------------------------------------------------------------------------------------------------------------
::CLASS newOrderDetails PUBLIC
::ATTRIBUTE PID
::ATTRIBUTE Name
::ATTRIBUTE Quantity
::METHOD init
 EXPOSE  PID Name Quantity
 USE ARG PID, Name, Quantity

 SimpleStringProperty = bsf.import("javafx.beans.property.SimpleStringProperty")
 SimpleIntegerProperty = bsf.import("javafx.beans.property.SimpleIntegerProperty")

 PID = SimpleIntegerProperty~new(PID)
 Name = SimpleStringProperty~new(Name)
 Quantity = SimpleIntegerProperty~new(Quantity)
------------------------------------------------------------------------------------------------------------------------
::CLASS newOrderDetailsHandler PUBLIC
::ATTRIBUTE newOrderDetailsArrayList
::ATTRIBUTE newOrderOrderTableView
::ATTRIBUTE newOrderOrderProdID
::ATTRIBUTE newOrderOrderProdName
::ATTRIBUTE newOrderOrderProdQuant
::METHOD init
 EXPOSE newOrderDetailsArrayList newOrderOrderTableView newOrderOrderProdID newOrderOrderProdName newOrderOrderProdQuant
 USE ARG newOrderDetailsArrayList, newOrderOrderTableView, newOrderOrderProdID, newOrderOrderProdName, newOrderOrderProdQuant
 rp=BSFCreateRexxProxy(self, , "javafx.event.EventHandler")
 newOrderOrderTableView~setOnMouseClicked(rp)
 newOrderOrderProdID~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("PID"), ,"javafx.util.Callback"))
 newOrderOrderProdName ~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("Name"),  ,"javafx.util.Callback"))
 newOrderOrderProdQuant ~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("Quantity"),  ,"javafx.util.Callback"))
 newOrderOrderTableView~setColumnResizePolicy(newOrderOrderTableView~CONSTRAINED_RESIZE_POLICY)
 self~setItems
------------------------------------------------------------------------------------------------------------------------
::METHOD setItems
 EXPOSE newOrderOrderTableView newOrderDetailsArrayList
 newOrderOrderTableView~setItems(newOrderDetailsArrayList)
------------------------------------------------------------------------------------------------------------------------
::METHOD addItem PUBLIC
 EXPOSE newOrderOrderTableView newOrderDetailsArrayList
 USE ARG item
 newOrderDetailsArrayList~add(item) --bridge for tableView
 self~setItems
------------------------------------------------------------------------------------------------------------------------
::METHOD handle
 USE ARG event

 table = event~getSource
IF table~getSelectionModel~getSelectedItem <> .nil THEN DO
    item = table~getSelectionModel~getSelectedItem
    product = BsfRexxProxy(item)
    quantity = product~quantity~get
    IF quantity > 1 THEN DO
        product~quantity~set(quantity-1)
    END
    ELSE DO
        table~getItems~remove(item)
    END
    .my.app~DatabaseHandler~addProductQuantity(product~PID~get)
 END
------------------------------------------------------------------------------------------------------------------------
::CLASS Product PUBLIC
::ATTRIBUTE id
::ATTRIBUTE name
::ATTRIBUTE price
::ATTRIBUTE tax
::ATTRIBUTE quantity
::ATTRIBUTE lunchInd
::METHOD init
 EXPOSE id name price tax quantity lunchInd
 USE ARG id, name, price, tax, quantity, lunchInd

 SimpleStringProperty = bsf.import("javafx.beans.property.SimpleStringProperty")
 SimpleIntegerProperty = bsf.import("javafx.beans.property.SimpleIntegerProperty")

 id = SimpleStringProperty~new(id)
 name = SimpleStringProperty~new(name)
 price = SimpleStringProperty~new(price)
 tax = SimpleStringProperty~new(tax)
 quantity = SimpleStringProperty~new(quantity)
 lunchInd = SimpleStringProperty~new(lunchInd)
------------------------------------------------------------------------------------------------------------------------
::CLASS ProductHandler PUBLIC
::ATTRIBUTE productArrayList
::ATTRIBUTE prodTableView
::ATTRIBUTE prodIDColumn
::ATTRIBUTE prodNameColumn
::ATTRIBUTE prodPriceColumn
::ATTRIBUTE prodTaxColumn
::ATTRIBUTE prodQuantColumn
::ATTRIBUTE prodLunchColumn
::METHOD init
 EXPOSE productArrayList prodTableView prodIDColumn prodNameColumn prodPriceColumn prodTaxColumn prodQuantColumn prodLunchColumn
 USE ARG productArrayList, prodTableView, prodIDColumn, prodNameColumn, prodPriceColumn, prodTaxColumn, prodQuantColumn, prodLunchColumn
 rp = BSFCreateRexxProxy(self,, "javafx.event.EventHandler")
 prodTableView~setOnMouseClicked(rp)
 prodIDColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("id"), ,"javafx.util.Callback"))
 prodNameColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("name"), ,"javafx.util.Callback"))
 prodPriceColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("price"), ,"javafx.util.Callback"))
 prodQuantColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("quantity"), ,"javafx.util.Callback"))
 prodTaxColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("tax"), ,"javafx.util.Callback"))
 prodLunchColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("lunchInd"), ,"javafx.util.Callback"))
 prodTableView~setColumnResizePolicy(prodTableView~CONSTRAINED_RESIZE_POLICY)
 self~setItems
------------------------------------------------------------------------------------------------------------------------
::METHOD setItems
 EXPOSE prodTableView productArrayList
 prodTableView~setItems(productArrayList)
------------------------------------------------------------------------------------------------------------------------
::METHOD handle
 USE ARG event
 table = event~getSource
IF table~getSelectionModel~getSelectedItem <> .nil THEN DO
    product = table~getSelectionModel~getSelectedItem
    product = BsfRexxProxy(product)
END
------------------------------------------------------------------------------------------------------------------------
::CLASS User  PUBLIC                     -- for database adding
::ATTRIBUTE userID
::ATTRIBUTE firstName
::ATTRIBUTE lastName
::ATTRIBUTE userName
::ATTRIBUTE password
::ATTRIBUTE rightsIndex
::METHOD init
 EXPOSE userID firstName lastName userName password rightsIndex
 USE ARG userID, fName, lName, uName, password, rightInd
 SimpleStringProperty = bsf.import("javafx.beans.property.SimpleStringProperty")

 userID = SimpleStringProperty~new(userID)
 firstName = SimpleStringProperty~new(fName)
 lastName = SimpleStringProperty~new(lName)
 userName = SimpleStringProperty~new(uName)
 password = SimpleStringProperty~new(password)
 rightsIndex = SimpleStringProperty~new(rightInd)
------------------------------------------------------------------------------------------------------------------------
::CLASS UserHandler PUBLIC
::ATTRIBUTE usersArrayList
::ATTRIBUTE userTableView
::ATTRIBUTE userIDColumn
::ATTRIBUTE userFNameColumn
::ATTRIBUTE userLNameColumn
::ATTRIBUTE userUNameColumn
::ATTRIBUTE userPasswordColumn
::ATTRIBUTE userRightsColumn
::METHOD init
 EXPOSE usersArrayList userTableView userIDColumn userFNameColumn userLNameColumn userUNameColumn userPasswordColumn userRightsColumn
 USE ARG usersArrayList, userTableView, userIDColumn, userFNameColumn, userLNameColumn, userUNameColumn, userPasswordColumn, userRightsColumn

 rp = BSFCreateRexxProxy(self,, "javafx.event.EventHandler")
 userTableView~setOnMouseClicked(rp)
 userIDColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("userID"), ,"javafx.util.Callback"))
 userFNameColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("firstName"), ,"javafx.util.Callback"))
 userLNameColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("lastName"), ,"javafx.util.Callback"))
 userUNameColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("userName"), ,"javafx.util.Callback"))
 userPasswordColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("password"), ,"javafx.util.Callback"))
 userRightsColumn~setCellValueFactory(BsfCreateRexxProxy(.PropertyValueFactory~new("rightsIndex"), ,"javafx.util.Callback"))
 userTableView~setColumnResizePolicy(userTableView~CONSTRAINED_RESIZE_POLICY)
 self~setItems
------------------------------------------------------------------------------------------------------------------------
::METHOD setItems
 EXPOSE userTableView usersArrayList
 userTableView~setItems(usersArrayList)
------------------------------------------------------------------------------------------------------------------------
::METHOD handle
 USE ARG event

 table = event~getSource
IF table~getSelectionModel~getSelectedItem <> .nil THEN DO
    product = table~getSelectionModel~getSelectedItem
    product = BsfRexxProxy(product)
END
------------------------------------------------------------------------------------------------------------------------
::REQUIRES "DatabaseHandler_v2.CLS"
::REQUIRES "BSF.CLS"
::REQUIRES "collection.rexx"

/*   License:

     ------------------------ Apache Version 2.0 license -------------------------
        Copyright (C) 2021 Manuel Schwarzer

        Licensed under the Apache License, Version 2.0 (the "License");
        you may not use this file except in compliance with the License.
        You may obtain a copy of the License at

            http://www.apache.org/licenses/LICENSE-2.0

        Unless required by applicable law or agreed to in writing, software
        distributed under the License is distributed on an "AS IS" BASIS,
        WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
        See the License for the specific language governing permissions and
        limitations under the License.
     -----------------------------------------------------------------------------
 */