/*
    This file is some sort of library. The most used ::ROUTINES can be found here.
*/
::ROUTINE formatToEuro PUBLIC
 USE ARG turnoverValue
 turnoverValue = "EUR: " ||  format2float(turnoverValue)
 RETURN turnoverValue
------------------------------------------------------------------------------------------------------------------------
::ROUTINE reformatEUR PUBLIC
 USE ARG turnoverValue
 PARSE VAR turnoverValue "EUR: " value
 RETURN value
------------------------------------------------------------------------------------------------------------------------
::ROUTINE addNewOrderDetails PUBLIC
 USE ARG newOrderDetails
 .my.app~newOrderDetailsHandler~addItem(newOrderDetails)
------------------------------------------------------------------------------------------------------------------------
::ROUTINE findItemNewOrderDetails PUBLIC
 USE ARG newOrderDetails
DO item OVER .my.app~newOrderDetailsHandler~newOrderOrderTableView~getItems
    IF item~PID~get == newOrderDetails~PID~get THEN DO
        RETURN item
    END
END
 RETURN .nil
------------------------------------------------------------------------------------------------------------------------
::ROUTINE incrementQuantityUntilQuant PUBLIC
 USE ARG item, quantity
 quantity = quantity -1
 SimpleIntegerProperty = bsf.import("javafx.beans.property.SimpleIntegerProperty")
 sum = item~quantity~getValue
 quantity = box("INTeger", quantity)
 tempSum = box("INTeger", sum)
IF tempSum~toString <= quantity~toString THEN DO
    sum = item~quantity~add(SimpleIntegerProperty~new(1))
    item~quantity~set(sum~getValue)
    RETURN .true
END
ELSE
    RETURN .false
------------------------------------------------------------------------------------------------------------------------
::ROUTINE updateTurnoverValue PUBLIC
 USE ARG  updateValue,typeOfReceipt, companyID = 1
 oldTurnoverValue = .my.app~DatabaseHandler~getTurnoverValue(companyID)
IF typeOfReceipt = "Normal" THEN DO
    newValue = oldTurnoverValue + updateValue
    .my.app~DatabaseHandler~updateTurnoverValue(companyID, newValue)
END
IF typeOfReceipt = "Storno" THEN DO
    newValue = oldTurnoverValue - updateValue
    .my.app~DatabaseHandler~updateTurnoverValue(companyID, newValue)
END
------------------------------------------------------------------------------------------------------------------------
::ROUTINE encrypteTurnoverTraSto PUBLIC
 USE ARG TraOrSto
 Base64 = bsf.import("java.util.Base64")
 Encoder = Base64~getEncoder
 turnoverValue = TraOrSto
 turnoverValueString = box("STring", turnoverValue)
 encryptedTurnOverValueInB64 = turnoverValueString~getBytes
 encryptedTurnOverValueInB64= Encoder~encodeToString(encryptedTurnOverValueInB64)
 RETURN encryptedTurnOverValueInB64
------------------------------------------------------------------------------------------------------------------------
::ROUTINE print PUBLIC
 USE ARG string
 jEditorPane = .bsf~new("javax.swing.JEditorPane")
 htmlEditorKit = .bsf~new("javax.swing.text.html.HTMLEditorKit")
 jEditorPane~setEditorKit(htmlEditorKit)
 styleSheet = htmlEditorKit~getStyleSheet
 styleSheet~addRule("body {font-size: 7px;}")
 styleSheet~addRule("h1 {font-size: 11px;}")
 styleSheet~addRule("h2 {font-size: 10px;}")
 defaultDocument = htmlEditorKit~createDefaultDocument
 jEditorPane~setDocument(defaultDocument)
 jEditorPane~setText(string)
 RETURN jEditorPane~print
------------------------------------------------------------------------------------------------------------------------
::ROUTINE payProcess PUBLIC
 USE ARG  rsTableViewLeft, rsTableViewRight, splitPay
 companyDetails = .my.app~DatabaseHandler~getCompanyData(1)
 AESHandler = .AESHandler~new

IF .my.app~SEHandler = .nil & .my.app~SEHandlerOffline = .nil THEN DO
    .my.app~stageHandler~showErrorWindow("Security Device Failure", "Please login or choose offline signing","ERROR")
    .my.app~stageHandler~newWindow("Please login or choose offline","file:se_login.fxml")
END
ELSE IF .my.app~SEHandler <> .nil THEN DO
    seLoginTime = .my.app~DatabaseHandler~getSELoginTime
    seIsOut = .my.app~SEHandler~seIsOut
    IF seIsOut THEN DO
        .my.app~stageHandler~showErrorWindow("Remote signing does not work","Connection to security device failed. Check your internet connection or choose offline signing","ERROR")
        .my.app~stageHandler~newWindow("Please login","file:se_login.fxml")
    END
    ELSE IF time < seLoginTime | seLoginTime = .nil  THEN DO
        .my.app~stageHandler~newWindow("Timer run out. Please login again","file:se_login.fxml")
    END
    zertSerienNr = .my.app~SEHandler~zertSerienNr_value
END
ELSE IF .my.app~SEHandlerOffline <> .nil THEN DO
    zertSerienNr = .my.app~SEHandlerOffline~getCertNr
END

IF .my.app~offPay = .true | .my.app~remotePay = .true THEN DO
    IF .my.app~offPay = .true THEN DO
        zda = .my.app~SEHandlerOffline~getZDA
    END
    IF .my.app~remotePay = .true THEN DO
        zda = .my.app~SEHandler~getZDAData
     END


    TypeOfReceipt = .my.app~DatabaseHandler~getTypeOfReceipt(.my.app~currentOrderID)

    TableForTax = .table~new
    TableForTax["0.20"] = .array~new
    TableForTax["0.19"] = .array~new
    TableForTax["0.13"] = .array~new
    TableForTax["0.10"] = .array~new
    TableForTax["0.00"] = .array~new

    IF splitPay = .true THEN DO
        say ".my.app~currentTableNR" .my.app~currentTableNR
        .my.app~DatabaseHandler~insertOrder(.my.app~currentTableNR, TypeOfReceipt)
        tempID = .my.app~DatabaseHandler~getLastOrderID

    END
    ELSE DO
        tempID = .my.app~currentOrderID
    END

    productNames = .array~new
    productPrices = .array~new
    productQuantities = .array~new
    DO item over rsTableViewRight~getItems
        IF item~status~get = .my.app~OrderDetailsHandler~statusArray[2] & splitPay  THEN DO
            .my.app~DatabaseHandler~getAllProductsArrayListByID(tempID, .my.app~orderDetailsHandler)
            IF productNames~hasItem(item~name~get) THEN DO
                productQuantities[productNames~index(item~name~get)] = productQuantities[productNames~index(item~name~get)] + 1
            END
            ELSE DO
                productNames        ~append(item~name~get)
                productPrices       ~append(item~price~get)
                productQuantities   ~append(1)
            END
            taxRate = .my.app~DatabaseHandler~getTaxRateByProdID(item~PID~get)
            SELECT
                WHEN taxRate = 0.20 THEN TableForTax["0.20"]~append(item~price~get)
                WHEN taxRate = 0.19 THEN TableForTax["0.19"]~append(item~price~get)
                WHEN taxRate = 0.13 THEN TableForTax["0.13"]~append(item~price~get)
                WHEN taxRate = 0.00 THEN TableForTax["0.00"]~append(item~price~get)
                WHEN taxRate = 0.10 THEN TableForTax["0.10"]~append(item~price~get)
            END
            .my.app~DatabaseHandler~updateContainsStatus(.my.app~OrderDetailsHandler~statusArray[3],item~containsID)
        END

        IF splitPay <> .true THEN DO    -- FullPay
            IF productNames~hasItem(item~name~get) THEN DO
                productQuantities[productNames~index(item~name~get)] = productQuantities[productNames~index(item~name~get)] + 1
            END
            ELSE DO
                productNames        ~append(item~name~get)
                productPrices       ~append(item~price~get)
                productQuantities   ~append(1)
            END
            rsTableViewRight~getItems~remove(item)
            .my.app~DatabaseHandler~updateContainsStatus(.my.app~OrderDetailsHandler~statusArray[3],item~containsID)
            taxRate = .my.app~DatabaseHandler~getTaxRateByProdID(item~PID~get)
            SELECT
                WHEN taxRate = 0.20 THEN TableForTax["0.20"]~append(item~price~get)
                WHEN taxRate = 0.19 THEN TableForTax["0.19"]~append(item~price~get)
                WHEN taxRate = 0.13 THEN TableForTax["0.13"]~append(item~price~get)
                WHEN taxRate = 0.00 THEN TableForTax["0.00"]~append(item~price~get)
                WHEN taxRate = 0.10 THEN TableForTax["0.10"]~append(item~price~get)
            END
        END
    END

    .my.app~orderHandler~orderArrayList=.my.app~DatabaseHandler~getAllOpenOrders
    .my.app~orderHandler~setItems
    rsTableViewRight~getItems~clear
    sumTablePerTaxRate = .table~new
    formattedSumTablePerTaxRate = .table~new
    sum = 0
    DO index OVER TableForTax
        sumPerTaxRate = sum(TableForTax[index])
        sumTablePerTaxRate[index] = sumPerTaxRate
        formattedSumTablePerTaxRate[index] = reformatFloat(sumPerTaxRate)
        sum += sumPerTaxRate
    END
    totalSum = 0
    DO i = 1 TO productPrices~items
        totalSum = totalSum + (productPrices[i]*productQuantities[i])
    END


    date = .my.app~DatabaseHandler~getDatePayment(tempID)

    PARSE VAR date year " " time
    dateWithT = year || "T" || time
    previousJWScompact = .my.app~databaseHandler~getLastJWSData

    IF previousJWScompact = .nil THEN DO
        sigVorigerBeleg = AESHandler~hashLastReceipt(companyDetails["cashbox_ID"])
    END
    ELSE DO
        sigVorigerBeleg = AESHandler~hashLastReceipt(previousJWScompact)
    END

    taxOrderForSignature = .array~of("0.20", "0.10", "0.13", "0.00", "0.19")
    sigData = .mutableBuffer~new
    sigData~append("_R1-" || zda || "_" || companyDetails["cashbox_ID"] || "_" || tempID || "_"|| dateWithT )

    IF TypeOfReceipt = "Normal" THEN DO
        CALL updateTurnoverValue totalSum, TypeOfReceipt
        turnoverValue = .my.app~DatabaseHandler~getTurnoverValue(companyDetails["company_ID"])
        turnoverValue = format((turnoverValue*100),,0)
        encryptedTurnOverValueInB64 = AESHandler~encryptAES(turnoverValue, companyDetails["aes256key"], companyDetails["cashbox_ID"], tempID)
        DO index OVER taxOrderForSignature
            sigData~append("_" || formattedSumTablePerTaxRate[index])
        END
        sigData~append("_" || encryptedTurnOverValueInB64 || "_" || zertSerienNr || "_" || sigVorigerBeleg)
    END

    IF TypeOfReceipt = "Null" THEN DO
        turnoverValue =.my.app~DatabaseHandler~getTurnoverValue(companyDetails["company_ID"])
        turnoverValue = format((turnoverValue*100),,0)
        encryptedTurnOverValueInB64 = AESHandler~encryptAES(turnoverValue, companyDetails["aes256key"], companyDetails["cashbox_ID"], tempID)
        DO index OVER taxOrderForSignature
            sigData~append("_" || "0,00")
        END
        sigData~append("_" || encryptedTurnOverValueInB64 || "_" || zertSerienNr || "_" || sigVorigerBeleg)
    END

    IF TypeOfReceipt = "Start" THEN DO
        turnoverValue =.my.app~DatabaseHandler~getTurnoverValue(companyDetails["company_ID"])
        encryptedTurnOverValueInB64 = AESHandler~encryptAES(turnoverValue, companyDetails["aes256key"], companyDetails["cashbox_ID"], tempID)
        DO index OVER taxOrderForSignature
            sigData~append("_" || "0,00")
        END
        sigData~append("_" || encryptedTurnOverValueInB64 || "_" || zertSerienNr || "_" || sigVorigerBeleg)
    END

    IF TypeOfReceipt = "Training" THEN DO
        encryptedTurnOverValueInB64 = encrypteTurnoverTraSto("TRA")
        DO index OVER taxOrderForSignature
            sigData~append("_" || formattedSumTablePerTaxRate[index])
        END
        sigData~append("_" || encryptedTurnOverValueInB64 || "_" || zertSerienNr || "_" || sigVorigerBeleg)
    END

    IF TypeOfReceipt = "Storno" THEN DO
        encryptedTurnOverValueInB64 = encrypteTurnoverTraSto("STO")
        CALL updateTurnoverValue totalSum, TypeOfReceipt
        DO index OVER taxOrderForSignature
            sigData~append("_" || formattedSumTablePerTaxRate[index])
        END
        sigData~append("_" || encryptedTurnOverValueInB64 || "_" || zertSerienNr || "_" || sigVorigerBeleg)
    END

    IF .my.app~offPay =.true THEN DO
        newJWSforReceiptAndDB = .my.app~SEHandlerOffline~signString(sigData)
        sigZert_value = .my.app~SEHandlerOffline~zertValue
    END
    IF .my.app~remotePay =.true THEN DO
        newJWSforReceiptAndDB = .my.app~SEHandler~getJWS(.my.app~SEHandler~alg_value, sigData)
        sigZert_value =  .my.app~SEHandler~sigZert_value
    END
    PARSE VAR newJWSforReceiptAndDB newJWSHeader newJWSPayload newJWSSignature
    .my.app~DatabaseHandler~updateOrderJWS(tempID,newJWSHeader,newJWSPayload,newJWSSignature )
    qrData = .mutableBuffer~new
    QRCodeHandler = .QRCodeHandler~new
    qrData = sigData
    qrData~append("_" || encodeB64URLtoB64(newJWSSignature))
    QRCodeHandler~makeQRCode(qrData)
    CALL saveDEPExport sigZert_value, date, newJWSHeader, newJWSPayload, newJWSSignature
    .my.app~stageHandler~backToRoot
    CALL printingReceipt companyDetails, productNames, productPrices, productQuantities, totalSum, sumTablePerTaxRate, tempID, .my.app~currentTableNR, date
END
------------------------------------------------------------------------------------------------------------------------
::CLASS ActiveUser PUBLIC
::ATTRIBUTE userID
::ATTRIBUTE firstname
::ATTRIBUTE lastname
::ATTRIBUTE rightsInd
::METHOD init
 EXPOSE userID firstname lastname rightsInd
 USE ARG userID, firstname, lastname, rightsInd
------------------------------------------------------------------------------------------------------------------------
::CLASS ReceiptDEP PUBLIC
::METHOD init
 EXPOSE certificate jws_header jws_payload jws_signature
 USE ARG certificate, jws_header, jws_payload, jws_signature

 certificate = .fx.SimpleStringProperty~new(certificate)
 jws_header = .fx.SimpleStringProperty~new(jws_header)
 jws_payload = .fx.SimpleStringProperty~new(jws_payload)
 jws_signature = .fx.SimpleStringProperty~new(jws_signature)

::ATTRIBUTE certificate GET
 EXPOSE certificate
 RETURN certificate~get

::ATTRIBUTE certificate SET
 EXPOSE certificate
 USE ARG val
 RETURN certificate~set(val)

::ATTRIBUTE certificateProperty GET
 EXPOSE certificate
 RETURN certificate

::ATTRIBUTE jws_header GET
 EXPOSE jws_header
 RETURN jws_header~get

::ATTRIBUTE jws_header SET
 EXPOSE jws_header
 USE ARG val
 RETURN jws_header~set(val)

::ATTRIBUTE jws_headerProperty GET
 EXPOSE jws_header
 RETURN jws_header

::ATTRIBUTE jws_payload GET
 EXPOSE jws_payload
 RETURN jws_payload~get

::ATTRIBUTE jws_payload SET
 EXPOSE jws_payload
 USE ARG val
 RETURN jws_payload~set(val)

::ATTRIBUTE jws_payloadProperty GET
 EXPOSE jws_payload
 RETURN jws_payload

::ATTRIBUTE jws_signature GET
 EXPOSE jws_signature
 RETURN jws_signature~get

::ATTRIBUTE jws_signature SET
 EXPOSE jws_signature
 USE ARG val
 RETURN jws_signature~set(val)

::ATTRIBUTE jws_signatureProperty GET
 EXPOSE jws_signature
 RETURN jws_signature
------------------------------------------------------------------------------------------------------------------------
::ROUTINE sum
 USE ARG array
 sum = 0
 DO i OVER array
   sum += i
 END
 RETURN sum
------------------------------------------------------------------------------------------------------------------------
::ROUTINE exportDEP PUBLIC
 receiptArrayList = .my.app~databasehandler~getDEP
 item = receiptArrayList~get(1)
 receipt = BSFRexxProxy(item)
 certificate_one =  receipt~certificate

 FXCollections = bsf.import("javafx.collections.FXCollections")
 FileWriter = bsf.import("java.io.FileWriter")

 value1 = "MIIEATCCAumgAwIBAgIEOWntwTANBgkqhkiG9w0BAQUFADCBlTELMAkGA1UEBhMCQVQxSDBGBgNVBAoMP0EtVHJ1c3QgR2VzLiBmLiBTaWNoZXJoZWl0c3N5c3RlbWUgaW0gZWxla3RyLiBEYXRlbnZlcmtlaHIgR21iSDEdMBsGA1UECwwUQS1UcnVzdC1UZXN0LVF1YWwtMDIxHTAbBgNVBAMMFEEtVHJ1c3QtVGVzdC1RdWFsLTAyMB4XDTE0MTEyNDE0NDkxN1oXDTI0MTExODEzNDkxN1owgaExCzAJBgNVBAYTAkFUMUgwRgYDVQQKDD9BLVRydXN0IEdlcy4gZi4gU2ljaGVyaGVpdHNzeXN0ZW1lIGltIGVsZWt0ci4gRGF0ZW52ZXJrZWhyIEdtYkgxIzAhBgNVBAsMGmEtc2lnbi1QcmVtaXVtLVRlc3QtU2lnLTAyMSMwIQYDVQQDDBphLXNpZ24tUHJlbWl1bS1UZXN0LVNpZy0wMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANwJSfWpRaziThddTTup72CltlXl8oc7HQoK2SWsYQwZGAd5nJZbwbI4K8VFKlNnK72Zl8UhmQ2FxhzS6u+Q+qEzJOM2xTfA2NB6A9/KFpTJXUjvCHgRvW16EEF9YpYXxKTSK+QrYCXAC5rL6SuYOzgA7Q1ivq+zLbyXxroux2zVEBIiaBGpZhOHGDFJk6h/4QelIqzd2TIDCRzvhmLDVmhqX2C1NQb5kZuMgrxxOhG5Cr1F8solkwyu43JiM+apY4bZJVQBwi9ATBMz5tfdoLRslQy1BCQ4X+b6u/2856gucU+1e/wa5pB9Ff0eP+xy+j2DZOXLNd8m/IQvnshjNusCAwEAAaNLMEkwDwYDVR0TAQH/BAUwAwEB/zARBgNVHQ4ECgQIRgafjkGOFb0wEwYDVR0jBAwwCoAIQg8xWXA9iecwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3DQEBBQUAA4IBAQBq/owq5eGvhxegchLvnMjPnE9gTYIHEvMq8DN6h2J7pTEhKG2o09LLn/pNHWRjKENU/LqZBIAJ5zebm5XqzB631BYcuu1abyPFfpMdAL9X4zFuDvg9EGaTir2c81XaBYzVSLN7fxmNLKSmMwUt0JQQyqpe3V9iyoBE/WcQyKmKaEp7mCZsGFBm6KmJgqD6TPb7X9bWUr3yx6Z5gek71f3vQi69m1x811azXlxu1i/XFnVpzxkrKRXJWC+wnQRxXmU7YnMzYPOA7UOpUG6J+7tYi29hY3EpMgyXM/T/BL5MdyzBefbPVzLHng5zVaXNpO0ENCrlUyi1m3Yd/7QPDdJM"
 value2 = "MIID4DCCAsigAwIBAgIEOWntvzANBgkqhkiG9w0BAQUFADCBlTELMAkGA1UEBhMCQVQxSDBGBgNVBAoMP0EtVHJ1c3QgR2VzLiBmLiBTaWNoZXJoZWl0c3N5c3RlbWUgaW0gZWxla3RyLiBEYXRlbnZlcmtlaHIgR21iSDEdMBsGA1UECwwUQS1UcnVzdC1UZXN0LVF1YWwtMDIxHTAbBgNVBAMMFEEtVHJ1c3QtVGVzdC1RdWFsLTAyMB4XDTE0MTEyNDE0NDc0N1oXDTI0MTExODEzNDc0N1owgZUxCzAJBgNVBAYTAkFUMUgwRgYDVQQKDD9BLVRydXN0IEdlcy4gZi4gU2ljaGVyaGVpdHNzeXN0ZW1lIGltIGVsZWt0ci4gRGF0ZW52ZXJrZWhyIEdtYkgxHTAbBgNVBAsMFEEtVHJ1c3QtVGVzdC1RdWFsLTAyMR0wGwYDVQQDDBRBLVRydXN0LVRlc3QtUXVhbC0wMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANMBok2fNNtIEcf7Sw47vprkUeti6Y64Rc5rrAjh7cGwo4Jp5LyfvEVdv9AMNiuOX7ywd1xW99UZWtZ8MzXvWM5M6trLkeBYnCukwc9DqawXcuXXCYwgTuisFTmYO6GVJNr1iE/LJdSKbu5AVDS3FwXixqyJkjv/xWIwU4q86oATW8++8wb6Lu+fQlhBbn3Kqpavt6K+lwWSCb+8vIhB47IlKhJZwGqXfGV9l9dDgKYUbZiv3BBa+MRBUTvIcahEKz8hG2E8W4EgCwzISMpeStJtRHo/tJnA90KfSBTcz0txrxpHwqFgKwJvgW6nIjY1Sv5MfY5YJiEWv0d7UUkvlScCAwEAAaM2MDQwDwYDVR0TAQH/BAUwAwEB/zARBgNVHQ4ECgQIQg8xWXA9iecwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3DQEBBQUAA4IBAQApqSvkQyfbO2yDWewHwo1Zl32uGz41KMP5FYtA3BIcqh89paHwrW9KfcrybdUIneVz4iSnpyrDrS4LavfP8h/Hl1kRmVZRUBsOJRvqc1fiC2B6IJRHrmayb/DbXuyoOsk7Sr8M9xtAD3SzJCRkBrtjz/U/xQdU9TfV9SQyPN3qI+SR25/LRZDhOKcIFJduVpTYzbnKTIkl3OUrHXVq5xddxX6XP8bUjT+SqGiDf15H6N5flNBsvolMSo0OoQXFiDuY33frQSrSbHbA2p/MptwxA8JgGh4lrbgZZxjTvpO1wATBLDc3wGZkNuy+tNrrHAmE08B7fiExULHxzfaZEWSF"

 certificationAuthorityArrayList = FXCollections~observableArrayList
 certificationAuthorityArrayList~add(value1)
 certificationAuthorityArrayList~add(value2)

 receiptCompactOne = FXCollections~observableArrayList
 receiptCompactTwo = FXCollections~observableArrayList
 certificate = FXCollections~observableArrayList

DO p OVER receiptArrayList
    IF p~certificate = certificate_one THEN DO
        receiptCompactOne~add(p~jws_header || "." || p~jws_payload || "." || p~jws_signature)
    END
    ELSE DO
        certificate_two = p~certificate
        receiptCompactTwo~add(p~jws_header || "." || p~jws_payload || "." || p~jws_signature)
    END

END

 receiptGroup = .array~of("Belege-Gruppe")
 header=.array~of("Signaturzertifikat","Zertifizierungsstellen","Belege-Kompakt")

IF receiptCompactTwo~size <> 0 THEN DO
 content1= .array~of(certificate_one, certificationAuthorityArrayList , receiptCompactOne)
 content2= .array~of(certificate_two, certificationAuthorityArrayList , receiptCompactTwo)
 object1 = Order(header,content1)
 object2 = Order(header,content2)
 group = FXCollections~observableArrayList
 group~add(objet1)
 group~add(objet2)
 groupArr = .array~of(group)
 receiptGroupObject = Order(receiptGroup,groupArr)
END
ELSE DO
 content=.array~of(certificate_one, certificationAuthorityArrayList , receiptCompactOne)
 object = Order(header,content)
 group = FXCollections~observableArrayList
 group~add(object)
 groupArr = .array~of(group)
 receiptGroupObject = Order(receiptGroup,groupArr)
END
 directoryExists = 0

CALL SysFileTree .my.app~homeDir, "file" , "D"  --

DO i = 1 to file.0
    IF file.i~pos("JSON") <> 0 THEN DO
        directoryExists += 1
    END
    ELSE DO
        directoryExists += 0
    END
END

IF directoryExists = 0 THEN DO
    CALL  SysMkDir "JSON"
END
 JSONpath = .my.app~homeDir || "JSON"

 CALL directory  JSONpath

 file = FileWriter~new("DEPExport.json")
 file~write(receiptGroupObject~toJSONString)
 file~flush
 .my.app~stageHandler~showErrorWindow("DEP-Export", "DEP-Export was successful!", "INFORMATION")
 CALL directory .my.app~homeDir

 EXIT 0
------------------------------------------------------------------------------------------------------------------------
::ROUTINE Order PUBLIC
 USE ARG header, content
 JSONObject = bsf.import("org.json.simple.JSONObject")
 sortedObject = JSONObject~new

DO i = 1 to header~size
    sortedObject~put(header[i], content[i])
END

 RETURN sortedObject
------------------------------------------------------------------------------------------------------------------------
::ROUTINE saveDEPExport
 USE ARG sigZert_value, date, newJWSHeader, newJWSPayload, newJWSSignature
 .my.app~databasehandler~insertDEPReceipt(sigZert_value, date, newJWSHeader, newJWSPayload, newJWSSignature)
------------------------------------------------------------------------------------------------------------------------
::ROUTINE reformatFloat PUBLIC
 USE ARG float
 RETURN translate(format2float(float), ",", ".")
------------------------------------------------------------------------------------------------------------------------
::ROUTINE formatStringToFloat PUBLIC
 USE ARG string
 float = string~changeStr(",", ".")
 SIGNAL ON ANY NAME failedInput
 returnV = format(float,,2)
 SIGNAL OFF ANY
 RETURN returnV
 EXIT 0
 failedInput:
     RETURN -1
------------------------------------------------------------------------------------------------------------------------
::ROUTINE format2float PUBLIC
 USE ARG float
 RETURN format(float,,2)
------------------------------------------------------------------------------------------------------------------------
::ROUTINE checkIFPureText PUBLIC
 USE ARG text
 SIGNAL ON ANY NAME notPure
 box("STring", text)
 SIGNAL OFF ANY
 RETURN 1
 EXIT 0
  notPure:
      RETURN -1
------------------------------------------------------------------------------------------------------------------------
::ROUTINE appendTaxText
 USE ARG prevReceipt, sumTablePerTaxRate
 nl="0d0a"x   -- CRLF characters
DO index OVER sumTablePerTaxRate
    IF index = "0.00" THEN DO
        tax = sumTablePerTaxRate[index]
        net = sumTablePerTaxRate[index]
    END
    ELSE DO
        net = format2float(sumTablePerTaxRate[index]/(index+1))
        tax = format2float(sumTablePerTaxRate[index] - net)
    END
    IF sumTablePerTaxRate[index] > 0 THEN DO
        prevReceipt~~append(nl)~~ append("<tr><td>" || format(index*100,,0) || "%"|| "</td><td>" || net || "</td><td>" || tax || "</td><td>" || format(sumTablePerTaxRate[index],,2) || "</td></tr>")
    END
END
 RETURN prevReceipt
------------------------------------------------------------------------------------------------------------------------
::ROUTINE encodeB64URLtoB64
 USE ARG B64URL
 Base64 = bsf.import("java.util.Base64")
 URLdecoder = Base64~getUrlDecoder
 Encoder = Base64~getEncoder
 normalString = URLdecoder~decode(B64URL)
 RETURN Encoder~encodeToString(normalString)
------------------------------------------------------------------------------------------------------------------------
::ROUTINE printingReceipt
 USE ARG companyDetails, productNames, productPrices, productQuantities, totalSum, sumTablePerTaxRate, orderID, tableNr, dateFull

 PARSE VAR dateFull date " " time
 IF tableNr = "Start" | tableNr = "Storno" | tableNr = "Null"  THEN DO
    temp = tableNr
 END
 ELSE  DO
    temp = "TableNr.: " || tableNr
 END
 currPrinter=bsf.importClass("javafx.print.Printer")~getDefaultPrinter
 say "Printer selected: " pp(currPrinter~toString)

 mb=.mutableBuffer~new
 nl="0d0a"x   -- CRLF characters
 mb~~append("<!DOCTYPE html>")
 mb ~~append(nl) ~~append("<html>" -
                          "<center id="top">"-
                          "<div class="logo"></div>"-
                          "<div class="info">"-
                          "<h2> "|| companyDetails["name"] ||"</h2>"-
                          "</div>")
 mb ~~append(nl) ~~append("<div id="mid">"-
                          "<div class="info">"-
                          "<p>"|| companyDetails["address"] || "<br>"-
                            companyDetails["telephone"]||"<br>" -
                            companyDetails["e_mail"] ||"<br>"-
                            companyDetails["vat_ID"] ||"<br>"-
                            "OrderID: "|| orderID ||"<br>"-
                                     temp ||"<br>"-
                                     date ||"<br>"-
                                     time ||"<br>"-
                          "</p>"-
                          "</div>"-
                          "</div>")
 mb ~~append(nl) ~~append("<table style='width: 150px; height: 100px;'>"-
                          "<tbody>"-
                          "<tr class="tabletitle">"-
                          "<td class="item">"-
                          "<h1>Item</h1>"-
                          "</td>"-
                          "<td class="Qty">"-
                          "<h1>Qty</h1>"-
                          "</td>"-
                          "<td class="Sum">"-
                          "<h1>Price</h1>"-
                          "</td>"-
                          "<td class="Total">"-
                          "<h1>Total</h1>"-
                          "</td>"-
                          "</tr>")
DO i=1 TO productNames~items
 mb~~append(nl) ~~append("<tr class="Products">"-
                         "<td class="tableitem">"-
                         "<p class="itemtext">"|| productNames[i] || "</p>"-
                         "</td>"-
                         "<td class="tableitem">"-
                         "<p class="itemtext">"|| productQuantities[i] || "</p>"-
                         "</td>"-
                         "<td class="tableitem">"-
                         "<p class="itemtext">"|| "&euro; "|| productPrices[i] || "</p>"-
                         "</td>"-
                         "<td class="tableitem">"-
                         "<p class="itemtext">"|| "&euro; "|| productPrices[i]*productQuantities[i] || "</p>"-
                         "</td>"-
                         "</tr>")

END
 mb~~append(nl) ~~append("</tbody>"-
                         "</table>"-
                         "</div>")
 mb~~append(nl) ~~append("<div>=============================================</div>")
 mb~~append(nl) ~~append("<h2> Total amount: " || "&euro; "||  totalSum || "</h2>") --<div ><p>Total amount: 14.8</p> </div>
 mb~~append(nl) ~~append("<div>=============================================</div>")
 mb~~append(nl) ~~append("<tr>" -
                         "<th>MWST</th>"-
                          "<th>Net</th>"-
                         "<th>Tax</th>"-
                         "<th>Gross</th>"-
                         "</tr>")
 CALL appendTaxText mb, sumTablePerTaxRate
 filePath = "file:" || .my.app~homeDir || "/qr/qr.png"
 mb~~append(nl) ~~append("</table><br>"-
                         '<img src="' || filePath || '" width="100" height="100"><br>' -
                         .my.app~ActiveUser~firstname || " served you!" || -
                         "<br>" -
                         "Thank you for your purchase. <br> We look forward to seeing you again soon. <br>"-
                         "</span></body></html>"-
                         "</div>"-
                         "</div>")
 mb ~~append(nl) ~~append("</body>")
 mb ~~append(nl) ~~append("</html>")

 done = print(mb~string)
IF done THEN DO
    .my.app~stageHandler~showErrorWindow("Printing job successful!" , "Printing job successful!", "INFORMATION" )
END
ELSE DO
    .my.app~stageHandler~showErrorWindow("Printing job NOT successful!" , "Printing job FAILED", "ERROR" )
END

------------------------------------------------------------------------------------------------------------------------
::ROUTINE firstGUI PUBLIC
 checkIFPOSAdminExists = .my.app~DatabaseHandler~checkIFPOSAdminExists
 checkIFCompanyDataExists = .my.app~DatabaseHandler~checkIFCompanyDataExists
IF \checkIFPOSAdminExists THEN DO
    .my.app~stageHandler~newWindow("Please add an Admin-User", "file:admin.fxml")
END
ELSE IF \checkIFCompanyDataExists THEN DO
    .my.app~stageHandler~newWindow("Please add some Business information", "file:businessInfo.fxml")
END
ELSE DO
    .my.app~stageHandler~newWindow("Login Terminal", "file:login.fxml")

END
------------------------------------------------------------------------------------------------------------------------
::ROUTINE logOut PUBLIC
 .my.app~stageHandler~loadScene("Start", "file:start.fxml")
------------------------------------------------------------------------------------------------------------------------
::ROUTINE generateRandomJWSKeyPrivate PUBLIC
 KeyPairGenerator = bsf.loadClass("java.security.KeyPairGenerator")
 SecureRandom = bsf.import("java.security.SecureRandom")
 Base64 = bsf.import("java.util.Base64")
 Encoder = Base64~getEncoder
 keyGenEC = KeyPairGenerator~getInstance("EC")
 randomValue = SecureRandom~getInstance("SHA1PRNG")
 keyGenEC~initialize(256, randomValue)
 pair = keyGenEC~generateKeyPair
 private = pair~getPrivate~getEncoded
 RETURN Encoder~encodeToString(private)
------------------------------------------------------------------------------------------------------------------------
::ROUTINE generateRandomAESKey PUBLIC
 KeyGenerator = bsf.import("javax.crypto.KeyGenerator")
 Base64 = bsf.import("java.util.Base64")
 keyGenAES = KeyGenerator~getInstance("AES")
 keyGenAES~bsf.invoke("init", 256)
 secretKey = keyGenAES~generateKey
 encodedSecKey = secretKey~getEncoded
 Encoder = Base64~getEncoder
 base64Key = Encoder~encodeToString(encodedSecKey)
 RETURN base64Key
------------------------------------------------------------------------------------------------------------------------
::ROUTINE saveToFile PUBLIC
 USE ARG directory
 directoryExists = 0
 CALL SysFileTree .my.app~homeDir, "file" , "D"

DO i = 1 to file.0
    IF file.i~pos(directory) <> 0 THEN DO
        directoryExists += 1
    END
    ELSE DO
        directoryExists += 0
    END
END

IF directoryExists = 0 THEN DO
    CALL  SysMkDir directory
END
 path = .my.app~homeDir || directory

CALL directory  path

 fileName = directory || ".txt"
 IF directory = "AES" THEN DO
    randomSecreteKey = generateRandomAESKey()
 END
 IF directory = "JWS" THEN DO
    randomSecreteKey = generateRandomJWSKeyPrivate()
 END
 ELSE DO
    say "Directory not required"
 END

IF \SysIsFile(fileName) THEN DO
    Data = .stream~new(fileName)
    Data~open("write replace")
    Data~lineout('[' || directory || 'key data for later use]')
    Data~lineout(directory ||"Key: " || randomSecreteKey )
    Data~close
END

CALL directory .my.app~homeDir

say pp("A file named " || fileName ||" has been generated and stored. This file contains an"|| directory||"-Key," -
"which can be used in the POS-System")
say pp("The key is stored at this path") pp(path)

RETURN randomSecreteKey
------------------------------------------------------------------------------------------------------------------------
::ROUTINE mkDir PUBLIC
 USE ARG directory
 directoryExists = 0
 CALL SysFileTree .my.app~homeDir, "file" , "D"

DO i = 1 to file.0
    IF file.i~pos(directory) <> 0 THEN DO
        directoryExists += 1
    END
    ELSE DO
        directoryExists += 0
    END
END

IF directoryExists = 0 THEN DO
    CALL  SysMkDir directory
END

------------------------------------------------------------------------------------------------------------------------
::REQUIRES "BSF.CLS"
::REQUIRES "DatabaseHandler_v2.CLS"
::REQUIRES "TableH.CLS"
::REQUIRES "AESHandler.CLS"
::REQUIRES "SEHandlerRemote.CLS"
::REQUIRES "SEHandlerOffline.CLS"
::REQUIRES "QRCodeHandler.CLS"

/*   License:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2021 Manuel Schwarzer

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/
