PARSE SOURCE . . fullPath
CALL directory filespec('L', fullPath)

CALL bsf.import "javafx.fxml.FXMLLoader",                      "fx.FXMLLoader"
CALL bsf.import "javafx.scene.Scene",                          "fx.Scene"
CALL bsf.import "javafx.beans.property.SimpleStringProperty",  "fx.SimpleStringProperty"
CALL bsf.import "javafx.beans.property.SimpleIntegerProperty", "fx.SimpleIntegerProperty"

CALL bsf.import "javafx.collections.FXCollections",            "fx.FXCollections"
CALL bsf.import "javafx.stage.Modality",                       "fx.Modality"
CALL bsf.import "javafx.scene.control.Alert",                  "fx.Alert"
CALL bsf.import "javafx.scene.control.Alert$AlertType",        "fx.Alert.Type"

 .environment~my.app=.directory~new
 .my.app~homeDir = filespec('Location',fullPath)
 stageHandler = .StageHandler~new
 .my.app~stageHandler = stageHandler
 .my.app~DatabaseHandler = .DatabaseHandler~new

 fileName = "databaseData.txt"
 .my.app~DatabaseHandler~setDBsettings(fileName)

 stageHandlerProxy = BsfCreateRexxProxy(stageHandler,,"javafx.application.Application")
 SIGNAL ON SYNTAX
 stageHandlerProxy~launch(stageHandlerProxy~getClass, .nil)

 EXIT 0
------------------------------------------------------------------------------------------------------------------------
syntax:
   say "ERROR: Stagehandler failed to load!"
------------------------------------------------------------------------------------------------------------------------
::REQUIRES "BSF.CLS"
::REQUIRES "PasswordHandler.cls"
::REQUIRES "DatabaseHandler_v2.cls"
::REQUIRES "AESHandler.cls"
::REQUIRES "QRCodeHandler.CLS"
------------------------------------------------------------------------------------------------------------------------
::CLASS StageHandler
::ATTRIBUTE primaryStage
::ATTRIBUTE scene
::ATTRIBUTE windowStage
::METHOD start
 EXPOSE primaryStage scene
 USE ARG primaryStage
 primaryStage~setTitle("Start")
 rootLayoutUrl=.bsf~new("java.net.URL", "file:start.fxml")
 rootLayout   =.fx.FXMLLoader~load(rootLayoutUrl)
 scene=.fx.scene~new(rootLayout)
 primaryStage~setScene(scene)
 primaryStage~show
------------------------------------------------------------------------------------------------------------------------
::METHOD loadScene
 EXPOSE primaryStage
 USE ARG title, fileName
 primaryStage~setTitle(title)
 url =.bsf~new("java.net.URL", fileName)
 fxml = .fx.FXMLLoader~load(url)
 primaryStage~getScene~setRoot(fxml)
------------------------------------------------------------------------------------------------------------------------
::METHOD newWindow
 EXPOSE primaryStage windowStage
 USE ARG title, fileName
 windowStage = .bsf~new("javafx.stage.Stage")
 windowStage~setTitle(title)
 url =.bsf~new("java.net.URL", fileName)
 fxml = .fx.FXMLLoader~load(url)
 scene = .bsf~new("javafx.scene.Scene", fxml)
 windowStage~setScene(scene)
 windowStage~initModality(bsf.loadClass("javafx.stage.Modality")~WINDOW_MODAL)
 windowStage~initOwner(primaryStage)
 windowStage~show
------------------------------------------------------------------------------------------------------------------------
::METHOD closeWindow
 EXPOSE primaryStage windowStage
 window = windowStage~getScene~getWindow
 window~close
------------------------------------------------------------------------------------------------------------------------
::METHOD showErrorWindow
 EXPOSE primaryStage windowStage
 USE ARG titel, content, type
IF type == "ERROR" THEN DO
    alert=.fx.alert~new(.fx.Alert.Type~ERROR)
    alert~setHeaderText("An Error has occured!")
END
IF type == "WARNING" THEN DO
    alert=.fx.alert~new(.fx.Alert.Type~WARNING)
    alert~setHeaderText("Something went wrong!")
END
IF type == "INFORMATION" THEN DO
    alert=.fx.alert~new(.fx.Alert.Type~INFORMATION)
    alert~setHeaderText("Success!")
END
 alert~setTitle(titel)
 alert~setContentText(content)
 alert~initOwner(primaryStage)
 alertWindow = alert~getDialogPane~getScene~getWindow
 alertWindow~setAlwaysOnTop(.true)
 alert~showAndWait
------------------------------------------------------------------------------------------------------------------------
::METHOD backToRoot PUBLIC
 EXPOSE primaryStage
 USE ARG title, fileName
 primaryStage~setTitle("POS System - Active")
 url =.bsf~new("java.net.URL", "file:rootLayout_v5.fxml")
 fxml = .fx.FXMLLoader~load(url)
 primaryStage~getScene~setRoot(fxml)

 /*   License:

     ------------------------ Apache Version 2.0 license -------------------------
        Copyright (C) 2021 Manuel Schwarzer

        Licensed under the Apache License, Version 2.0 (the "License");
        you may not use this file except in compliance with the License.
        You may obtain a copy of the License at

            http://www.apache.org/licenses/LICENSE-2.0

        Unless required by applicable law or agreed to in writing, software
        distributed under the License is distributed on an "AS IS" BASIS,
        WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
        See the License for the specific language governing permissions and
        limitations under the License.
     -----------------------------------------------------------------------------
 */

