/*
    This controller manages the tab Products within the menu bar
*/

/*@get(lunchChoiceBox taxChoiceBox prodTableView prodIDColumn prodNameColumn prodPriceColumn prodTaxColumn prodQuantColumn prodLunchColumn prodEditBtn prodDeleteBtn)*/

 FXCollections = bsf.import("javafx.collections.FXCollections")
 observTaxArrList = FXCollections~observableArrayList
 observTaxArrList~add("Please choose one")
 observTaxArrList~add("20%")
 observTaxArrList~add("19%")
 observTaxArrList~add("13%")
 observTaxArrList~add("10%")
 observTaxArrList~add("0%")
 taxChoiceBox~setItems(observTaxArrList)
 taxChoiceBox~setValue("Please choose one")

 observLunchIndArrList = FXCollections~observableArrayList
 observLunchIndArrList~add("Please choose one")
 observLunchIndArrList~add("0")
 observLunchIndArrList~add("1")
 observLunchIndArrList~add("2")
 observLunchIndArrList~add("3")
 lunchChoiceBox~setItems(observLunchIndArrList)
 lunchChoiceBox~setValue("Please choose one")

 productsArrayList = .my.app~DatabaseHandler~getAllProductsArrayList

 SIGNAL ON SYNTAX
 prodHandler = .ProductHandler~new(productsArrayList, prodTableView, prodIDColumn, prodNameColumn, prodPriceColumn, prodTaxColumn, prodQuantColumn, prodLunchColumn)

IF .my.app~EditProduct <> .true THEN DO
    prodEditBtn~visible = .false
END
IF .my.app~deleteProduct <> .true THEN DO
    prodDeleteBtn~visible = .false
END
------------------------------------------------------------------------------------------------------------------------
::ROUTINE showProductDetails PUBLIC
 /*@get( prodTableView prodNameTxtF prodPriceTxtF prodQuantTxtF lunchChoiceBox taxChoiceBox )*/

 item = prodTableView~getSelectionModel~getSelectedItem
 product = BsfRexxProxy(item)
 .my.app~prodID = product~id~get
 prodNameTxtF~text = product~name~get
 prodPriceTxtF~text = product~price~get
 prodQuantTxtF~text = product~quantity~get
 lunchChoiceBox~setValue(product~lunchInd~get)

 taxString = trunc(product~tax~get*100) -- String has to look like '20%' to will be shown in taxChoiceBox
 taxString = taxString || "%"
 taxChoiceBox~setValue(taxString)
------------------------------------------------------------------------------------------------------------------------
::ROUTINE submit PUBLIC
 /*@get( prodTableView prodNameTxtF prodPriceTxtF prodQuantTxtF lunchChoiceBox taxChoiceBox  prodIDColumn prodNameColumn prodPriceColumn prodTaxColumn prodQuantColumn prodLunchColumn)*/
IF .my.app~DatabaseHandler~productAlreadyExists(.my.app~prodID) THEN DO
    IF lunchChoiceBox~getValue = "Please choose one" THEN DO
        .my.app~stageHandler~showErrorWindow("Lunch Index missing" , "Please choose a lunch index", "WARNING" )
    END
    ELSE IF taxChoiceBox~getValue = "Please choose one" THEN DO
        .my.app~stageHandler~showErrorWindow("Tax missing" , "Please choose a tax value", "WARNING" )
    END
    ELSE DO
        IF formatStringToFloat(prodPriceTxtF~text) = -1 | formatStringToFloat(prodQuantTxtF~text) = -1 THEN DO
            .my.app~stageHandler~showErrorWindow("Not a number" , "Something went wrong during the process. Please check if all inputs are correct", "ERROR" )
        END
        ELSE DO
            .my.app~DatabaseHandler~updateProduct(.my.app~prodID, prodNameTxtF~text, formatStringToFloat(prodPriceTxtF~text), prodQuantTxtF~text,lunchChoiceBox~getValue ,taxChoiceBox~getValue)
            productsArrayList = .my.app~DatabaseHandler~getAllProductsArrayList
            prodHandler = .ProductHandler~new(productsArrayList, prodTableView, prodIDColumn, prodNameColumn, prodPriceColumn, prodTaxColumn, prodQuantColumn, prodLunchColumn)
            prodNameTxtF~text = ""
            prodPriceTxtF~text = ""
            prodQuantTxtF~text = ""
            lunchChoiceBox~getSelectionModel~clearSelection
            taxChoiceBox~getSelectionModel~clearSelection
         END
    END
END
ELSE DO
    IF lunchChoiceBox~getValue = "Please choose one" THEN DO
        .my.app~stageHandler~showErrorWindow("Lunch Index missing" , "Please choose a lunch index", "WARNING" )
    END
    ELSE IF taxChoiceBox~getValue = "Please choose one" THEN DO
        .my.app~stageHandler~showErrorWindow("Tax missing" , "Please choose a tax value", "WARNING" )
    END
    ELSE DO
        IF formatStringToFloat(prodPriceTxtF~text) = -1 | formatStringToFloat(prodQuantTxtF~text) = -1 THEN DO
            .my.app~stageHandler~showErrorWindow("Not a number" , "Something went wrong during the process. Please check if all inputs are correct", "ERROR" )
        END
        ELSE DO
            .my.app~DatabaseHandler~insertProduct(prodNameTxtF~text, formatStringToFloat(prodPriceTxtF~text), prodQuantTxtF~text,lunchChoiceBox~getValue ,taxChoiceBox~getValue)
            productsArrayList = .my.app~DatabaseHandler~getAllProductsArrayList
            prodHandler = .ProductHandler~new(productsArrayList, prodTableView, prodIDColumn, prodNameColumn, prodPriceColumn, prodTaxColumn, prodQuantColumn, prodLunchColumn)
            prodNameTxtF~text = ""
            prodPriceTxtF~text = ""
            prodQuantTxtF~text = ""
            lunchChoiceBox~getSelectionModel~clearSelection
            taxChoiceBox~getSelectionModel~clearSelection
         END
    END
END
------------------------------------------------------------------------------------------------------------------------
::ROUTINE delete PUBLIC
 /*@get( prodTableView prodNameTxtF prodPriceTxtF prodQuantTxtF lunchChoiceBox taxChoiceBox  prodIDColumn prodNameColumn prodPriceColumn prodTaxColumn prodQuantColumn prodLunchColumn)*/

IF prodTableView~getSelectionModel~getSelectedItem = .nil THEN DO
    .my.app~stageHandler~showErrorWindow("No Product selected" , "Please choose a product, which should be deleted", "ERROR" )
END
ELSE DO
    item = prodTableView~getSelectionModel~getSelectedItem

    product = BsfRexxProxy(item)

    .my.app~DatabaseHandler~deleteProduct(product~id~get)
    productsArrayList = .my.app~DatabaseHandler~getAllProductsArrayList
    prodHandler = .ProductHandler~new(productsArrayList, prodTableView, prodIDColumn, prodNameColumn, prodPriceColumn, prodTaxColumn, prodQuantColumn, prodLunchColumn)
    prodNameTxtF~text = ""
    prodPriceTxtF~text = ""
    prodQuantTxtF~text = ""
    lunchChoiceBox~getSelectionModel~clearSelection
    taxChoiceBox~getSelectionModel~clearSelection
END
------------------------------------------------------------------------------------------------------------------------
::REQUIRES "BSF.CLS"
::REQUIRES "DatabaseHandler_v2.CLS"
::REQUIRES "TableH.CLS"
::REQUIRES "collection.rexx"


/*   License:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2021 Manuel Schwarzer

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/
