/*
    This controller manages the login process between A-Trust's remote signing device or if needed switches to offline
    signing
*/

::ROUTINE seLogin PUBLIC
 /*@get(seLoginUsername seLoginPassword seLoginButton seLoginLive seLoginTest seLoginOffline)*/
 datetime = .DateTime~new
 PARSE VAR datetime "T" time
IF seLoginOffline~isSelected THEN DO
    .my.app~SEHandlerOffline = .SEHandlerOffline~new
    .my.app~offPay =.true
    .my.app~remotePay = .false
END
ELSE DO

 username = seLoginUsername~text
 password = seLoginPassword~text

    IF seLoginTest~isSelected THEN DO
        loginTest = .true
    END
    ELSE DO
        loginTest = .false
    END

    .my.app~SEHandler = .SEHandler~new
    .my.app~SEHandler~login(username, password, loginTest)

    IF .my.app~SEHandler~seIsOut THEN DO
        .my.app~stageHandler~showErrorWindow("Security Device does not work","Connection to security device failed. Check your internet connection","ERROR")
    END
    ELSE DO
        .my.app~SEHandler~updateSessionDetailsDB
    END
    .my.app~DatabaseHandler~updateSELogin(time)
END
 seLoginUsername~text = ""
 seLoginPassword~text = ""
 .my.app~stageHandler~closeWindow

 EXIT 0

------------------------------------------------------------------------------------------------------------------------
::REQUIRES "BSF.CLS"
::REQUIRES "SEHandlerRemote.CLS"
::REQUIRES "SEHandlerOffline.CLS"


/*   License:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2021 Manuel Schwarzer

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/
