/*
    This file is used to setup a database for the POS-System
    The database will first be created. After that, tables and tax valus will be added,
    so the POS-System is ready to use.
*/
PARSE SOURCE . . fullPath
CALL directory filespec('L', fullPath)

 .environment~my.app=.directory~new
 .my.app~homeDir = filespec('Location',fullPath)
 directoryExists = 0
 fileName = "databaseData.txt"
 .my.app~DatabaseHandler = .DatabaseHandler~new

 DB_NAME = "POSdatabase"

 Call SysFileTree .my.app~homeDir, "database" , "D"

 DO i = 1 to database.0
     IF database.i~pos("DataBase") <> 0 THEN DO
         directoryExists += 1
     END
     ELSE DO
         directoryExists += 0
     END
 END

 IF directoryExists = 0 THEN DO
     CALL  SysMkDir "DataBase"
 END
  DBpath = .my.app~homeDir || "DataBase"

 CALL directory  DBpath

 path = .my.app~homeDir~changeStr("\", "/")
 DB_URL = "jdbc:sqlite:" || path || "DataBase/"|| DB_NAME || ".db"

IF \SysIsFile(fileName) THEN DO
  databaseData = .stream~new(fileName)
  databaseData~open("write replace")
  databaseData~lineout('[DATABASE Data for later use]')
  databaseData~lineout('DB_NAME = ' || DB_NAME )
  databaseData~lineout('DB_URL = ' || DB_URL )
  databaseData~close
END

  CALL directory .my.app~homeDir
 .my.app~DatabaseHandler~setDBsettings(fileName)
 .my.app~DatabaseHandler~connect
 .my.app~DatabaseHandler~insertTables
 .my.app~DatabaseHandler~insertTaxValues
 .my.app~DatabaseHandler~disconnectDB
------------------------------------------------------------------------------------------------------------------------
::REQUIRES "BSF.CLS"
::REQUIRES "DatabaseHandler_v2.CLS"

/*   License:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2021 Manuel Schwarzer

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/
